/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.buffers.DataReader;
import io.helidon.http.DirectHandler;
import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.RequestException;
import io.helidon.http.Status;
import io.helidon.webserver.CloseConnectionException;
import io.helidon.webserver.http.DirectTransportRequest;
import java.nio.charset.StandardCharsets;

public final class Http1Prologue {
    private static final byte[] GET_BYTES = "GET ".getBytes(StandardCharsets.UTF_8);
    private final DataReader reader;
    private final int maxLength;
    private final boolean validatePath;

    public Http1Prologue(DataReader reader, int maxLength, boolean validatePath) {
        this.reader = reader;
        this.maxLength = maxLength;
        this.validatePath = validatePath;
    }

    public HttpPrologue readPrologue() {
        try {
            return this.doRead();
        }
        catch (DataReader.InsufficientDataAvailableException e) {
            throw new CloseConnectionException("No more data available", e);
        }
    }

    private static RequestException badRequest(String message, String method, String path, String protocol, String version) {
        Object protocolAndVersion = protocol.isBlank() && version.isBlank() ? "" : protocol + "/" + version;
        return RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).request(DirectTransportRequest.create((String)protocolAndVersion, method, path)).message(message).safeMessage(false).build();
    }

    private static Method readMethod(DataReader reader, int maxLen) {
        if (reader.startsWith(GET_BYTES)) {
            reader.skip(GET_BYTES.length);
            return Method.GET;
        }
        int firstSpace = reader.findOrNewLine((byte)32, maxLen);
        if (firstSpace < 0) {
            throw Http1Prologue.badRequest("Invalid prologue, missing space " + reader.debugDataHex(), "", "", "", "");
        }
        if (firstSpace == maxLen) {
            throw Http1Prologue.badRequest("Prologue size exceeded", "", "", "", "");
        }
        Method method = Method.create((String)reader.readAsciiString(firstSpace));
        reader.skip(1);
        return method;
    }

    private HttpPrologue doRead() {
        String protocol;
        String path;
        Method method;
        try {
            int maxLen = this.maxLength;
            try {
                method = Http1Prologue.readMethod(this.reader, maxLen);
            }
            catch (IllegalArgumentException e) {
                throw Http1Prologue.badRequest("Invalid prologue, method not valid (" + e.getMessage() + ")", "", "", "", "");
            }
            maxLen -= method.length();
            int secondSpace = this.reader.findOrNewLine((byte)32, --maxLen);
            if (secondSpace < 0) {
                throw Http1Prologue.badRequest("Invalid prologue" + this.reader.debugDataHex(), method.text(), "", "", "");
            }
            if (secondSpace == maxLen) {
                throw RequestException.builder().message("Request URI too long.").type(DirectHandler.EventType.BAD_REQUEST).status(Status.REQUEST_URI_TOO_LONG_414).request(DirectTransportRequest.create("", method.text(), this.reader.readAsciiString(secondSpace))).build();
            }
            path = this.reader.readAsciiString(secondSpace);
            this.reader.skip(1);
            maxLen -= secondSpace;
            int eol = this.reader.findNewLine(--maxLen);
            if (eol == maxLen) {
                throw Http1Prologue.badRequest("Prologue size exceeded", method.text(), path, "", "");
            }
            protocol = this.reader.readAsciiString(eol);
            this.reader.skip(2);
        }
        catch (DataReader.IncorrectNewLineException e) {
            throw RequestException.builder().message("Invalid prologue: " + e.getMessage()).type(DirectHandler.EventType.BAD_REQUEST).cause((Throwable)e).build();
        }
        if (!"HTTP/1.1".equals(protocol)) {
            throw Http1Prologue.badRequest("Invalid protocol and/or version", method.text(), path, protocol, "");
        }
        try {
            return HttpPrologue.create((String)protocol, (String)"HTTP", (String)"1.1", (Method)method, (String)path, (boolean)this.validatePath);
        }
        catch (IllegalArgumentException e) {
            throw Http1Prologue.badRequest("Invalid path: " + e.getMessage(), method.text(), path, "HTTP", "1.1");
        }
    }
}

