/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.webserver.http1.Http1BuilderDecorator;
import io.helidon.webserver.http1.Http1ConfigBlueprint;
import io.helidon.webserver.http1.Http1ConnectionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.webserver.http1.Http1ConfigBlueprint")
public interface Http1Config
extends Http1ConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Http1Config instance) {
        return (Builder)Http1Config.builder().from(instance);
    }

    public static Http1Config create(Config config) {
        return ((Builder)Http1Config.builder().config(config)).buildPrototype();
    }

    public static Http1Config create() {
        return Http1Config.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, Http1Config>
    implements io.helidon.common.Builder<Builder, Http1Config> {
        private Builder() {
        }

        public Http1Config buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.Http1ConfigImpl(this);
        }

        public Http1Config build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Http1Config>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<Http1ConnectionListener> receiveListeners = new ArrayList<Http1ConnectionListener>();
        private final List<Http1ConnectionListener> sendListeners = new ArrayList<Http1ConnectionListener>();
        private boolean continueImmediately = false;
        private boolean receiveLog = true;
        private boolean sendLog = true;
        private boolean validatePath = true;
        private boolean validateRequestHeaders = true;
        private boolean validateResponseHeaders = false;
        private Config config;
        private Http1ConnectionListener compositeReceiveListener;
        private Http1ConnectionListener compositeSendListener;
        private int maxHeadersSize = 16384;
        private int maxPrologueLength = 2048;
        private RequestedUriDiscoveryContext requestedUriDiscovery;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(Http1Config prototype) {
            this.name(prototype.name());
            this.maxPrologueLength(prototype.maxPrologueLength());
            this.maxHeadersSize(prototype.maxHeadersSize());
            this.validateRequestHeaders(prototype.validateRequestHeaders());
            this.validateResponseHeaders(prototype.validateResponseHeaders());
            this.validatePath(prototype.validatePath());
            this.receiveLog(prototype.receiveLog());
            this.sendLog(prototype.sendLog());
            this.continueImmediately(prototype.continueImmediately());
            this.requestedUriDiscovery(prototype.requestedUriDiscovery());
            this.addSendListeners(prototype.sendListeners());
            this.addReceiveListeners(prototype.receiveListeners());
            this.compositeSendListener(prototype.compositeSendListener());
            this.compositeReceiveListener(prototype.compositeReceiveListener());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            this.maxPrologueLength(builder.maxPrologueLength());
            this.maxHeadersSize(builder.maxHeadersSize());
            this.validateRequestHeaders(builder.validateRequestHeaders());
            this.validateResponseHeaders(builder.validateResponseHeaders());
            this.validatePath(builder.validatePath());
            this.receiveLog(builder.receiveLog());
            this.sendLog(builder.sendLog());
            this.continueImmediately(builder.continueImmediately());
            builder.requestedUriDiscovery().ifPresent(this::requestedUriDiscovery);
            this.addSendListeners(builder.sendListeners());
            this.addReceiveListeners(builder.receiveListeners());
            builder.compositeSendListener().ifPresent(this::compositeSendListener);
            builder.compositeReceiveListener().ifPresent(this::compositeReceiveListener);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("max-prologue-length").as(Integer.class).ifPresent(this::maxPrologueLength);
            config.get("max-headers-size").as(Integer.class).ifPresent(this::maxHeadersSize);
            config.get("validate-request-headers").as(Boolean.class).ifPresent(this::validateRequestHeaders);
            config.get("validate-response-headers").as(Boolean.class).ifPresent(this::validateResponseHeaders);
            config.get("validate-path").as(Boolean.class).ifPresent(this::validatePath);
            config.get("recv-log").as(Boolean.class).ifPresent(this::receiveLog);
            config.get("send-log").as(Boolean.class).ifPresent(this::sendLog);
            config.get("continue-immediately").as(Boolean.class).ifPresent(this::continueImmediately);
            config.get("requested-uri-discovery").as(RequestedUriDiscoveryContext.class).ifPresent(this::requestedUriDiscovery);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxPrologueLength(int maxPrologueLength) {
            this.maxPrologueLength = maxPrologueLength;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxHeadersSize(int maxHeadersSize) {
            this.maxHeadersSize = maxHeadersSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER validateRequestHeaders(boolean validateRequestHeaders) {
            this.validateRequestHeaders = validateRequestHeaders;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER validateResponseHeaders(boolean validateResponseHeaders) {
            this.validateResponseHeaders = validateResponseHeaders;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER validatePath(boolean validatePath) {
            this.validatePath = validatePath;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER receiveLog(boolean receiveLog) {
            this.receiveLog = receiveLog;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sendLog(boolean sendLog) {
            this.sendLog = sendLog;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER continueImmediately(boolean continueImmediately) {
            this.continueImmediately = continueImmediately;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER requestedUriDiscovery(RequestedUriDiscoveryContext requestedUriDiscovery) {
            Objects.requireNonNull(requestedUriDiscovery);
            this.requestedUriDiscovery = requestedUriDiscovery;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER requestedUriDiscovery(Consumer<RequestedUriDiscoveryContext.Builder> consumer) {
            Objects.requireNonNull(consumer);
            RequestedUriDiscoveryContext.Builder builder = RequestedUriDiscoveryContext.builder();
            consumer.accept(builder);
            this.requestedUriDiscovery(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER requestedUriDiscovery(Supplier<? extends RequestedUriDiscoveryContext> supplier) {
            Objects.requireNonNull(supplier);
            this.requestedUriDiscovery(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sendListeners(List<? extends Http1ConnectionListener> sendListeners) {
            Objects.requireNonNull(sendListeners);
            this.sendListeners.clear();
            this.sendListeners.addAll(sendListeners);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSendListeners(List<? extends Http1ConnectionListener> sendListeners) {
            Objects.requireNonNull(sendListeners);
            this.sendListeners.addAll(sendListeners);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSendListener(Http1ConnectionListener sendListener) {
            Objects.requireNonNull(sendListener);
            this.sendListeners.add(sendListener);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER receiveListeners(List<? extends Http1ConnectionListener> receiveListeners) {
            Objects.requireNonNull(receiveListeners);
            this.receiveListeners.clear();
            this.receiveListeners.addAll(receiveListeners);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addReceiveListeners(List<? extends Http1ConnectionListener> receiveListeners) {
            Objects.requireNonNull(receiveListeners);
            this.receiveListeners.addAll(receiveListeners);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addReceiveListener(Http1ConnectionListener receiveListener) {
            Objects.requireNonNull(receiveListener);
            this.receiveListeners.add(receiveListener);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER compositeSendListener(Http1ConnectionListener compositeSendListener) {
            Objects.requireNonNull(compositeSendListener);
            this.compositeSendListener = compositeSendListener;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER compositeReceiveListener(Http1ConnectionListener compositeReceiveListener) {
            Objects.requireNonNull(compositeReceiveListener);
            this.compositeReceiveListener = compositeReceiveListener;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public int maxPrologueLength() {
            return this.maxPrologueLength;
        }

        public int maxHeadersSize() {
            return this.maxHeadersSize;
        }

        public boolean validateRequestHeaders() {
            return this.validateRequestHeaders;
        }

        public boolean validateResponseHeaders() {
            return this.validateResponseHeaders;
        }

        public boolean validatePath() {
            return this.validatePath;
        }

        public boolean receiveLog() {
            return this.receiveLog;
        }

        public boolean sendLog() {
            return this.sendLog;
        }

        public boolean continueImmediately() {
            return this.continueImmediately;
        }

        public Optional<RequestedUriDiscoveryContext> requestedUriDiscovery() {
            return Optional.ofNullable(this.requestedUriDiscovery);
        }

        public List<Http1ConnectionListener> sendListeners() {
            return this.sendListeners;
        }

        public List<Http1ConnectionListener> receiveListeners() {
            return this.receiveListeners;
        }

        public Optional<Http1ConnectionListener> compositeSendListener() {
            return Optional.ofNullable(this.compositeSendListener);
        }

        public Optional<Http1ConnectionListener> compositeReceiveListener() {
            return Optional.ofNullable(this.compositeReceiveListener);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "Http1ConfigBuilder{name=" + this.name + ",maxPrologueLength=" + this.maxPrologueLength + ",maxHeadersSize=" + this.maxHeadersSize + ",validateRequestHeaders=" + this.validateRequestHeaders + ",validateResponseHeaders=" + this.validateResponseHeaders + ",validatePath=" + this.validatePath + ",receiveLog=" + this.receiveLog + ",sendLog=" + this.sendLog + ",continueImmediately=" + this.continueImmediately + ",requestedUriDiscovery=" + String.valueOf(this.requestedUriDiscovery) + ",sendListeners=" + String.valueOf(this.sendListeners) + ",receiveListeners=" + String.valueOf(this.receiveListeners) + ",compositeSendListener=" + String.valueOf(this.compositeSendListener) + ",compositeReceiveListener=" + String.valueOf(this.compositeReceiveListener) + "}";
        }

        protected void preBuildPrototype() {
            new Http1BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            if (this.requestedUriDiscovery == null) {
                collector.fatal(this.getClass(), "Property \"requested-uri-discovery\" must not be null, but not set");
            }
            if (this.compositeSendListener == null) {
                collector.fatal(this.getClass(), "Property \"compositeSendListener\" must not be null, but not set");
            }
            if (this.compositeReceiveListener == null) {
                collector.fatal(this.getClass(), "Property \"compositeReceiveListener\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class Http1ConfigImpl
        implements Http1Config {
            private final boolean continueImmediately;
            private final boolean receiveLog;
            private final boolean sendLog;
            private final boolean validatePath;
            private final boolean validateRequestHeaders;
            private final boolean validateResponseHeaders;
            private final Http1ConnectionListener compositeReceiveListener;
            private final Http1ConnectionListener compositeSendListener;
            private final int maxHeadersSize;
            private final int maxPrologueLength;
            private final List<Http1ConnectionListener> receiveListeners;
            private final List<Http1ConnectionListener> sendListeners;
            private final RequestedUriDiscoveryContext requestedUriDiscovery;
            private final String name;

            protected Http1ConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name().get();
                this.maxPrologueLength = builder.maxPrologueLength();
                this.maxHeadersSize = builder.maxHeadersSize();
                this.validateRequestHeaders = builder.validateRequestHeaders();
                this.validateResponseHeaders = builder.validateResponseHeaders();
                this.validatePath = builder.validatePath();
                this.receiveLog = builder.receiveLog();
                this.sendLog = builder.sendLog();
                this.continueImmediately = builder.continueImmediately();
                this.requestedUriDiscovery = builder.requestedUriDiscovery().get();
                this.sendListeners = List.copyOf(builder.sendListeners());
                this.receiveListeners = List.copyOf(builder.receiveListeners());
                this.compositeSendListener = builder.compositeSendListener().get();
                this.compositeReceiveListener = builder.compositeReceiveListener().get();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public int maxPrologueLength() {
                return this.maxPrologueLength;
            }

            @Override
            public int maxHeadersSize() {
                return this.maxHeadersSize;
            }

            @Override
            public boolean validateRequestHeaders() {
                return this.validateRequestHeaders;
            }

            @Override
            public boolean validateResponseHeaders() {
                return this.validateResponseHeaders;
            }

            @Override
            public boolean validatePath() {
                return this.validatePath;
            }

            @Override
            public boolean receiveLog() {
                return this.receiveLog;
            }

            @Override
            public boolean sendLog() {
                return this.sendLog;
            }

            @Override
            public boolean continueImmediately() {
                return this.continueImmediately;
            }

            @Override
            public RequestedUriDiscoveryContext requestedUriDiscovery() {
                return this.requestedUriDiscovery;
            }

            @Override
            public List<Http1ConnectionListener> sendListeners() {
                return this.sendListeners;
            }

            @Override
            public List<Http1ConnectionListener> receiveListeners() {
                return this.receiveListeners;
            }

            @Override
            public Http1ConnectionListener compositeSendListener() {
                return this.compositeSendListener;
            }

            @Override
            public Http1ConnectionListener compositeReceiveListener() {
                return this.compositeReceiveListener;
            }

            public String toString() {
                return "Http1Config{name=" + this.name + ",maxPrologueLength=" + this.maxPrologueLength + ",maxHeadersSize=" + this.maxHeadersSize + ",validateRequestHeaders=" + this.validateRequestHeaders + ",validateResponseHeaders=" + this.validateResponseHeaders + ",validatePath=" + this.validatePath + ",receiveLog=" + this.receiveLog + ",sendLog=" + this.sendLog + ",continueImmediately=" + this.continueImmediately + ",requestedUriDiscovery=" + String.valueOf(this.requestedUriDiscovery) + ",sendListeners=" + String.valueOf(this.sendListeners) + ",receiveListeners=" + String.valueOf(this.receiveListeners) + ",compositeSendListener=" + String.valueOf(this.compositeSendListener) + ",compositeReceiveListener=" + String.valueOf(this.compositeReceiveListener) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Http1Config)) {
                    return false;
                }
                Http1Config other = (Http1Config)o;
                return Objects.equals(this.name, other.name()) && this.maxPrologueLength == other.maxPrologueLength() && this.maxHeadersSize == other.maxHeadersSize() && this.validateRequestHeaders == other.validateRequestHeaders() && this.validateResponseHeaders == other.validateResponseHeaders() && this.validatePath == other.validatePath() && this.receiveLog == other.receiveLog() && this.sendLog == other.sendLog() && this.continueImmediately == other.continueImmediately() && Objects.equals(this.requestedUriDiscovery, other.requestedUriDiscovery()) && Objects.equals(this.sendListeners, other.sendListeners()) && Objects.equals(this.receiveListeners, other.receiveListeners()) && Objects.equals(this.compositeSendListener, other.compositeSendListener()) && Objects.equals(this.compositeReceiveListener, other.compositeReceiveListener());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.maxPrologueLength, this.maxHeadersSize, this.validateRequestHeaders, this.validateResponseHeaders, this.validatePath, this.receiveLog, this.sendLog, this.continueImmediately, this.requestedUriDiscovery, this.sendListeners, this.receiveListeners, this.compositeSendListener, this.compositeReceiveListener);
            }
        }
    }
}

