/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.http.Method;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouteBase;
import io.helidon.webserver.http.HttpRouteImpl;
import io.helidon.webserver.http.HttpRouteWrap;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.ServiceRoute;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

class ServiceRules
implements HttpRules {
    private static final Predicate<Method> ALWAYS_PREDICATE = new TruePredicate();
    private final HttpService theService;
    private final PathMatcher pathMatcher;
    private final Predicate<Method> methodPredicate;
    private final List<HttpRouteBase> routes = new LinkedList<HttpRouteBase>();

    ServiceRules() {
        this.theService = new NoOpService();
        this.pathMatcher = PathMatchers.any();
        this.methodPredicate = ALWAYS_PREDICATE;
    }

    ServiceRules(HttpService theService, PathMatcher pathMatcher, Predicate<Method> methodPredicate) {
        this.theService = theService;
        this.pathMatcher = pathMatcher;
        this.methodPredicate = methodPredicate;
    }

    @Override
    public HttpRules register(Supplier<? extends HttpService> ... services) {
        for (Supplier<? extends HttpService> service : services) {
            HttpService theService = service.get();
            ServiceRules subRules = new ServiceRules(theService, PathMatchers.any(), ALWAYS_PREDICATE);
            theService.routing(subRules);
            this.routes.add(subRules.build());
        }
        return this;
    }

    @Override
    public HttpRules register(String pathPattern, Supplier<? extends HttpService> ... services) {
        for (Supplier<? extends HttpService> service : services) {
            HttpService theService = service.get();
            ServiceRules subRules = new ServiceRules(theService, PathMatchers.create((String)pathPattern), ALWAYS_PREDICATE);
            theService.routing(subRules);
            this.routes.add(subRules.build());
        }
        return this;
    }

    @Override
    public HttpRules route(HttpRoute route) {
        if (route instanceof HttpRouteImpl) {
            HttpRouteImpl impl = (HttpRouteImpl)route;
            this.routes.add(impl);
        } else {
            this.routes.add(new HttpRouteWrap(route));
        }
        return this;
    }

    ServiceRoute build() {
        return new ServiceRoute(this.theService, this.methodPredicate, this.pathMatcher, this.routes);
    }

    private static final class NoOpService
    implements HttpService {
        private NoOpService() {
        }

        @Override
        public void routing(HttpRules rules) {
        }

        public String toString() {
            return "root";
        }
    }

    private static final class TruePredicate
    implements Predicate<Method> {
        private TruePredicate() {
        }

        @Override
        public boolean test(Method httpMethod) {
            return true;
        }

        public String toString() {
            return "any method";
        }
    }
}

