/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.common.Weighted;
import io.helidon.webserver.http.ErrorHandler;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpService;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

class HttpRoutingFeature
implements HttpFeature,
Weighted {
    private final List<Registration> registrations = new ArrayList<Registration>();

    HttpRoutingFeature() {
    }

    @Override
    public void setup(HttpRouting.Builder routing) {
        this.registrations.forEach(it -> it.register(routing));
    }

    void filter(Filter filter) {
        this.registrations.add(new FilterReg(filter));
    }

    <T extends Throwable> void error(Class<T> exceptionClass, ErrorHandler<? super T> handler) {
        this.registrations.add(new ErrorReg<T>(exceptionClass, handler));
    }

    void service(Supplier<? extends HttpService> ... services) {
        this.registrations.add(new ServiceReg(services));
    }

    void service(String path, Supplier<? extends HttpService> ... services) {
        this.registrations.add(new ServicePathReg(path, services));
    }

    void route(HttpRoute route) {
        this.registrations.add(new RouteReg(route));
    }

    private record FilterReg(Filter filter) implements Registration
    {
        @Override
        public void register(HttpRouting.Builder routing) {
            routing.addFilter(this.filter);
        }
    }

    private record ErrorReg<T extends Throwable>(Class<T> exceptionClass, ErrorHandler<? super T> handler) implements Registration
    {
        @Override
        public void register(HttpRouting.Builder routing) {
            routing.error(this.exceptionClass, this.handler);
        }
    }

    private record ServiceReg(Supplier<? extends HttpService>[] services) implements Registration
    {
        @Override
        public void register(HttpRouting.Builder routing) {
            routing.register((Supplier[])this.services);
        }
    }

    private record ServicePathReg(String path, Supplier<? extends HttpService>[] services) implements Registration
    {
        @Override
        public void register(HttpRouting.Builder routing) {
            routing.register(this.path, (Supplier[])this.services);
        }
    }

    private record RouteReg(HttpRoute route) implements Registration
    {
        @Override
        public void register(HttpRouting.Builder routing) {
            routing.route(this.route);
        }
    }

    private static interface Registration {
        public void register(HttpRouting.Builder var1);
    }
}

