/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.config.Config;
import io.helidon.common.context.Context;
import io.helidon.common.socket.SocketOptions;
import io.helidon.common.tls.Tls;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.media.MediaContext;
import io.helidon.webserver.ConnectionConfig;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Routing;
import io.helidon.webserver.http.DirectHandlers;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.spi.ProtocolConfig;
import io.helidon.webserver.spi.ProtocolConfigProvider;
import io.helidon.webserver.spi.ServerConnectionSelector;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Configured
@Prototype.Blueprint(decorator=ConfigDecorator.class)
interface ListenerConfigBlueprint {
    @ConfiguredOption(provider=true, providerType=ProtocolConfigProvider.class)
    @Option.Singular
    public List<ProtocolConfig> protocols();

    public Optional<HttpRouting> routing();

    @Option.Singular
    public List<Routing> routings();

    @ConfiguredOption(value="@default")
    public String name();

    @ConfiguredOption(value="0.0.0.0")
    public String host();

    public InetAddress address();

    @ConfiguredOption(value="0")
    public int port();

    @ConfiguredOption(value="1024")
    public int backlog();

    @ConfiguredOption(value="-1")
    public long maxPayloadSize();

    @ConfiguredOption
    public Optional<Integer> receiveBufferSize();

    @ConfiguredOption(value="0")
    public int writeQueueLength();

    @ConfiguredOption(value="512")
    public int writeBufferSize();

    @ConfiguredOption(value="PT0.5S")
    public Duration shutdownGracePeriod();

    public Optional<ConnectionConfig> connectionConfig();

    @ConfiguredOption
    public Optional<Tls> tls();

    @ConfiguredOption
    public Optional<ContentEncodingContext> contentEncoding();

    @ConfiguredOption
    public Optional<MediaContext> mediaContext();

    @ConfiguredOption
    public SocketOptions connectionOptions();

    @ConfiguredOption(value="-1")
    public int maxTcpConnections();

    @ConfiguredOption(value="-1")
    public int maxConcurrentRequests();

    @ConfiguredOption(value="PT5M")
    public Duration idleConnectionTimeout();

    @ConfiguredOption(value="PT2M")
    public Duration idleConnectionPeriod();

    @ConfiguredOption(value="131072")
    public int maxInMemoryEntity();

    @Option.Singular
    @Option.SameGeneric
    public Map<SocketOption<?>, Object> listenerSocketOptions();

    @Option.Singular
    public List<ServerConnectionSelector> connectionSelectors();

    public Optional<DirectHandlers> directHandlers();

    public Optional<Context> listenerContext();

    public RequestedUriDiscoveryContext requestedUriDiscoveryContext();

    default public void configureSocket(ServerSocket socket) {
        for (Map.Entry<SocketOption<?>, Object> entry : this.listenerSocketOptions().entrySet()) {
            try {
                SocketOption<?> opt = entry.getKey();
                socket.setOption(opt, entry.getValue());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static class ConfigDecorator
    implements Prototype.BuilderDecorator<ListenerConfig.BuilderBase<?, ?>> {
        public void decorate(ListenerConfig.BuilderBase<?, ?> target) {
            Map<SocketOption<?>, Object> socketOptions;
            Config config;
            String name = target.name();
            if (name == null && target.config().isPresent() && (config = target.config().get()).exists()) {
                target.name((String)config.get("name").asString().orElse((Object)config.name()));
            }
            if ((name = target.name()) == null) {
                target.name("@default");
            }
            if (target.connectionOptions().isEmpty()) {
                target.connectionOptions(SocketOptions.create());
            }
            if (target.address().isEmpty()) {
                try {
                    target.address(InetAddress.getByName(target.host()));
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("Failed to get address from host: " + target.host(), e);
                }
            }
            if (!(socketOptions = target.listenerSocketOptions()).containsKey(StandardSocketOptions.SO_REUSEADDR)) {
                target.putListenerSocketOption(StandardSocketOptions.SO_REUSEADDR, true);
            }
            if (!socketOptions.containsKey(StandardSocketOptions.SO_RCVBUF)) {
                target.putListenerSocketOption(StandardSocketOptions.SO_RCVBUF, 4096);
            }
            if (target.requestedUriDiscoveryContext().isEmpty()) {
                target.requestedUriDiscoveryContext(RequestedUriDiscoveryContext.builder().socketId(target.name()).build());
            }
        }
    }
}

