/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.GenericType;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.http.HttpException;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.MediaContext;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http.ServerResponseBase;
import io.helidon.webserver.http.spi.Sink;
import io.helidon.webserver.http.spi.SinkProvider;
import io.helidon.webserver.http1.Http1ConnectionListener;
import io.helidon.webserver.http1.Http1ServerRequest;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;

class Http1ServerResponse
extends ServerResponseBase<Http1ServerResponse> {
    private static final byte[] HTTP_BYTES = "HTTP/1.1 ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] OK_200 = "HTTP/1.1 200 OK\r\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DATE = "Date: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TERMINATING_CHUNK = "0\r\n\r\n".getBytes(StandardCharsets.UTF_8);
    private static final Http.HeaderName STREAM_STATUS_NAME = Http.HeaderNames.create((String)"stream-status");
    private static final Http.HeaderName STREAM_RESULT_NAME = Http.HeaderNames.create((String)"stream-result");
    private static final Http.Header STREAM_TRAILERS = Http.Headers.create((Http.HeaderName)Http.HeaderNames.TRAILER, (String)(STREAM_STATUS_NAME.defaultCase() + "," + STREAM_RESULT_NAME.defaultCase()));
    private static final List<SinkProvider> SINK_PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(SinkProvider.class)).build().asList();
    private static final WritableHeaders<?> EMPTY_HEADERS = WritableHeaders.create();
    private final ConnectionContext ctx;
    private final Http1ConnectionListener sendListener;
    private final DataWriter dataWriter;
    private final Http1ServerRequest request;
    private final ServerResponseHeaders headers;
    private final WritableHeaders<?> trailers = WritableHeaders.create();
    private final boolean keepAlive;
    private boolean streamingEntity;
    private boolean isSent;
    private ClosingBufferedOutputStream outputStream;
    private long bytesWritten;
    private String streamResult = "";
    private final boolean validateHeaders;

    Http1ServerResponse(ConnectionContext ctx, Http1ConnectionListener sendListener, DataWriter dataWriter, Http1ServerRequest request, boolean keepAlive, boolean validateHeaders) {
        super(ctx, request);
        this.ctx = ctx;
        this.sendListener = sendListener;
        this.dataWriter = dataWriter;
        this.request = request;
        this.headers = ServerResponseHeaders.create();
        this.keepAlive = keepAlive;
        this.validateHeaders = validateHeaders;
    }

    static void nonEntityBytes(ServerResponseHeaders headers, Http.Status status, BufferData buffer, boolean keepAlive, boolean validateHeaders) {
        if (status == null || status == Http.Status.OK_200) {
            buffer.write(OK_200);
        } else {
            buffer.write(HTTP_BYTES);
            String reasonPhrase = status.reasonPhrase().isEmpty() ? status.codeText() : status.reasonPhrase();
            buffer.write((status.code() + " " + reasonPhrase).getBytes(StandardCharsets.US_ASCII));
            buffer.write(13);
            buffer.write(10);
        }
        if (!headers.contains(Http.HeaderNames.DATE)) {
            buffer.write(DATE);
            byte[] dateBytes = Http.DateTime.http1Bytes();
            buffer.write(dateBytes);
        }
        if (keepAlive) {
            headers.setIfAbsent(Http.Headers.CONNECTION_KEEP_ALIVE);
        } else {
            headers.set(Http.Headers.CONNECTION_CLOSE);
        }
        Http1ServerResponse.writeHeaders((Headers)headers, buffer, validateHeaders);
        buffer.write(13);
        buffer.write(10);
    }

    @Override
    public Http1ServerResponse header(Http.Header header) {
        this.headers.set(header);
        return this;
    }

    @Override
    public void send(byte[] bytes) {
        byte[] entity = this.entityBytes(bytes);
        BufferData bufferData = this.responseBuffer(entity);
        this.bytesWritten = bufferData.available();
        this.isSent = true;
        this.request.reset();
        this.dataWriter.write(bufferData);
        this.afterSend();
    }

    @Override
    public boolean isSent() {
        return this.isSent;
    }

    @Override
    public OutputStream outputStream() {
        if (this.isSent) {
            throw new IllegalStateException("Response already sent");
        }
        if (this.streamingEntity) {
            throw new IllegalStateException("OutputStream already obtained");
        }
        this.streamingEntity = true;
        BlockingOutputStream bos = new BlockingOutputStream(this.headers, this.trailers, this::status, () -> this.streamResult, this.dataWriter, () -> {
            this.isSent = true;
            this.afterSend();
            this.request.reset();
        }, this.ctx, this.sendListener, this.request, this.keepAlive, this.validateHeaders);
        int writeBufferSize = this.ctx.listenerContext().config().writeBufferSize();
        this.outputStream = new ClosingBufferedOutputStream(bos, writeBufferSize);
        return this.contentEncode(this.outputStream);
    }

    @Override
    public long bytesWritten() {
        if (this.streamingEntity) {
            return this.outputStream.totalBytesWritten();
        }
        return this.bytesWritten;
    }

    @Override
    public ServerResponseHeaders headers() {
        return this.headers;
    }

    @Override
    public void streamResult(String result) {
        this.streamResult = result;
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    @Override
    public boolean hasEntity() {
        return this.isSent || this.streamingEntity;
    }

    @Override
    public boolean reset() {
        if (this.isSent || this.outputStream != null && this.outputStream.totalBytesWritten() > 0L) {
            return false;
        }
        this.headers.clear();
        this.streamingEntity = false;
        this.outputStream = null;
        return true;
    }

    @Override
    public void commit() {
        if (this.outputStream != null) {
            this.outputStream.commit();
        }
    }

    public <X extends Sink<?>> X sink(GenericType<X> sinkType) {
        for (SinkProvider p : SINK_PROVIDERS) {
            if (!p.supports(sinkType, this.request)) continue;
            return p.create(this, this::handleSinkData, this::commit);
        }
        throw new HttpException("Unable to find sink provider for request", Http.Status.NOT_ACCEPTABLE_406);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleSinkData(Object data, MediaType mediaType) {
        if (this.outputStream == null) {
            this.outputStream();
        }
        try {
            MediaContext mediaContext = this.mediaContext();
            if (data instanceof byte[]) {
                byte[] bytes = (byte[])data;
                this.outputStream.write(bytes);
                return;
            }
            if (data instanceof String) {
                String str = (String)data;
                if (mediaType.equals((Object)MediaTypes.TEXT_PLAIN)) {
                    EntityWriter writer = mediaContext.writer(GenericType.STRING, EMPTY_HEADERS, EMPTY_HEADERS);
                    writer.write(GenericType.STRING, (Object)str, (OutputStream)this.outputStream, EMPTY_HEADERS, EMPTY_HEADERS);
                    return;
                }
            }
            GenericType type = GenericType.create((Object)data);
            WritableHeaders resHeaders = WritableHeaders.create();
            resHeaders.set(Http.HeaderNames.CONTENT_TYPE, new String[]{mediaType.text()});
            EntityWriter writer = mediaContext.writer(type, EMPTY_HEADERS, resHeaders);
            writer.write(type, data, (OutputStream)this.outputStream, EMPTY_HEADERS, resHeaders);
            return;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void writeHeaders(Headers headers, BufferData buffer, boolean validate) {
        if (validate) {
            headers.forEach(Http.Header::validate);
        }
        for (Http.Header header : headers) {
            header.writeHttp1Header(buffer);
        }
    }

    private BufferData responseBuffer(byte[] bytes) {
        if (this.isSent) {
            throw new IllegalStateException("Response already sent");
        }
        if (this.streamingEntity) {
            throw new IllegalStateException("When output stream is used, response is completed by closing the output stream, do not call send().");
        }
        int contentLength = bytes.length;
        boolean forcedChunkedEncoding = false;
        this.headers.setIfAbsent(Http.Headers.CONNECTION_KEEP_ALIVE);
        if (this.headers.contains(Http.Headers.TRANSFER_ENCODING_CHUNKED)) {
            this.headers.remove(Http.HeaderNames.CONTENT_LENGTH);
            forcedChunkedEncoding = true;
        } else if (!this.headers.contains(Http.HeaderNames.CONTENT_LENGTH)) {
            this.headers.contentLength((long)contentLength);
        }
        Http.Status usedStatus = this.status();
        this.sendListener.status(this.ctx, usedStatus);
        this.sendListener.headers(this.ctx, (Headers)this.headers);
        BufferData responseBuffer = BufferData.growing((int)(256 + bytes.length));
        Http1ServerResponse.nonEntityBytes(this.headers, usedStatus, responseBuffer, this.keepAlive, this.validateHeaders);
        if (forcedChunkedEncoding) {
            byte[] hex = Integer.toHexString(contentLength).getBytes(StandardCharsets.US_ASCII);
            responseBuffer.write(hex);
            responseBuffer.write(13);
            responseBuffer.write(10);
            responseBuffer.write(bytes);
            responseBuffer.write(13);
            responseBuffer.write(10);
            responseBuffer.write(TERMINATING_CHUNK);
        } else {
            responseBuffer.write(bytes);
        }
        this.sendListener.data(this.ctx, responseBuffer);
        return responseBuffer;
    }

    private static class BlockingOutputStream
    extends OutputStream {
        private final ServerResponseHeaders headers;
        private final WritableHeaders<?> trailers;
        private final Supplier<Http.Status> status;
        private final DataWriter dataWriter;
        private final Runnable responseCloseRunnable;
        private final ConnectionContext ctx;
        private final Http1ConnectionListener sendListener;
        private final Http1ServerRequest request;
        private final boolean keepAlive;
        private final Supplier<String> streamResult;
        private final boolean forcedChunked;
        private BufferData firstBuffer;
        private boolean closed;
        private long bytesWritten;
        private long contentLength;
        private boolean isChunked;
        private boolean firstByte = true;
        private long responseBytesTotal;
        private boolean closing = false;
        private boolean validateHeaders = false;

        private BlockingOutputStream(ServerResponseHeaders headers, WritableHeaders<?> trailers, Supplier<Http.Status> status, Supplier<String> streamResult, DataWriter dataWriter, Runnable responseCloseRunnable, ConnectionContext ctx, Http1ConnectionListener sendListener, Http1ServerRequest request, boolean keepAlive, boolean validateHeaders) {
            this.headers = headers;
            this.trailers = trailers;
            this.status = status;
            this.streamResult = streamResult;
            this.dataWriter = dataWriter;
            this.responseCloseRunnable = responseCloseRunnable;
            this.ctx = ctx;
            this.sendListener = sendListener;
            this.isChunked = !headers.contains(Http.HeaderNames.CONTENT_LENGTH);
            this.contentLength = headers.contentLength().orElse(-1L);
            this.request = request;
            this.keepAlive = keepAlive;
            this.forcedChunked = headers.contains(Http.Headers.TRANSFER_ENCODING_CHUNKED);
            this.validateHeaders = validateHeaders;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(BufferData.create((int)1).write(b));
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(BufferData.create((byte[])b));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.write(BufferData.create((byte[])b, (int)off, (int)len));
        }

        @Override
        public void flush() throws IOException {
            if (this.closing) {
                return;
            }
            if (this.firstByte && this.firstBuffer != null) {
                this.write(BufferData.empty());
            }
        }

        @Override
        public void close() {
        }

        public void closing() {
            this.closing = true;
        }

        void commit() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.firstByte) {
                if (this.forcedChunked && this.firstBuffer != null) {
                    this.sendHeadersAndPrepare();
                    this.writeChunked(this.firstBuffer);
                    this.terminatingChunk();
                } else {
                    this.sendFirstChunkOnly();
                }
            } else if (this.isChunked) {
                this.terminatingChunk();
            }
            if ((this.isChunked || this.forcedChunked) && this.request.headers().contains(Http.Headers.TE_TRAILERS)) {
                this.trailers.set(STREAM_STATUS_NAME, new String[]{String.valueOf(this.status.get().code())});
                this.trailers.set(STREAM_RESULT_NAME, new String[]{this.streamResult.get()});
                BufferData buffer = BufferData.growing((int)128);
                Http1ServerResponse.writeHeaders(this.trailers, buffer, this.validateHeaders);
                buffer.write(13);
                buffer.write(10);
                this.dataWriter.write(buffer);
            }
            this.responseCloseRunnable.run();
            try {
                super.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        long totalBytesWritten() {
            return this.responseBytesTotal;
        }

        private void terminatingChunk() {
            BufferData terminatingChunk = BufferData.create((byte[])TERMINATING_CHUNK);
            this.sendListener.data(this.ctx, terminatingChunk);
            this.dataWriter.write(terminatingChunk);
        }

        private void write(BufferData buffer) throws IOException {
            if (this.closed) {
                throw new IOException("Stream already closed");
            }
            if (!this.isChunked) {
                if (this.firstByte) {
                    this.firstByte = false;
                    Http.Status usedStatus = this.status.get();
                    this.sendListener.status(this.ctx, usedStatus);
                    this.sendListener.headers(this.ctx, (Headers)this.headers);
                    BufferData growing = BufferData.growing((int)(256 + buffer.available()));
                    Http1ServerResponse.nonEntityBytes(this.headers, usedStatus, growing, this.keepAlive, this.validateHeaders);
                    this.bytesWritten += (long)buffer.available();
                    this.checkContentLength(buffer);
                    this.sendListener.data(this.ctx, buffer);
                    growing.write(buffer);
                    this.responseBytesTotal += (long)growing.available();
                    this.dataWriter.write(growing);
                } else {
                    this.writeContent(buffer);
                }
                return;
            }
            if (this.firstByte && this.firstBuffer == null) {
                this.firstBuffer = buffer.copy();
                return;
            }
            if (this.firstByte) {
                if (this.request.headers().contains(Http.Headers.TE_TRAILERS)) {
                    this.headers.add(STREAM_TRAILERS);
                }
                this.sendHeadersAndPrepare();
                this.firstByte = false;
                BufferData combined = BufferData.create((BufferData[])new BufferData[]{this.firstBuffer, buffer});
                this.writeChunked(combined);
                this.firstBuffer = null;
            } else {
                this.writeChunked(buffer);
            }
        }

        private void sendFirstChunkOnly() {
            int contentLength;
            if (this.firstBuffer == null) {
                this.headers.set(Http.Headers.CONTENT_LENGTH_ZERO);
                contentLength = 0;
            } else {
                this.headers.set(Http.Headers.create((Http.HeaderName)Http.HeaderNames.CONTENT_LENGTH, (String)String.valueOf(this.firstBuffer.available())));
                contentLength = this.firstBuffer.available();
            }
            this.isChunked = false;
            this.headers.remove(Http.HeaderNames.TRANSFER_ENCODING);
            Http.Status usedStatus = this.status.get();
            this.sendListener.status(this.ctx, usedStatus);
            this.sendListener.headers(this.ctx, (Headers)this.headers);
            BufferData bufferData = BufferData.growing((int)(contentLength + 256));
            Http1ServerResponse.nonEntityBytes(this.headers, usedStatus, bufferData, this.keepAlive, this.validateHeaders);
            if (this.firstBuffer != null) {
                bufferData.write(this.firstBuffer);
            }
            this.sendListener.data(this.ctx, bufferData);
            this.responseBytesTotal += (long)bufferData.available();
            this.dataWriter.write(bufferData);
        }

        private void sendHeadersAndPrepare() {
            if (this.headers.contains(Http.HeaderNames.CONTENT_LENGTH)) {
                this.contentLength = this.headers.contentLength().orElse(-1L);
                this.isChunked = false;
            } else {
                this.contentLength = -1L;
                if (!this.headers.contains(Http.HeaderNames.TRANSFER_ENCODING)) {
                    this.headers.set(Http.Headers.TRANSFER_ENCODING_CHUNKED);
                } else if (!this.headers.contains(Http.Headers.TRANSFER_ENCODING_CHUNKED)) {
                    this.headers.add(Http.Headers.TRANSFER_ENCODING_CHUNKED);
                }
            }
            Http.Status usedStatus = this.status.get();
            this.sendListener.status(this.ctx, usedStatus);
            this.sendListener.headers(this.ctx, (Headers)this.headers);
            BufferData bufferData = BufferData.growing((int)256);
            Http1ServerResponse.nonEntityBytes(this.headers, usedStatus, bufferData, this.keepAlive, this.validateHeaders);
            this.sendListener.data(this.ctx, bufferData);
            this.responseBytesTotal += (long)bufferData.available();
            this.dataWriter.write(bufferData);
        }

        private void writeChunked(BufferData buffer) {
            int available = buffer.available();
            byte[] hex = Integer.toHexString(available).getBytes(StandardCharsets.US_ASCII);
            BufferData toWrite = BufferData.create((int)(available + hex.length + 4));
            toWrite.write(hex);
            toWrite.write(13);
            toWrite.write(10);
            toWrite.write(buffer);
            toWrite.write(13);
            toWrite.write(10);
            this.sendListener.data(this.ctx, toWrite);
            this.responseBytesTotal += (long)toWrite.available();
            this.dataWriter.write(toWrite);
        }

        private void checkContentLength(BufferData ignored) throws IOException {
            if (this.bytesWritten > this.contentLength && this.contentLength != -1L) {
                throw new IOException("Content length was set to " + this.contentLength + ", but you are writing additional " + (this.bytesWritten - this.contentLength) + " bytes");
            }
        }

        private void writeContent(BufferData buffer) throws IOException {
            this.bytesWritten += (long)buffer.available();
            this.checkContentLength(buffer);
            this.sendListener.data(this.ctx, buffer);
            this.responseBytesTotal += (long)buffer.available();
            this.dataWriter.write(buffer);
        }
    }

    static class ClosingBufferedOutputStream
    extends BufferedOutputStream {
        private final BlockingOutputStream delegate;

        ClosingBufferedOutputStream(BlockingOutputStream out, int size) {
            super(out, size);
            this.delegate = out;
        }

        @Override
        public void close() {
            this.delegate.closing();
            try {
                super.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        long totalBytesWritten() {
            return this.delegate.totalBytesWritten();
        }

        void commit() {
            try {
                this.flush();
                this.delegate.commit();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

