/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.LazyValue;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.http.HttpPrologue;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.media.ReadableEntity;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.ServerRequestEntity;
import io.helidon.webserver.http1.Http1Config;
import io.helidon.webserver.http1.Http1Connection;
import io.helidon.webserver.http1.Http1ServerRequest;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;

final class Http1ServerRequestWithEntity
extends Http1ServerRequest {
    private static final System.Logger LOGGER = System.getLogger(Http1ServerRequestWithEntity.class.getName());
    private final LazyValue<ReadableEntity> entity;
    private final ConnectionContext ctx;
    private final Http1Connection connection;
    private final boolean expectContinue;
    private final boolean continueImmediately;
    private boolean continueSent;

    Http1ServerRequestWithEntity(ConnectionContext ctx, Http1Connection connection, Http1Config http1Config, HttpSecurity security, HttpPrologue prologue, ServerRequestHeaders headers, ContentDecoder decoder, int requestId, boolean expectContinue, CountDownLatch entityReadLatch, Supplier<BufferData> readEntityFromPipeline) {
        super(ctx, security, prologue, (Headers)headers, requestId);
        this.ctx = ctx;
        this.connection = connection;
        this.expectContinue = expectContinue;
        this.continueImmediately = http1Config.continueImmediately();
        this.continueSent = this.continueImmediately || !expectContinue;
        this.entity = LazyValue.create(() -> ServerRequestEntity.create(this::trySend100, decoder, arg_0 -> Http1ServerRequestWithEntity.lambda$new$0((Supplier)readEntityFromPipeline, arg_0), entityReadLatch::countDown, headers, ctx.listenerContext().mediaContext()));
    }

    @Override
    public ReadableEntity content() {
        return (ReadableEntity)this.entity.get();
    }

    @Override
    public void reset() {
        if (!this.continueSent) {
            this.connection.reset();
        }
    }

    @Override
    public boolean continueSent() {
        return this.continueSent;
    }

    private void trySend100(boolean drain) {
        if (!this.continueImmediately && this.expectContinue && !drain) {
            BufferData buffer = BufferData.create((byte[])Http1Connection.CONTINUE_100);
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "send: status %s", new Object[]{Http.Status.CONTINUE_100});
                this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "send %n%s", new Object[]{buffer.debugDataHex()});
            }
            this.ctx.dataWriter().writeNow(buffer);
            this.continueSent = true;
        }
    }

    private static /* synthetic */ BufferData lambda$new$0(Supplier readEntityFromPipeline, Integer it) {
        return (BufferData)readEntityFromPipeline.get();
    }
}

