/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.common.GenericType;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriPath;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.http.HttpException;
import io.helidon.http.HttpPrologue;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentEncoder;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.InstanceWriter;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.UnsupportedTypeException;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http.RoutingResponse;
import io.helidon.webserver.http.ServerRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;

public abstract class ServerResponseBase<T extends ServerResponseBase<T>>
implements RoutingResponse {
    private final ContentEncodingContext contentEncodingContext;
    private final MediaContext mediaContext;
    private final ServerRequestHeaders requestHeaders;
    private final List<Runnable> whenSent = new ArrayList<Runnable>(5);
    private final int maxInMemory;
    private Http.Status status;
    private boolean nexted;
    private boolean reroute;
    private UriQuery rerouteQuery;
    private String reroutePath;

    protected ServerResponseBase(ConnectionContext ctx, ServerRequest request) {
        this.contentEncodingContext = ctx.listenerContext().contentEncodingContext();
        this.mediaContext = ctx.listenerContext().mediaContext();
        this.requestHeaders = request.headers();
        this.maxInMemory = ctx.listenerContext().config().maxInMemoryEntity();
    }

    public T status(Http.Status status) {
        this.status = status;
        return (T)this;
    }

    @Override
    public Http.Status status() {
        if (this.status == null) {
            return Http.Status.OK_200;
        }
        return this.status;
    }

    @Override
    public void send() {
        this.send(BufferData.EMPTY_BYTES);
    }

    @Override
    public void send(Object entity) {
        if (entity instanceof byte[]) {
            byte[] bytes = (byte[])entity;
            this.send(bytes);
            return;
        }
        try {
            this.doSend(entity);
        }
        catch (UnsupportedTypeException e) {
            throw new HttpException(e.getMessage(), Http.Status.UNSUPPORTED_MEDIA_TYPE_415, (Throwable)e, true);
        }
    }

    public T whenSent(Runnable listener) {
        this.whenSent.add(listener);
        return (T)this;
    }

    public T reroute(String newPath) {
        if (this.nexted) {
            throw new IllegalStateException("Cannot reroute a response that has been nexted");
        }
        this.reroute = true;
        this.reroutePath = newPath;
        return (T)this;
    }

    public T reroute(String path, UriQuery query) {
        if (this.nexted) {
            throw new IllegalStateException("Cannot reroute a response that has been nexted");
        }
        this.reroute = true;
        this.reroutePath = path;
        this.rerouteQuery = query;
        return (T)this;
    }

    public T next() {
        if (this.reroute) {
            throw new IllegalStateException("Cannot next a response that has been rerouted");
        }
        this.nexted = true;
        return (T)this;
    }

    @Override
    public void resetRouting() {
        this.nexted = false;
        this.reroute = false;
        this.reroutePath = null;
        this.rerouteQuery = null;
    }

    @Override
    public boolean shouldReroute() {
        return this.reroute;
    }

    @Override
    public HttpPrologue reroutePrologue(HttpPrologue prologue) {
        return HttpPrologue.create((String)prologue.rawProtocol(), (String)prologue.protocol(), (String)prologue.protocolVersion(), (Http.Method)prologue.method(), (UriPath)UriPath.create((String)this.reroutePath), (UriQuery)(this.rerouteQuery == null ? prologue.query() : this.rerouteQuery), (UriFragment)prologue.fragment());
    }

    @Override
    public boolean isNexted() {
        return this.nexted;
    }

    protected MediaContext mediaContext() {
        return this.mediaContext;
    }

    protected byte[] entityBytes(byte[] configuredEntity) {
        byte[] entity = configuredEntity;
        if (this.contentEncodingContext.contentEncodingEnabled()) {
            ContentEncoder encoder = this.contentEncodingContext.encoder((Headers)this.requestHeaders);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(entity.length);
            OutputStream os = encoder.encode((OutputStream)baos);
            try {
                os.write(entity);
                os.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            entity = baos.toByteArray();
            encoder.headers((WritableHeaders)this.headers());
        }
        return entity;
    }

    protected OutputStream contentEncode(OutputStream outputStream) {
        if (this.contentEncodingContext.contentEncodingEnabled()) {
            ContentEncoder encoder = this.contentEncodingContext.encoder((Headers)this.requestHeaders);
            encoder.headers((WritableHeaders)this.headers());
            return encoder.encode(outputStream);
        }
        return outputStream;
    }

    protected void afterSend() {
        for (Runnable runnable : this.whenSent) {
            runnable.run();
        }
    }

    private void doSend(Object entity) {
        GenericType type = entity instanceof String ? GenericType.STRING : GenericType.create((Object)entity);
        EntityWriter writer = this.mediaContext.writer(type, (Headers)this.requestHeaders, (WritableHeaders)this.headers());
        long configuredContentLength = this.headers().contentLength().orElse(-1L);
        if (writer.supportsInstanceWriter()) {
            InstanceWriter instanceWriter = writer.instanceWriter(type, entity, (Headers)this.requestHeaders, (WritableHeaders)this.headers());
            if (instanceWriter.alwaysInMemory()) {
                this.send(instanceWriter.instanceBytes());
                return;
            }
            long contentLength = instanceWriter.contentLength().orElse(configuredContentLength);
            if (contentLength != -1L && contentLength < (long)this.maxInMemory) {
                this.send(instanceWriter.instanceBytes());
                return;
            }
            instanceWriter.write(this.outputStream());
            return;
        }
        if (configuredContentLength == -1L || configuredContentLength > (long)this.maxInMemory) {
            OutputStream outputStream = this.outputStream();
            writer.write(type, entity, outputStream, (Headers)this.requestHeaders, (WritableHeaders)this.headers());
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)configuredContentLength);
        writer.write(type, entity, (OutputStream)baos, (Headers)this.requestHeaders, (WritableHeaders)this.headers());
        this.send(baos.toByteArray());
    }
}

