/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.common.GenericType;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.Headers;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.ReadableEntity;
import io.helidon.http.media.ReadableEntityBase;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ServerRequestEntity
extends ReadableEntityBase
implements ReadableEntity {
    private final Function<InputStream, InputStream> decoder;
    private final ServerRequestHeaders requestHeaders;
    private final MediaContext mediaContext;

    private ServerRequestEntity(Consumer<Boolean> entityRequestedCallback, Function<InputStream, InputStream> decoder, Function<Integer, BufferData> readEntityFunction, Runnable entityProcessedRunnable, ServerRequestHeaders requestHeaders, MediaContext mediaContext) {
        super(entityRequestedCallback, readEntityFunction, entityProcessedRunnable);
        this.decoder = decoder;
        this.requestHeaders = requestHeaders;
        this.mediaContext = mediaContext;
    }

    public static ServerRequestEntity create(Consumer<Boolean> entityRequestedCallback, ContentDecoder decoder, Function<Integer, BufferData> readEntityFunction, Runnable entityProcessedRunnable, ServerRequestHeaders requestHeaders, MediaContext mediaContext) {
        return new ServerRequestEntity(entityRequestedCallback, (Function<InputStream, InputStream>)decoder, readEntityFunction, entityProcessedRunnable, requestHeaders, mediaContext);
    }

    public ReadableEntity copy(Runnable entityProcessedRunnable) {
        return new ServerRequestEntity(d -> {}, this.decoder, this.readEntityFunction(), this.entityProcessedRunnable(), this.requestHeaders, this.mediaContext);
    }

    public InputStream inputStream() {
        return this.decoder.apply(super.inputStream());
    }

    protected <T> T entityAs(GenericType<T> type) {
        return (T)this.mediaContext.reader(type, (Headers)this.requestHeaders).read(type, this.inputStream(), (Headers)this.requestHeaders);
    }
}

