/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.http.Http;
import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouteBase;
import java.util.function.Predicate;

class HttpRouteImpl
extends HttpRouteBase
implements HttpRoute {
    private final Handler handler;
    private final Predicate<Http.Method> methodPredicate;
    private final PathMatcher pathMatcher;

    HttpRouteImpl(HttpRoute.Builder builder) {
        this.handler = builder.handler();
        this.methodPredicate = builder.methodPredicate();
        this.pathMatcher = builder.pathPredicate();
    }

    @Override
    public PathMatchers.MatchResult accepts(HttpPrologue prologue) {
        if (!this.methodPredicate.test(prologue.method())) {
            return PathMatchers.MatchResult.notAccepted();
        }
        return this.pathMatcher.match(prologue.uriPath());
    }

    @Override
    public Handler handler() {
        return this.handler;
    }

    @Override
    public void beforeStart() {
        this.handler.beforeStart();
    }

    @Override
    public void afterStop() {
        this.handler.afterStop();
    }

    public String toString() {
        return String.valueOf(this.methodPredicate) + " (" + String.valueOf(this.pathMatcher) + "): " + String.valueOf(this.handler);
    }
}

