/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.Router;
import io.helidon.webserver.Routing;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

class RouterImpl
implements Router {
    private static final RouterImpl EMPTY = RouterImpl.builder().build();
    private final Map<Class<?>, Routing> routings;

    private RouterImpl(Builder builder) {
        this.routings = new IdentityHashMap(builder.routings);
    }

    static Builder builder() {
        return new Builder();
    }

    static RouterImpl empty() {
        return EMPTY;
    }

    @Override
    public <T extends Routing> T routing(Class<T> routingType, T defaultValue) {
        Routing routing = (Routing)routingType.cast(this.routings.get(routingType));
        return (T)(routing == null ? defaultValue : routing);
    }

    @Override
    public void afterStop() {
        for (Routing value : this.routings.values()) {
            value.afterStop();
        }
    }

    @Override
    public void beforeStart() {
        for (Routing value : this.routings.values()) {
            value.beforeStart();
        }
    }

    @Override
    public List<? extends Routing> routings() {
        return List.copyOf(this.routings.values());
    }

    static class Builder
    implements Router.Builder {
        private static final System.Logger LOGGER = System.getLogger(Builder.class.getName());
        private final Map<Class<?>, Routing> routings = new IdentityHashMap();

        private Builder() {
        }

        public RouterImpl build() {
            return new RouterImpl(this);
        }

        @Override
        public Builder addRouting(Routing routing) {
            Routing previous = this.routings.put(routing.getClass(), routing);
            if (previous != null) {
                LOGGER.log(System.Logger.Level.WARNING, "Second routing of the same type is registered. The first instance will be ignored. Type: " + routing.getClass().getName());
            }
            return this;
        }
    }
}

