/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.SerializationConfig;
import io.helidon.common.config.ConfigException;
import io.helidon.common.context.Context;
import io.helidon.common.features.HelidonFeatures;
import io.helidon.common.features.api.HelidonFlavor;
import io.helidon.common.tls.Tls;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.media.MediaContext;
import io.helidon.inject.api.ServiceProvider;
import io.helidon.inject.api.Startable;
import io.helidon.inject.configdriven.api.ConfigDriven;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Router;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerListener;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.WebServerConfigBlueprint;
import io.helidon.webserver.http.DirectHandlers;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@ConfigDriven(value=WebServerConfigBlueprint.class, activateByDefault=true)
class LoomServer
implements WebServer,
Startable {
    private static final System.Logger LOGGER = System.getLogger(LoomServer.class.getName());
    private static final String EXIT_ON_STARTED_KEY = "exit.on.started";
    private static final AtomicInteger WEBSERVER_COUNTER = new AtomicInteger(1);
    private final Map<String, ServerListener> listeners;
    private final AtomicBoolean running = new AtomicBoolean();
    private final Lock lifecycleLock = new ReentrantLock();
    private final ExecutorService executorService;
    private final Context context;
    private final WebServerConfig serverConfig;
    private final boolean registerShutdownHook;
    private volatile Thread shutdownHook;
    private volatile List<ListenerFuture> startFutures;
    private volatile boolean alreadyStarted = false;

    LoomServer(WebServerConfig serverConfig) {
        this.registerShutdownHook = serverConfig.shutdownHook();
        this.context = serverConfig.serverContext().orElseGet(() -> Context.builder().id("web-" + WEBSERVER_COUNTER.getAndIncrement()).build());
        this.serverConfig = serverConfig;
        this.executorService = Executors.newVirtualThreadPerTaskExecutor();
        HashMap<String, ListenerConfig> sockets = new HashMap<String, ListenerConfig>(serverConfig.sockets());
        if (sockets.containsKey("@default")) {
            throw new ConfigException("Configuration of default socket MUST be done on server config directly, not as a separate socket with @default name.");
        }
        sockets.put("@default", serverConfig);
        Optional<HttpRouting> routing = serverConfig.routing();
        List<Routing> routings = serverConfig.routings();
        Router.Builder routerBuilder = Router.builder();
        routings.forEach(routerBuilder::addRouting);
        routing.ifPresent(routerBuilder::addRouting);
        if (routing.isEmpty() && routings.isEmpty()) {
            routerBuilder.addRouting(HttpRouting.create());
        }
        Timer idleConnectionTimer = new Timer("helidon-idle-connection-timer", true);
        HashMap listenerMap = new HashMap();
        sockets.forEach((name, socketConfig) -> listenerMap.put(name, new ServerListener((String)name, (ListenerConfig)socketConfig, (Router)routerBuilder.build(), this.context, idleConnectionTimer, serverConfig.mediaContext().orElseGet(MediaContext::create), serverConfig.contentEncoding().orElseGet(ContentEncodingContext::create), serverConfig.directHandlers().orElseGet(DirectHandlers::create))));
        this.listeners = Map.copyOf(listenerMap);
    }

    @Inject
    LoomServer(WebServerConfig serverConfig, List<ServiceProvider<HttpFeature>> features) {
        this(LoomServer.addFeatures(serverConfig, features));
    }

    public WebServerConfig prototype() {
        return this.serverConfig;
    }

    public void startService() {
        this.start();
    }

    @Override
    public WebServer start() {
        HelidonFeatures.flavor((HelidonFlavor)HelidonFlavor.SE);
        HelidonFeatures.print((HelidonFlavor)HelidonFlavor.SE, (String)"4.0.0-M2", (boolean)false);
        try {
            this.lifecycleLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
        try {
            if (this.running.compareAndSet(false, true)) {
                if (this.alreadyStarted) {
                    this.running.set(false);
                    throw new IllegalStateException("Server cannot be stopped and restarted, please create a new server");
                }
                this.alreadyStarted = true;
                this.startIt();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
        return this;
    }

    @Override
    @PreDestroy
    public WebServer stop() {
        try {
            this.lifecycleLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
        try {
            if (this.running.get()) {
                this.stopIt();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
        return this;
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public int port(String socketName) {
        if (!this.running.get()) {
            return -1;
        }
        ServerListener listener = this.listeners.get(socketName);
        return listener == null ? -1 : listener.port();
    }

    @Override
    public boolean hasTls(String socketName) {
        ServerListener listener = this.listeners.get(socketName);
        return listener != null && listener.hasTls();
    }

    @Override
    public void reloadTls(String socketName, Tls tls) {
        ServerListener listener = this.listeners.get(socketName);
        if (listener == null) {
            throw new IllegalArgumentException("Cannot reload TLS on socket " + socketName + " since this socket does not exist");
        }
        listener.reloadTls(tls);
    }

    @Override
    public Context context() {
        return this.context;
    }

    private static WebServerConfig addFeatures(WebServerConfig serverConfig, List<ServiceProvider<HttpFeature>> features) {
        WebServerConfig.Builder newBuilder = WebServerConfig.builder(serverConfig);
        ArrayList<HttpFeature> defaultSocket = new ArrayList<HttpFeature>();
        LinkedHashMap<String, List> customSockets = new LinkedHashMap<String, List>();
        LinkedHashMap<String, List> missingSockets = new LinkedHashMap<String, List>();
        for (ServiceProvider<HttpFeature> featureProvider : features) {
            HttpFeature feature = (HttpFeature)featureProvider.get();
            String socket = feature.socket();
            if ("@default".equals(socket)) {
                defaultSocket.add(feature);
                continue;
            }
            if (serverConfig.sockets().containsKey(socket)) {
                customSockets.computeIfAbsent(socket, it -> new ArrayList()).add(feature);
                continue;
            }
            if (feature.socketRequired()) {
                missingSockets.computeIfAbsent(socket, it -> new ArrayList()).add(feature);
                continue;
            }
            defaultSocket.add(feature);
        }
        if (!missingSockets.isEmpty()) {
            throw new IllegalArgumentException("Server is configured with the following sockets: " + String.valueOf(serverConfig.sockets().keySet()) + ", yet there are services that require other sockets. Map of socket names to features: " + String.valueOf(missingSockets));
        }
        newBuilder.routing(routing -> defaultSocket.forEach(routing::addFeature));
        customSockets.forEach((socketName, featureList) -> {
            ListenerConfig.Builder newSocketBuilder = ListenerConfig.builder(newBuilder.sockets().get(socketName));
            newSocketBuilder.routing(routing -> featureList.forEach(routing::addFeature));
            newBuilder.putSocket((String)socketName, newSocketBuilder.build());
        });
        return newBuilder.buildPrototype();
    }

    private void stopIt() {
        for (ServerListener listener : this.listeners.values()) {
            listener.stop();
        }
        this.running.set(false);
        LOGGER.log(System.Logger.Level.INFO, "Helidon WebServer stopped all channels.");
        this.deregisterShutdownHook();
    }

    private void startIt() {
        long now = System.currentTimeMillis();
        SerializationConfig.configureRuntime();
        boolean result = this.parallel("start", ServerListener::start);
        if (!result) {
            LOGGER.log(System.Logger.Level.ERROR, "Helidon WebServer failed to start, shutting down");
            this.parallel("stop", ServerListener::stop);
            if (this.startFutures != null) {
                this.startFutures.forEach(future -> future.future().cancel(true));
            }
            return;
        }
        if (this.registerShutdownHook) {
            this.registerShutdownHook();
        }
        now = System.currentTimeMillis() - now;
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        LOGGER.log(System.Logger.Level.INFO, "Started all channels in " + now + " milliseconds. " + uptime + " milliseconds since JVM startup. Java " + String.valueOf(Runtime.version()));
        if ("!".equals(System.getProperty(EXIT_ON_STARTED_KEY))) {
            LOGGER.log(System.Logger.Level.INFO, String.format("Exiting, -D%s set.", EXIT_ON_STARTED_KEY));
            System.exit(0);
        }
    }

    private void registerShutdownHook() {
        this.shutdownHook = new Thread(() -> {
            LOGGER.log(System.Logger.Level.INFO, "Shutdown requested by JVM shutting down");
            this.listeners.values().forEach(ServerListener::stop);
            if (this.startFutures != null) {
                this.startFutures.forEach(future -> future.future().cancel(true));
            }
            this.running.set(false);
            LOGGER.log(System.Logger.Level.INFO, "Shutdown finished");
        }, "webserver-shutdown-hook");
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.keepLoggingActive(this.shutdownHook);
    }

    private void deregisterShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    private boolean parallel(String taskName, Consumer<ServerListener> task) {
        boolean result = true;
        LinkedList<ListenerFuture> futures = new LinkedList<ListenerFuture>();
        for (ServerListener listener : this.listeners.values()) {
            futures.add(new ListenerFuture(listener, this.executorService.submit(() -> {
                Thread.currentThread().setName(taskName + " " + String.valueOf(listener));
                task.accept(listener);
            })));
        }
        for (ListenerFuture listenerFuture : futures) {
            try {
                listenerFuture.future().get();
            }
            catch (InterruptedException e) {
                LOGGER.log(System.Logger.Level.ERROR, "Failed to start listener, interrupted: " + String.valueOf(listenerFuture.listener.configuredAddress()), (Throwable)e);
                result = false;
            }
            catch (ExecutionException e) {
                LOGGER.log(System.Logger.Level.ERROR, "Failed to start listener: " + String.valueOf(listenerFuture.listener.configuredAddress()), (Throwable)e);
                result = false;
            }
        }
        this.startFutures = futures;
        return result;
    }

    private void keepLoggingActive(Thread shutdownHook) {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        ArrayList<Handler> newHandlers = new ArrayList<Handler>();
        boolean added = false;
        for (Handler handler : handlers) {
            if (handler instanceof KeepLoggingActiveHandler) {
                newHandlers.add(new KeepLoggingActiveHandler(shutdownHook));
                added = true;
                continue;
            }
            newHandlers.add(handler);
        }
        if (!added) {
            newHandlers.add(0, new KeepLoggingActiveHandler(shutdownHook));
        }
        for (Handler handler : handlers) {
            rootLogger.removeHandler(handler);
        }
        for (Handler newHandler : newHandlers) {
            rootLogger.addHandler(newHandler);
        }
    }

    private record ListenerFuture(ServerListener listener, Future<?> future) {
    }

    private static final class KeepLoggingActiveHandler
    extends Handler {
        private final Thread shutdownHook;

        private KeepLoggingActiveHandler(Thread shutdownHook) {
            this.shutdownHook = shutdownHook;
        }

        @Override
        public void publish(LogRecord record) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            try {
                this.shutdownHook.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

