/*
 * Copyright (c) 2023 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package io.helidon.webserver;

import io.helidon.common.Weight;
import io.helidon.common.Weighted;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.TypeName;

import io.helidon.inject.api.DependenciesInfo;
import io.helidon.inject.api.ElementKind;
import io.helidon.inject.api.PostConstructMethod;
import io.helidon.inject.api.PreDestroyMethod;
import io.helidon.inject.api.RunLevel;
import io.helidon.inject.api.ServiceInfo;
import io.helidon.inject.runtime.Dependencies;

import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;


import static io.helidon.inject.api.InjectionPointInfo.CONSTRUCTOR;

/**
 * Activator for {@link io.helidon.webserver.LoomServer}.
 */
// @Singleton
@Weight(100.0) @RunLevel(100)
@SuppressWarnings("unchecked")
@io.helidon.common.Generated(value = "io.helidon.inject.tools.ActivatorCreatorDefault", trigger = "io.helidon.webserver.LoomServer")
public class LoomServer$$Injection$$Activator
            extends io.helidon.inject.configdriven.runtime.ConfigDrivenServiceProviderBase<io.helidon.webserver.LoomServer, io.helidon.webserver.WebServerConfig> {
    private static final ServiceInfo serviceInfo =
        ServiceInfo.builder()
            .serviceTypeName(io.helidon.webserver.LoomServer.class)
            .addContractImplemented(io.helidon.webserver.WebServer.class)
            .addExternalContractImplemented(io.helidon.inject.api.Startable.class)
            .activatorTypeName(LoomServer$$Injection$$Activator.class)
            .addQualifier(io.helidon.inject.api.Qualifier.create(io.helidon.inject.configdriven.api.ConfigDriven.class, "io.helidon.webserver.WebServerConfigBlueprint"))
            .declaredWeight(100.0)
            .declaredRunLevel(100)
            .build();

    /**
     * The global singleton instance for this service provider activator.
     */
    public static final LoomServer$$Injection$$Activator INSTANCE = new LoomServer$$Injection$$Activator();

    /**
     * Default activator constructor.
     */
    protected LoomServer$$Injection$$Activator() {
        super("root");

		this.configBean = null;
		serviceInfo(serviceInfo);
    }

    /**
     * The service type of the managed service.
     *
     * @return the service type of the managed service
     */
    @Override
    public Class<?> serviceType() {
        return io.helidon.webserver.LoomServer.class;
    }

	private final io.helidon.webserver.WebServerConfig configBean;


	private LoomServer$$Injection$$Activator(io.helidon.inject.configdriven.api.NamedInstance<io.helidon.webserver.WebServerConfig> configBean) {
		super(configBean.name());
		assertIsRootProvider(false, true);
		serviceInfo(serviceInfo);
		this.configBean = configBean.instance();
	}


	@Override
	public List<io.helidon.inject.configdriven.api.NamedInstance<io.helidon.webserver.WebServerConfig>> createConfigBeans(io.helidon.common.config.Config config){
		var beanConfig = config.get("server");
		if (!beanConfig.exists()) {
			return List.of(new io.helidon.inject.configdriven.api.NamedInstance<>(io.helidon.webserver.WebServerConfig.create(io.helidon.common.config.Config.empty()), io.helidon.inject.configdriven.api.NamedInstance.DEFAULT_NAME));
		}
		if (beanConfig.isList()) {
			throw new io.helidon.common.config.ConfigException("Expecting a single node at \"server\", but got a list");
		}
		return java.util.List.of(new io.helidon.inject.configdriven.api.NamedInstance<>(io.helidon.webserver.WebServerConfig.create(beanConfig), io.helidon.inject.configdriven.api.NamedInstance.DEFAULT_NAME));
	}


	@Override
	public Class<io.helidon.webserver.WebServerConfig> configBeanType() {
		return io.helidon.webserver.WebServerConfig.class;
	}


	@Override
	protected io.helidon.inject.configdriven.runtime.ConfigDrivenServiceProviderBase<io.helidon.webserver.LoomServer, io.helidon.webserver.WebServerConfig> createInstance(io.helidon.inject.configdriven.api.NamedInstance<io.helidon.webserver.WebServerConfig> configBean) {
		return new LoomServer$$Injection$$Activator(configBean);
	}


	@Override
	protected boolean drivesActivation() {
		return true;
	}


	@Override
	public io.helidon.webserver.WebServerConfig configBean() {
		if (isRootProvider()) {
			throw new NullPointerException("Config bean is not available on root config driven instance");
		}
		return configBean;
	}


    @Override
    public boolean isProvider() {
        return true;
    }

    @Override
    public DependenciesInfo dependencies() {
        DependenciesInfo deps = Dependencies.builder(io.helidon.webserver.LoomServer.class)
                .add(CONSTRUCTOR, WebServerConfig.class, ElementKind.CONSTRUCTOR, 2, AccessModifier.PACKAGE_PRIVATE).elemOffset(1).ipName("serverConfig").ipType(io.helidon.common.types.TypeName.create(WebServerConfig.class))
                .add(CONSTRUCTOR, io.helidon.webserver.http.HttpFeature.class, ElementKind.CONSTRUCTOR, 2, AccessModifier.PACKAGE_PRIVATE).elemOffset(2).ipName("features").ipType(io.helidon.common.types.TypeName.create(java.util.List.class)).listWrapped().providerWrapped()
                .build();
        return Dependencies.combine(super.dependencies(), deps);
    }

    @Override
    protected LoomServer createServiceProvider(Map<String, Object> deps) { 
        WebServerConfig serverConfig = (WebServerConfig) get(deps, "io.helidon.webserver.<init>|2(1)");
        java.util.List<io.helidon.inject.api.ServiceProvider<io.helidon.webserver.http.HttpFeature>> features = (java.util.List<io.helidon.inject.api.ServiceProvider<io.helidon.webserver.http.HttpFeature>>) get(deps, "io.helidon.webserver.<init>|2(2)");
        return new io.helidon.webserver.LoomServer(serverConfig, features);
    }

    @Override
    public Optional<PreDestroyMethod> preDestroyMethod() {
        LoomServer target = (LoomServer) serviceRef().orElseThrow();
        return Optional.of(target::stop);
    }

}