/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

class ReferenceHoldingQueue<T>
extends ReferenceQueue<T> {
    private static final Logger LOGGER = Logger.getLogger(ReferenceHoldingQueue.class.getName());
    private final Set<ReleasableReference<T>> set = ConcurrentHashMap.newKeySet();
    private volatile boolean down = false;

    ReferenceHoldingQueue() {
    }

    boolean release() {
        Reference poll;
        while ((poll = this.poll()) != null) {
            this.hookOnAutoRelease();
            if (poll instanceof ReleasableReference) {
                ((ReleasableReference)poll).release();
                continue;
            }
            LOGGER.warning(() -> "Unexpected type detected: " + poll.getClass());
        }
        return this.set.isEmpty();
    }

    protected void hookOnAutoRelease() {
    }

    public void shutdown() {
        this.down = true;
        for (ReleasableReference<T> reference : this.set) {
            reference.release();
        }
    }

    private void link(ReleasableReference<T> reference) {
        if (this.down) {
            throw new IllegalStateException("Shutdown was requested. This queue must not be used anymore");
        }
        this.set.add(reference);
    }

    private void unlink(ReleasableReference<T> reference) {
        this.set.remove(reference);
    }

    static final class ReleasableReference<T>
    extends IndirectReference<T, Runnable> {
        private final ReferenceHoldingQueue<T> queue;

        ReleasableReference(T referent, ReferenceHoldingQueue<T> q, Runnable r) {
            super(referent, q, r);
            this.queue = q;
            this.queue.link(this);
        }

        boolean isReleased() {
            return this.otherRef().get() == null;
        }

        void release() {
            Runnable r = (Runnable)this.acquire();
            if (r != null) {
                this.queue.unlink(this);
                r.run();
            }
        }
    }

    static class IndirectReference<T, R>
    extends PhantomReference<T> {
        private final AtomicReference<R> otherRef = new AtomicReference();

        IndirectReference(T referent, ReferenceQueue<? super T> q, R otherRef) {
            super(referent, q);
            this.otherRef.lazySet(otherRef);
        }

        public AtomicReference<R> otherRef() {
            return this.otherRef;
        }

        public R acquire() {
            return this.otherRef.get() == null ? null : this.otherRef.getAndSet(null);
        }
    }
}

