/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.LazyValue;
import io.helidon.common.pki.KeyConfig;
import io.helidon.webserver.TlsManager;
import io.helidon.webserver.TrustAllManagerFactory;
import io.helidon.webserver.WebServerTls;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class ConfiguredTlsManager
implements TlsManager {
    private static final LazyValue<SecureRandom> RANDOM = LazyValue.create(SecureRandom::new);
    private final String name;
    private final String type;
    private final Set<Consumer<SSLContext>> subscribers = new LinkedHashSet<Consumer<SSLContext>>();
    private volatile SSLContext sslContext;

    ConfiguredTlsManager() {
        this("@default", "tls-manager");
    }

    protected ConfiguredTlsManager(String name, String type) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public void subscribe(Consumer<SSLContext> sslContextConsumer) {
        this.subscribers.add(Objects.requireNonNull(sslContextConsumer));
    }

    @Override
    public void init(WebServerTls tlsConfig) {
        SSLContext explicitSslContext = tlsConfig.explicitSslContext().orElse(null);
        if (explicitSslContext != null) {
            this.sslContext = explicitSslContext;
            return;
        }
        if (tlsConfig.privateKeyConfig() == null) {
            throw new IllegalStateException("Private key must be configured when SSL is enabled.");
        }
        try {
            KeyManagerFactory kmf = this.buildKmf(tlsConfig.privateKeyConfig());
            TrustManagerFactory tmf = this.buildTmf(tlsConfig);
            this.initSslContext(tlsConfig, kmf.getKeyManagers(), tmf.getTrustManagers());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Failed to build server SSL Context!", e);
        }
    }

    @Deprecated
    protected void initSslContext(WebServerTls tlsConfig, KeyManager[] keyManagers, TrustManager[] trustManagers) {
        try {
            SSLContext sslContext = SSLContext.getInstance(tlsConfig.protocol());
            sslContext.init(keyManagers, trustManagers, this.secureRandom(tlsConfig));
            this.configureAndSet(tlsConfig, sslContext);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to create SSLContext", e);
        }
    }

    @Deprecated
    protected void reload(WebServerTls tlsConfig, KeyManager[] keyManagers, TrustManager[] trustManagers) {
        this.initSslContext(tlsConfig, keyManagers, trustManagers);
        this.subscribers.forEach(c -> c.accept(this.sslContext));
    }

    protected SecureRandom secureRandom(WebServerTls tlsConfig) {
        return (SecureRandom)RANDOM.get();
    }

    protected TrustManagerFactory trustAllTmf() {
        return new TrustAllManagerFactory();
    }

    @Deprecated
    protected TrustManagerFactory createTmf(WebServerTls tlsConfig) {
        try {
            return TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to create trust manager factory", e);
        }
    }

    @Deprecated
    protected void configureAndSet(WebServerTls tlsConfig, SSLContext sslContext) {
        SSLSessionContext serverSessionContext = sslContext.getServerSessionContext();
        if (serverSessionContext != null) {
            int sessionTimeoutSecs;
            int sessionCacheSize = tlsConfig.sessionCacheSize();
            if (sessionCacheSize > 0) {
                serverSessionContext.setSessionCacheSize(sessionCacheSize);
            }
            if ((sessionTimeoutSecs = tlsConfig.sessionTimeoutSeconds()) > 0) {
                serverSessionContext.setSessionTimeout(sessionTimeoutSecs);
            }
        }
        this.sslContext = sslContext;
    }

    private KeyManagerFactory buildKmf(KeyConfig privateKeyConfig) throws IOException, GeneralSecurityException {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        byte[] passwordBytes = new byte[64];
        ((SecureRandom)RANDOM.get()).nextBytes(passwordBytes);
        char[] password = Base64.getEncoder().encodeToString(passwordBytes).toCharArray();
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        ks.setKeyEntry("key", (Key)privateKeyConfig.privateKey().orElseThrow(() -> new RuntimeException("Private key not available")), password, privateKeyConfig.certChain().toArray(new Certificate[0]));
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, password);
        return kmf;
    }

    private TrustManagerFactory buildTmf(WebServerTls tlsConfig) throws IOException, GeneralSecurityException {
        if (tlsConfig.trustAll()) {
            return this.trustAllTmf();
        }
        KeyConfig trustConfig = tlsConfig.trustConfig();
        List certs = trustConfig == null ? List.of() : trustConfig.certs();
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        int i = 1;
        for (X509Certificate cert : certs) {
            ks.setCertificateEntry(String.valueOf(i), cert);
            ++i;
        }
        TrustManagerFactory tmf = this.createTmf(tlsConfig);
        tmf.init(ks);
        return tmf;
    }
}

