/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.LazyValue;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.AlreadyCompletedException;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.MediaType;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.helidon.webserver.BareRequest;
import io.helidon.webserver.BareResponse;
import io.helidon.webserver.ErrorHandler;
import io.helidon.webserver.HandlerRoute;
import io.helidon.webserver.HashRequestHeaders;
import io.helidon.webserver.HtmlEncoder;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.NotFoundException;
import io.helidon.webserver.PathMatcher;
import io.helidon.webserver.Request;
import io.helidon.webserver.Response;
import io.helidon.webserver.Route;
import io.helidon.webserver.RouteList;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebTracingConfig;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

class RequestRouting
implements Routing {
    private static final Logger LOGGER = Logger.getLogger(RequestRouting.class.getName());
    private final RouteList routes;
    private final List<ErrorHandlerRecord<?>> errorHandlers;
    private final List<Consumer<WebServer>> newWebServerCallbacks;

    RequestRouting(RouteList routes, List<ErrorHandlerRecord<?>> errorHandlers, List<Consumer<WebServer>> newWebServerCallbacks) {
        this.routes = routes;
        this.errorHandlers = errorHandlers;
        this.newWebServerCallbacks = new ArrayList<Consumer<WebServer>>(newWebServerCallbacks);
    }

    @Override
    public void route(BareRequest bareRequest, BareResponse bareResponse) {
        try {
            WebServer webServer = bareRequest.webServer();
            HashRequestHeaders requestHeaders = new HashRequestHeaders(bareRequest.headers());
            RoutedResponse response = new RoutedResponse(webServer, bareResponse, requestHeaders.acceptedTypes());
            String path = RequestRouting.canonicalize(bareRequest.uri().normalize().getPath());
            String rawPath = RequestRouting.canonicalize(bareRequest.uri().normalize().getRawPath());
            Crawler crawler = new Crawler(this.routes, path, rawPath, bareRequest.method(), bareRequest.version());
            RoutedRequest nextRequests = new RoutedRequest(bareRequest, response, webServer, crawler, this.errorHandlers, requestHeaders);
            response.request(nextRequests);
            nextRequests.next();
        }
        catch (Error | RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Unexpected error occurred during routing!", e);
            throw e;
        }
    }

    private static String canonicalize(String p) {
        int lastCharIndex;
        String result = p == null || p.isEmpty() || p.equals("/") ? "/" : (p.charAt(lastCharIndex = p.length() - 1) == '/' ? p.substring(0, lastCharIndex) : p);
        return result;
    }

    void fireNewWebServer(WebServer webServer) {
        for (Consumer<WebServer> callback : this.newWebServerCallbacks) {
            callback.accept(webServer);
        }
    }

    private static class RoutedResponse
    extends Response {
        private final AtomicReference<RoutedRequest> request = new AtomicReference();

        RoutedResponse(WebServer webServer, BareResponse bareResponse, List<MediaType> acceptedTypes) {
            super(webServer, bareResponse, acceptedTypes);
        }

        RoutedResponse(RoutedResponse response) {
            super(response);
            this.request.set(response.request.get());
        }

        @Override
        Optional<SpanContext> spanContext() {
            return Contexts.context().flatMap(ctx -> ctx.get(SpanContext.class));
        }

        @Override
        public Void send(Throwable content) {
            RoutedRequest routedRequest = this.request.get();
            if (routedRequest == null) {
                return super.send(content);
            }
            routedRequest.nextNoCheck(content);
            return null;
        }

        void request(RoutedRequest request) {
            this.request.set(request);
        }
    }

    private static class Crawler {
        private final List<Route> routes;
        private final Request.Path contextPath;
        private final String path;
        private final String rawPath;
        private final Http.RequestMethod method;
        private final Http.Version version;
        private volatile int index = -1;
        private volatile Crawler subCrawler;

        private Crawler(List<Route> routes, Request.Path contextPath, String path, String rawPath, Http.RequestMethod method, Http.Version version) {
            this.routes = routes;
            this.path = path;
            this.rawPath = rawPath;
            this.contextPath = contextPath;
            this.method = method;
            this.version = version;
        }

        Crawler(List<Route> routes, String path, String rawPath, Http.RequestMethod method, Http.Version version) {
            this(routes, null, path, rawPath, method, version);
        }

        public Item next() {
            while (this.subCrawler != null || ++this.index < this.routes.size()) {
                if (this.subCrawler != null) {
                    Item result = this.subCrawler.next();
                    if (result != null) {
                        return result;
                    }
                    this.subCrawler = null;
                    continue;
                }
                Route route = this.routes.get(this.index);
                if (route.accepts(this.method)) {
                    if (route instanceof HandlerRoute) {
                        HandlerRoute hr = (HandlerRoute)route;
                        PathMatcher.Result match = hr.match(this.path);
                        if (match.matches() && hr.matchVersion(this.version)) {
                            return new Item(hr, Request.Path.create(this.contextPath, this.path, this.rawPath, match.params()));
                        }
                    } else if (route instanceof RouteList) {
                        RouteList rl = (RouteList)route;
                        PathMatcher.PrefixResult prefixMatch = rl.prefixMatch(this.path);
                        PathMatcher.PrefixResult rawPrefixMatch = rl.prefixMatch(this.rawPath);
                        if (prefixMatch.matches()) {
                            this.subCrawler = new Crawler(rl, Request.Path.create(this.contextPath, this.path, this.rawPath, prefixMatch.params()), prefixMatch.remainingPart(), rawPrefixMatch.remainingPart(), this.method, this.version);
                            continue;
                        }
                    }
                    LOGGER.finest(() -> "Route candidate '" + route + "' doesn't match path: " + this.path);
                    continue;
                }
                LOGGER.finest(() -> "Route candidate '" + route + "' doesn't match method: " + this.method);
            }
            return null;
        }

        private static class Item {
            private final HandlerRoute handlerRoute;
            private final Request.Path path;

            Item(HandlerRoute handlerRoute, Request.Path path) {
                this.handlerRoute = handlerRoute;
                this.path = path;
            }
        }
    }

    private static class RoutedRequest
    extends Request {
        private final Crawler crawler;
        private final LinkedList<ErrorHandlerRecord<? extends Throwable>> errorHandlers;
        private final Request.Path path;
        private final RoutedResponse response;
        private final AtomicBoolean nexted = new AtomicBoolean(false);
        private final LazyValue<URI> lazyAbsoluteUri = LazyValue.create(() -> super.absoluteUri());

        RoutedRequest(BareRequest req, RoutedResponse response, WebServer webServer, Crawler crawler, List<ErrorHandlerRecord<?>> errorHandlers, HashRequestHeaders headers) {
            super(req, webServer, headers);
            this.crawler = crawler;
            this.errorHandlers = new LinkedList(errorHandlers);
            this.path = null;
            this.response = response;
        }

        RoutedRequest(RoutedRequest request, RoutedResponse response, Request.Path path, List<ErrorHandlerRecord<?>> errorHandlers) {
            super(request);
            this.crawler = request.crawler;
            this.response = response;
            this.path = path;
            this.errorHandlers = new LinkedList(errorHandlers);
        }

        Span span() {
            return this.context().get(ServerRequest.class, Span.class).orElse(null);
        }

        @Override
        public Optional<SpanContext> spanContext() {
            return this.context().get(ServerRequest.class, SpanContext.class);
        }

        boolean nexted() {
            return this.nexted.get();
        }

        @Override
        public void next() {
            this.checkNexted();
            Crawler.Item nextItem = this.crawler.next();
            if (nextItem == null) {
                this.nextNoCheck(new NotFoundException("No handler found for path: " + HtmlEncoder.encode(this.path().toString())));
            } else {
                try {
                    SpanTracingConfig spanConfig;
                    RoutedResponse nextResponse = new RoutedResponse(this.response);
                    RoutedRequest nextRequest = new RoutedRequest(this, nextResponse, nextItem.path, this.errorHandlers);
                    LOGGER.finest(() -> "(reqID: " + this.requestId() + ") Routing next: " + nextItem.path);
                    Span span = this.span();
                    if (null != span && (spanConfig = TracingConfigUtil.spanConfig((String)"web-server", (String)"HTTP Request", (Context)this.context())).spanLog("handler.class").enabled()) {
                        span.addEvent("handler", nextItem.handlerRoute.diagnosticEvent());
                    }
                    nextItem.handlerRoute.handler().accept(nextRequest, nextResponse);
                }
                catch (RuntimeException re) {
                    this.nextNoCheck(re);
                }
            }
        }

        private void checkNexted() {
            this.checkNexted(null);
        }

        private void checkNexted(Throwable t) {
            if (!this.nexted.compareAndSet(false, true)) {
                throw new IllegalStateException("The 'next()' method can be called only once!", t);
            }
        }

        private void nextNoCheck(Throwable t) {
            if (t instanceof CompletionException) {
                this.nextNoCheck(t.getCause());
                return;
            }
            LOGGER.finest(() -> "(reqID: " + this.requestId() + ") Routing error: " + t.getClass());
            ErrorHandlerRecord<? extends Throwable> record = this.errorHandlers.pollFirst();
            while (record != null) {
                if (record.exceptionClass.isAssignableFrom(t.getClass())) {
                    ErrorRoutedRequest nextErrorRequest = new ErrorRoutedRequest(this.errorHandlers, t);
                    Span span = this.span();
                    if (null != span) {
                        span.addEvent("error-handler", Map.of("handler.class", record.errorHandler.getClass().getName(), "handled.error.message", t.toString()));
                    }
                    try {
                        record.errorHandler.accept(nextErrorRequest, this.response, t);
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, "Exception unexpectedly thrown from an error handler. Error handling of this logged exception was aborted.", t);
                        this.defaultHandler(new IllegalStateException("Unexpected exception encountered during error handling.", e));
                        return;
                    }
                    return;
                }
                record = this.errorHandlers.pollFirst();
            }
            this.defaultHandler(t);
        }

        private void defaultHandler(Throwable t) {
            Span span = this.span();
            if (null != span) {
                span.addEvent("error-handler", Map.of("handler.class", "DEFAULT-ERROR-HANDLER", "handled.error.message", t.toString()));
            }
            String message = null;
            try {
                if (t instanceof HttpException) {
                    this.response.status(((HttpException)t).status());
                } else if (t.getCause() instanceof HttpException) {
                    this.response.status(((HttpException)t.getCause()).status());
                } else if (t instanceof RejectedExecutionException || t.getCause() instanceof RejectedExecutionException) {
                    this.response.status((Http.ResponseStatus)Http.Status.SERVICE_UNAVAILABLE_503);
                } else {
                    LOGGER.log(t instanceof Error ? Level.SEVERE : Level.WARNING, "Default error handler: Unhandled exception encountered.", new ExecutionException("Unhandled 'cause' of this exception encountered.", t));
                    this.response.status((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500);
                }
                message = t.getMessage();
            }
            catch (AlreadyCompletedException e) {
                LOGGER.log(Level.WARNING, "Cannot perform error handling of the throwable (see cause of this exception) because headers were already sent", new IllegalStateException("Headers already sent. Cannot handle the cause of this exception.", t));
            }
            this.response.send(message).exceptionally(throwable -> {
                LOGGER.log(Level.WARNING, "Default error handler: Response wasn't successfully sent.", (Throwable)throwable);
                return null;
            });
        }

        @Override
        public void next(Throwable t) {
            this.checkNexted(t);
            this.nextNoCheck(t);
        }

        public HttpRequest.Path path() {
            return this.path;
        }

        @Override
        public Tracer tracer() {
            return WebTracingConfig.tracer(this.webServer());
        }

        @Override
        public URI absoluteUri() {
            return (URI)this.lazyAbsoluteUri.get();
        }

        private class ErrorRoutedRequest
        extends RoutedRequest {
            private final Throwable t;

            ErrorRoutedRequest(LinkedList<ErrorHandlerRecord<?>> errorHandlers, Throwable t) {
                super(RoutedRequest.this, new RoutedResponse(RoutedRequest.this.response), RoutedRequest.this.path, errorHandlers);
                this.t = t;
            }

            @Override
            public void next() {
                super.next(this.t);
            }

            @Override
            public HttpRequest.Path path() {
                return super.path().absolute();
            }
        }
    }

    static class ErrorHandlerRecord<T extends Throwable> {
        private final Class<T> exceptionClass;
        private final ErrorHandler<T> errorHandler;

        private ErrorHandlerRecord(Class<T> exceptionClass, ErrorHandler<T> errorHandler) {
            this.exceptionClass = exceptionClass;
            this.errorHandler = errorHandler;
        }

        public static <T extends Throwable> ErrorHandlerRecord<T> of(Class<T> exceptionClass, ErrorHandler<T> errorHandler) {
            return new ErrorHandlerRecord<T>(exceptionClass, errorHandler);
        }
    }
}

