/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.Multi;
import io.helidon.webserver.HttpRequestScopedPublisher;
import io.helidon.webserver.SocketConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpRequest;
import java.util.concurrent.Flow;
import java.util.logging.Logger;

class RequestContext {
    private static final Logger LOGGER = Logger.getLogger(RequestContext.class.getName());
    private final HttpRequestScopedPublisher publisher;
    private final HttpRequest request;
    private final Context scope;
    private final SocketConfiguration socketConfiguration;
    private volatile boolean responseCompleted;
    private volatile boolean emitted;

    RequestContext(HttpRequestScopedPublisher publisher, HttpRequest request, Context scope, SocketConfiguration socketConfiguration) {
        this.publisher = publisher;
        this.request = request;
        this.scope = scope;
        this.socketConfiguration = socketConfiguration;
    }

    Multi<DataChunk> publisher() {
        return Multi.create((Flow.Publisher)((Object)this.publisher)).peek(something -> {
            this.emitted = true;
        });
    }

    HttpRequest request() {
        return this.request;
    }

    void emit(ByteBuf data) {
        this.runInScope(() -> this.publisher.emit(data));
    }

    void fail(Throwable throwable) {
        this.runInScope(() -> this.publisher.fail(throwable));
    }

    void complete() {
        this.runInScope(this.publisher::complete);
    }

    void runInScope(Runnable runnable) {
        Contexts.runInContext((Context)this.scope, () -> {
            LOGGER.finest(() -> "Running in context " + this.scope.id());
            runnable.run();
        });
    }

    Context scope() {
        return this.scope;
    }

    boolean hasRequests() {
        return this.publisher.hasRequests();
    }

    boolean isDataRequested() {
        return this.hasRequests() || this.hasEmitted() || this.requestCancelled();
    }

    boolean hasEmitted() {
        return this.emitted;
    }

    boolean requestCancelled() {
        return this.publisher.isCancelled();
    }

    boolean requestCompleted() {
        return this.publisher.isCompleted();
    }

    void responseCompleted(boolean responseCompleted) {
        this.responseCompleted = responseCompleted;
    }

    boolean responseCompleted() {
        return this.responseCompleted;
    }

    SocketConfiguration socketConfiguration() {
        return this.socketConfiguration;
    }
}

