/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.LazyList;
import io.helidon.common.LazyValue;
import io.helidon.common.http.HashParameters;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.http.ReadOnlyHeaders;
import io.helidon.common.http.Utils;
import io.helidon.webserver.RequestHeaders;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;

class HashRequestHeaders
extends ReadOnlyHeaders
implements RequestHeaders {
    static final String HUC_ACCEPT_DEFAULT = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private static final List<MediaType> HUC_ACCEPT_DEFAULT_TYPES = List.of(MediaType.TEXT_HTML, MediaType.parse((String)"image/gif"), MediaType.parse((String)"image/jpeg"), MediaType.parse((String)"*/*; q=.2"));
    private final Object internalLock = new Object();
    private volatile Parameters cookies;
    private List<MediaType> acceptedtypesCache;

    HashRequestHeaders() {
        this(null);
    }

    HashRequestHeaders(Map<String, List<String>> initialContent) {
        super(initialContent);
    }

    @Override
    public Optional<MediaType> contentType() {
        return this.first("Content-Type").map(MediaType::parse);
    }

    @Override
    public OptionalLong contentLength() {
        Optional v = this.first("Content-Length");
        if (v.isPresent()) {
            return OptionalLong.of(Long.parseLong((String)v.get()));
        }
        return OptionalLong.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Parameters cookies() {
        Parameters lCookies = this.cookies;
        if (lCookies == null) {
            Object object = this.internalLock;
            synchronized (object) {
                lCookies = this.cookies;
                if (lCookies == null) {
                    List list = this.all("Cookie").stream().map(CookieParser::parse).collect(Collectors.toList());
                    this.cookies = lCookies = Parameters.toUnmodifiableParameters((Parameters)HashParameters.concat(list));
                }
            }
        }
        return lCookies;
    }

    @Override
    public List<MediaType> acceptedTypes() {
        Object result = this.acceptedtypesCache;
        if (result == null) {
            List acceptValues = this.all("Accept");
            result = acceptValues.size() == 1 && HUC_ACCEPT_DEFAULT.equals(acceptValues.get(0)) ? HUC_ACCEPT_DEFAULT_TYPES : LazyList.create(acceptValues.stream().flatMap(h -> Utils.tokenize((char)',', (String)"\"", (boolean)false, (String)h).stream()).map(String::trim).map(s -> LazyValue.create(() -> MediaType.parse((String)s))).collect(Collectors.toList()));
            this.acceptedtypesCache = result = Collections.unmodifiableList(result);
        }
        return result;
    }

    @Override
    public boolean isAccepted(MediaType mediaType) {
        Objects.requireNonNull(mediaType, "Parameter 'mediaType' is null!");
        List<MediaType> acceptedTypes = this.acceptedTypes();
        return acceptedTypes.isEmpty() || acceptedTypes.stream().anyMatch(mediaType);
    }

    @Override
    public Optional<MediaType> bestAccepted(MediaType ... mediaTypes) {
        if (mediaTypes == null || mediaTypes.length == 0) {
            return Optional.empty();
        }
        List<MediaType> accepts = this.acceptedTypes();
        if (accepts == null || accepts.isEmpty()) {
            return Optional.ofNullable(mediaTypes[0]);
        }
        double best = 0.0;
        MediaType result = null;
        for (MediaType mt : mediaTypes) {
            if (mt == null) continue;
            for (MediaType acc : accepts) {
                double q = acc.qualityFactor();
                if (!(q > best) || !acc.test(mt)) continue;
                if (q == 1.0) {
                    return Optional.of(mt);
                }
                best = q;
                result = mt;
            }
        }
        return Optional.ofNullable(result);
    }

    @Override
    public Optional<ZonedDateTime> acceptDatetime() {
        return this.first("Accept-Datetime").map(Http.DateTime::parse);
    }

    @Override
    public Optional<ZonedDateTime> date() {
        return this.first("Date").map(Http.DateTime::parse);
    }

    @Override
    public Optional<ZonedDateTime> ifModifiedSince() {
        return this.first("If-Modified-Since").map(Http.DateTime::parse);
    }

    @Override
    public Optional<ZonedDateTime> ifUnmodifiedSince() {
        return this.first("If-Unmodified-Since").map(Http.DateTime::parse);
    }

    @Override
    public Optional<URI> referer() {
        return this.first("Referer").map(URI::create);
    }

    static class CookieParser {
        private static final String RFC2965_VERSION = "$Version";
        private static final String RFC2965_PATH = "$Path";
        private static final String RFC2965_DOMAIN = "$Domain";
        private static final String RFC2965_PORT = "$Port";

        private CookieParser() {
        }

        public static Parameters parse(String cookieHeaderValue) {
            if (cookieHeaderValue == null) {
                return ReadOnlyHeaders.empty();
            }
            if ((cookieHeaderValue = cookieHeaderValue.trim()).isEmpty()) {
                return ReadOnlyHeaders.empty();
            }
            boolean isRfc2965 = false;
            if (cookieHeaderValue.regionMatches(true, 0, RFC2965_VERSION, 0, RFC2965_VERSION.length())) {
                isRfc2965 = true;
                int ind = cookieHeaderValue.indexOf(59);
                if (ind < 0) {
                    return ReadOnlyHeaders.empty();
                }
                cookieHeaderValue = cookieHeaderValue.substring(ind + 1);
            }
            HashParameters result = HashParameters.create();
            for (String baseToken : Utils.tokenize((char)',', (String)"\"", (boolean)false, (String)cookieHeaderValue)) {
                for (String token : Utils.tokenize((char)';', (String)"\"", (boolean)false, (String)baseToken)) {
                    String name;
                    int eqInd = token.indexOf(61);
                    if (eqInd <= 0 || (name = token.substring(0, eqInd).trim()).isEmpty() || isRfc2965 && name.charAt(0) == '$' && (RFC2965_PATH.equalsIgnoreCase(name) || RFC2965_DOMAIN.equalsIgnoreCase(name) || RFC2965_PORT.equalsIgnoreCase(name) || RFC2965_VERSION.equalsIgnoreCase(name))) continue;
                    String value = token.substring(eqInd + 1).trim();
                    result.add(name, new String[]{Utils.unwrap((String)value)});
                }
            }
            return result;
        }
    }
}

