/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.config.Config;
import io.helidon.tracing.config.TracingConfig;
import java.util.LinkedList;
import java.util.List;

public interface PathTracingConfig {
    public static PathTracingConfig create(Config config) {
        return PathTracingConfig.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String path();

    public List<String> methods();

    public TracingConfig tracedConfig();

    public static final class Builder
    implements io.helidon.common.Builder<Builder, PathTracingConfig> {
        private final List<String> methods = new LinkedList<String>();
        private String path;
        private TracingConfig tracedConfig;

        private Builder() {
        }

        public PathTracingConfig build() {
            final String finalPath = this.path;
            final LinkedList<String> finalMethods = new LinkedList<String>(this.methods);
            final TracingConfig finalTracingConfig = this.tracedConfig;
            return new PathTracingConfig(){

                @Override
                public String path() {
                    return finalPath;
                }

                @Override
                public List<String> methods() {
                    return finalMethods;
                }

                @Override
                public TracingConfig tracedConfig() {
                    return finalTracingConfig;
                }

                public String toString() {
                    return path + "(" + finalMethods + "): " + finalTracingConfig;
                }
            };
        }

        public Builder config(Config config) {
            this.path((String)config.get("path").asString().get());
            List methods = (List)config.get("methods").asList(String.class).orElse(null);
            if (null != methods) {
                this.methods(methods);
            }
            this.tracingConfig(TracingConfig.create((Config)config));
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder methods(List<String> methods) {
            this.methods.clear();
            this.methods.addAll(methods);
            return this;
        }

        public Builder addMethod(String method) {
            this.methods.add(method);
            return this;
        }

        public Builder tracingConfig(TracingConfig tracedConfig) {
            this.tracedConfig = tracedConfig;
            return this;
        }
    }
}

