/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.common.SerializationConfig;
import io.helidon.common.context.Context;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.webserver.DirectHandlers;
import io.helidon.webserver.HttpInitializer;
import io.helidon.webserver.NettyInitializer;
import io.helidon.webserver.Router;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.SocketConfiguration;
import io.helidon.webserver.Transport;
import io.helidon.webserver.UpgradeManager;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerTls;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

class NettyWebServer
implements WebServer {
    static final String TRACING_COMPONENT = "web-server";
    private static final Logger LOGGER = Logger.getLogger(NettyWebServer.class.getName());
    private static final String EXIT_ON_STARTED_KEY = "exit.on.started";
    private static final boolean EXIT_ON_STARTED = "!".equals(System.getProperty("exit.on.started"));
    private final Transport transport;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final Map<String, ServerBootstrap> bootstraps = new HashMap<String, ServerBootstrap>();
    private final ServerConfiguration configuration;
    private final CompletableFuture<WebServer> startFuture = new CompletableFuture();
    private final CompletableFuture<WebServer> shutdownFuture = new CompletableFuture();
    private final CompletableFuture<WebServer> channelsUpFuture = new CompletableFuture();
    private final CompletableFuture<WebServer> channelsCloseFuture = new CompletableFuture();
    private final CompletableFuture<WebServer> threadGroupsShutdownFuture = new CompletableFuture();
    private final Context contextualRegistry;
    private final ConcurrentMap<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private final Map<String, HttpInitializer> initializers = new LinkedHashMap<String, HttpInitializer>();
    private final MessageBodyWriterContext writerContext;
    private final MessageBodyReaderContext readerContext;
    private volatile boolean started;
    private final AtomicBoolean shutdownThreadGroupsInitiated = new AtomicBoolean(false);
    private final Map<String, Router> routers;

    NettyWebServer(ServerConfiguration config, Map<String, Router> routers, MessageBodyWriterContext writerContext, MessageBodyReaderContext readerContext, DirectHandlers directHandlers) {
        Set<Map.Entry<String, SocketConfiguration>> sockets = config.sockets().entrySet();
        HelidonFeatures.print((HelidonFlavor)HelidonFlavor.SE, (String)"3.2.2", (boolean)config.printFeatureDetails());
        this.contextualRegistry = config.context();
        this.configuration = config;
        this.transport = this.acquireTransport();
        this.bossGroup = this.bossGroup();
        this.workerGroup = this.workerGroup();
        this.readerContext = MessageBodyReaderContext.create((MessageBodyReaderContext)readerContext);
        this.writerContext = MessageBodyWriterContext.create((MessageBodyWriterContext)writerContext);
        this.routers = routers;
        this.whenShutdown().forSingle(this::onShutDown);
        for (Map.Entry<String, SocketConfiguration> entry : sockets) {
            String name = entry.getKey();
            SocketConfiguration soConfig = entry.getValue();
            if (!soConfig.enabled()) {
                LOGGER.info("Channel '" + name + "' is disabled.");
                continue;
            }
            ServerBootstrap bootstrap = new ServerBootstrap();
            SslContext sslContext = soConfig.tls().map(this::createSslContext).orElse(null);
            if (soConfig.backlog() > 0) {
                bootstrap.option(ChannelOption.SO_BACKLOG, (Object)soConfig.backlog());
            }
            if (soConfig.timeoutMillis() > 0) {
                bootstrap.option(ChannelOption.SO_TIMEOUT, (Object)soConfig.timeoutMillis());
            }
            if (soConfig.receiveBufferSize() > 0) {
                bootstrap.option(ChannelOption.SO_RCVBUF, (Object)soConfig.receiveBufferSize());
            }
            Router router = routers.getOrDefault(name, routers.get("@default"));
            HttpInitializer childHandler = new HttpInitializer(soConfig, sslContext, router, this, directHandlers);
            this.initializers.put(name, childHandler);
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channelFactory(this.serverChannelFactory())).handler((ChannelHandler)new LoggingHandler(NettyLog.class, LogLevel.DEBUG))).childHandler((ChannelHandler)childHandler);
            this.bootstraps.put(name, bootstrap);
        }
        String maxOrderProp = NettyInitializer.getMaxOrderProperty();
        String maxOrderValue = NettyInitializer.getMaxOrderValue();
        LOGGER.fine(() -> maxOrderProp + " set to " + maxOrderValue);
    }

    private SslContext createSslContext(WebServerTls webServerTls) {
        SSLContext context = webServerTls.sslContext();
        if (context != null) {
            Collection<String> enabledProtocols = webServerTls.enabledTlsProtocols();
            String[] protocols = enabledProtocols.isEmpty() ? null : enabledProtocols.toArray(new String[0]);
            Set<String> cipherSuite = webServerTls.cipherSuite();
            return new JdkSslContext(context, false, cipherSuite.isEmpty() ? null : cipherSuite, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, UpgradeManager.alpnConfig(), webServerTls.clientAuth().nettyClientAuth(), protocols, false);
        }
        return null;
    }

    @Override
    public ServerConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public MessageBodyReaderContext readerContext() {
        return this.readerContext;
    }

    @Override
    public MessageBodyWriterContext writerContext() {
        return this.writerContext;
    }

    @Override
    public synchronized Single<WebServer> start() {
        if (this.shutdownThreadGroupsInitiated.get() || this.startFuture.isDone() && this.shutdownFuture.isDone()) {
            throw new IllegalStateException("WebServer cannot be restarted once it has been shutdown, or it failed to start.");
        }
        if (!this.started) {
            SerializationConfig.configureRuntime();
            ((CompletableFuture)this.channelsUpFuture.thenAccept(this::started)).exceptionally(throwable -> {
                if (this.channels.isEmpty()) {
                    this.startFailureHandler((Throwable)throwable);
                }
                for (Channel channel : this.channels.values()) {
                    channel.close();
                }
                return null;
            });
            this.channelsCloseFuture.whenComplete((webServer, throwable) -> this.shutdown((Throwable)throwable));
            Set<Map.Entry<String, ServerBootstrap>> bootstrapEntries = this.bootstraps.entrySet();
            int bootstrapsSize = bootstrapEntries.size();
            for (Map.Entry<String, ServerBootstrap> entry : bootstrapEntries) {
                ServerBootstrap bootstrap = entry.getValue();
                String name = entry.getKey();
                SocketConfiguration socketConfig = this.configuration.socket(name);
                if (socketConfig == null) {
                    throw new IllegalStateException("no socket configuration found for name: " + name);
                }
                int port = Math.max(socketConfig.port(), 0);
                if (this.channelsUpFuture.isCompletedExceptionally()) break;
                InetAddress bindAddress = socketConfig.bindAddress();
                if (bindAddress == null) {
                    bindAddress = this.configuration.bindAddress();
                }
                try {
                    bootstrap.bind(bindAddress, port).addListener(channelFuture -> {
                        if (!channelFuture.isSuccess()) {
                            LOGGER.info(() -> "Channel '" + name + "' startup failed with message '" + channelFuture.cause().getMessage() + "'.");
                            Throwable cause = channelFuture.cause();
                            String message = "Channel startup failed: " + name;
                            if (cause instanceof BindException) {
                                message = message + ", failed to listen on " + this.configuration.bindAddress() + ":" + port;
                            }
                            this.channelsUpFuture.completeExceptionally(new IllegalStateException(message, channelFuture.cause()));
                            return;
                        }
                        Channel channel = ((ChannelFuture)channelFuture).channel();
                        LOGGER.info(() -> "Channel '" + name + "' started: " + channel + (socketConfig.tls().isPresent() ? " with TLS " : ""));
                        this.channels.put(name, channel);
                        channel.closeFuture().addListener(future -> {
                            LOGGER.info(() -> "Channel '" + name + "' closed: " + channel);
                            this.channels.remove(name);
                            if (this.channelsUpFuture.isCompletedExceptionally()) {
                                if (this.channels.isEmpty()) {
                                    this.channelsUpFuture.exceptionally(this::startFailureHandler);
                                } else if (future.cause() != null) {
                                    LOGGER.log(Level.WARNING, "Startup failure channel close failure", new IllegalStateException(future.cause()));
                                }
                            } else if (!future.isSuccess()) {
                                this.channelsCloseFuture.completeExceptionally(new IllegalStateException("Channel stop failure.", future.cause()));
                            } else if (this.channels.isEmpty()) {
                                this.channelsCloseFuture.complete(this);
                            }
                        });
                        if (this.channelsUpFuture.isCompletedExceptionally()) {
                            channel.close();
                        }
                        if (this.channels.size() >= bootstrapsSize) {
                            LOGGER.finer(() -> "All channels started: " + this.channels.size());
                            this.channelsUpFuture.complete(this);
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    if (this.shutdownThreadGroupsInitiated.get()) break;
                    throw e;
                }
            }
            this.started = true;
            LOGGER.fine(() -> "All channels startup routine initiated: " + bootstrapsSize);
        }
        return Single.create(this.startFuture);
    }

    private void started(WebServer server) {
        if (EXIT_ON_STARTED) {
            LOGGER.info(String.format("Exiting, -D%s set.", EXIT_ON_STARTED_KEY));
            System.exit(0);
        } else {
            this.startFuture.complete(server);
        }
    }

    private WebServer startFailureHandler(Throwable throwable) {
        this.shutdownThreadGroups().whenComplete((webServer, t) -> {
            if (t != null) {
                LOGGER.log(Level.WARNING, "Netty Thread Groups were unable to shutdown.", (Throwable)t);
            }
            this.shutdownFuture.complete(this);
            this.startFuture.completeExceptionally(new IllegalStateException("WebServer was unable to start.", throwable));
        });
        return null;
    }

    private void shutdown(Throwable cause) {
        this.shutdownThreadGroups().whenComplete((webServer, throwable) -> {
            if (cause == null && throwable == null) {
                this.shutdownFuture.complete(this);
            } else if (cause != null) {
                if (throwable != null) {
                    LOGGER.log(Level.WARNING, "Netty Thread Groups were unable to shutdown.", (Throwable)throwable);
                }
                this.shutdownFuture.completeExceptionally(new IllegalStateException("WebServer was unable to stop.", cause));
            } else {
                this.shutdownFuture.completeExceptionally(new IllegalStateException("WebServer was unable to stop.", (Throwable)throwable));
            }
        });
    }

    private CompletionStage<WebServer> shutdownThreadGroups() {
        if (this.shutdownThreadGroupsInitiated.getAndSet(true)) {
            return this.threadGroupsShutdownFuture;
        }
        this.forceQueuesRelease();
        long maxShutdownTimeoutSeconds = this.configuration.maxShutdownTimeout().toSeconds();
        long shutdownQuietPeriod = this.configuration.shutdownQuietPeriod().toSeconds();
        Future bossGroupFuture = this.bossGroup.shutdownGracefully(shutdownQuietPeriod, maxShutdownTimeoutSeconds, TimeUnit.SECONDS);
        Future workerGroupFuture = this.workerGroup.shutdownGracefully(shutdownQuietPeriod, maxShutdownTimeoutSeconds, TimeUnit.SECONDS);
        workerGroupFuture.addListener(workerFuture -> bossGroupFuture.addListener(bossFuture -> {
            if (workerFuture.isSuccess() && bossFuture.isSuccess()) {
                this.threadGroupsShutdownFuture.complete(this);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append((String)(workerFuture.cause() != null ? "Worker Group problem: " + workerFuture.cause().getMessage() : "")).append((String)(bossFuture.cause() != null ? "Boss Group problem: " + bossFuture.cause().getMessage() : ""));
                this.threadGroupsShutdownFuture.completeExceptionally(new IllegalStateException("Unable to shutdown Netty thread groups: " + sb));
            }
        }));
        return this.threadGroupsShutdownFuture;
    }

    private void forceQueuesRelease() {
        this.initializers.values().removeIf(httpInitializer -> {
            httpInitializer.queuesShutdown();
            return true;
        });
    }

    @Override
    public Single<WebServer> shutdown() {
        if (!this.startFuture.isDone()) {
            this.startFuture.cancel(true);
        }
        if (this.channels.isEmpty()) {
            this.channelsCloseFuture.complete(this);
        }
        for (Channel channel : this.channels.values()) {
            channel.close();
        }
        return Single.create(this.shutdownFuture);
    }

    @Override
    public Single<WebServer> whenShutdown() {
        return Single.create(this.shutdownFuture);
    }

    @Override
    public boolean isRunning() {
        return this.startFuture.isDone() && !this.shutdownFuture.isDone();
    }

    @Override
    public Context context() {
        return this.contextualRegistry;
    }

    @Override
    public int port(String name) {
        Channel channel = (Channel)this.channels.get(name);
        if (channel == null) {
            return -1;
        }
        SocketAddress address = channel.localAddress();
        return address instanceof InetSocketAddress ? ((InetSocketAddress)address).getPort() : -1;
    }

    @Override
    public boolean hasTls(String socketName) {
        HttpInitializer httpInitializer = this.initializers.get(socketName);
        if (httpInitializer == null) {
            return false;
        }
        return httpInitializer.hasTls();
    }

    @Override
    public void updateTls(WebServerTls tls) {
        this.updateTls(tls, "@default");
    }

    @Override
    public void updateTls(WebServerTls tls, String socketName) {
        Objects.requireNonNull(tls, "Tls could not be updated. WebServerTls is required to be non-null");
        HttpInitializer httpInitializer = this.initializers.get(socketName);
        if (httpInitializer == null) {
            throw new IllegalStateException("Unknown socket name: " + socketName);
        }
        if (!tls.enabled()) {
            throw new IllegalStateException("Tls could not be updated. WebServerTls is required to be enabled");
        }
        SslContext context = this.createSslContext(tls);
        httpInitializer.updateSslContext(context);
    }

    private Transport acquireTransport() {
        Transport transport = this.configuration.transport().orElse(new NioTransport());
        if (!transport.isAvailableFor(this)) {
            transport = new NioTransport();
        }
        LOGGER.fine("Using Transport " + transport);
        return transport;
    }

    private Transport transport() {
        return this.transport;
    }

    private EventLoopGroup bossGroup() {
        return this.transport().createTransportArtifact(EventLoopGroup.class, "bossGroup", this.configuration).orElseThrow(() -> this.noSuchTransportArtifact("bossGroup"));
    }

    private EventLoopGroup workerGroup() {
        return this.transport().createTransportArtifact(EventLoopGroup.class, "workerGroup", this.configuration).orElseThrow(() -> this.noSuchTransportArtifact("workerGroup"));
    }

    private <T extends ServerChannel> ChannelFactory<T> serverChannelFactory() {
        return this.transport().createTransportArtifact(ChannelFactory.class, "serverChannelFactory", this.configuration).orElseThrow(() -> this.noSuchTransportArtifact("serverChannelFactory"));
    }

    private NoSuchElementException noSuchTransportArtifact(String name) {
        return new NoSuchElementException("The current webserver transport, " + this.transport() + ", could not supply a transport artifact named \"" + name + "\"");
    }

    private void onShutDown(WebServer ws) {
        this.routers.values().forEach(Router::afterStop);
    }

    private static final class NettyLog {
        private NettyLog() {
        }
    }

    private static final class NioTransport
    implements Transport {
        private NioTransport() {
        }

        @Override
        public boolean isAvailableFor(WebServer webserver) {
            return webserver instanceof NettyWebServer;
        }

        @Override
        public <T> Optional<T> createTransportArtifact(Class<T> artifactType, String artifactName, ServerConfiguration config) {
            if (EventLoopGroup.class.isAssignableFrom(artifactType)) {
                switch (artifactName) {
                    case "bossGroup": {
                        return Optional.of(new NioEventLoopGroup(config.sockets().size()));
                    }
                    case "workerGroup": {
                        return Optional.of(new NioEventLoopGroup(Math.max(0, config.workersCount())));
                    }
                }
                return Optional.empty();
            }
            if (ChannelFactory.class.isAssignableFrom(artifactType)) {
                switch (artifactName) {
                    case "serverChannelFactory": {
                        ChannelFactory cf = NioServerSocketChannel::new;
                        return Optional.of(cf);
                    }
                }
                return Optional.empty();
            }
            return Optional.empty();
        }
    }
}

