/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.context.Context;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.DeprecatedConfig;
import io.helidon.tracing.Tracer;
import io.helidon.webserver.ServerBasicConfig;
import io.helidon.webserver.SocketConfiguration;
import io.helidon.webserver.Transport;
import io.helidon.webserver.WebServerTls;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

public interface ServerConfiguration
extends SocketConfiguration {
    public int workersCount();

    @Override
    public int port();

    @Override
    public InetAddress bindAddress();

    @Override
    public int backlog();

    @Override
    public int timeoutMillis();

    @Override
    public int receiveBufferSize();

    @Deprecated
    default public SocketConfiguration socket(String name) {
        return this.namedSocket(name).orElse(null);
    }

    default public Optional<SocketConfiguration> namedSocket(String name) {
        return Optional.ofNullable(this.sockets().get(name));
    }

    public Map<String, SocketConfiguration> sockets();

    default public Duration maxShutdownTimeout() {
        return Duration.ofSeconds(10L);
    }

    default public Duration shutdownQuietPeriod() {
        return Duration.ofSeconds(0L);
    }

    public Tracer tracer();

    public Context context();

    default public Optional<Transport> transport() {
        return Optional.ofNullable(null);
    }

    public boolean printFeatureDetails();

    public static ServerConfiguration create(Config config) {
        return ServerConfiguration.builder(config).build();
    }

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder builder(Config config) {
        return new Builder().config(config);
    }

    @Deprecated
    public static final class Builder
    implements SocketConfiguration.SocketConfigurationBuilder<Builder>,
    io.helidon.common.Builder<Builder, ServerConfiguration> {
        private static final AtomicInteger WEBSERVER_COUNTER = new AtomicInteger(1);
        private final Map<String, SocketConfiguration.Builder> socketBuilders = new HashMap<String, SocketConfiguration.Builder>();
        private final Map<String, SocketConfiguration> socketsConfigs = new HashMap<String, SocketConfiguration>();
        private int workers;
        private Tracer tracer;
        private Duration maxShutdownTimeout;
        private Duration shutdownQuietPeriod;
        private Optional<Transport> transport = Optional.ofNullable(null);
        private Context context;
        private boolean printFeatureDetails;

        private Builder() {
            this.maxShutdownTimeout = Duration.ofSeconds(10L);
            this.shutdownQuietPeriod = Duration.ofSeconds(0L);
        }

        public Builder ssl(SSLContext sslContext) {
            this.defaultSocketBuilder().ssl(sslContext);
            return this;
        }

        public Builder ssl(Supplier<? extends SSLContext> sslContextBuilder) {
            this.defaultSocketBuilder().ssl(sslContextBuilder);
            return this;
        }

        @Override
        public Builder port(int port) {
            this.defaultSocketBuilder().port(port);
            return this;
        }

        @Override
        public Builder bindAddress(InetAddress bindAddress) {
            this.defaultSocketBuilder().bindAddress(bindAddress);
            return this;
        }

        @Override
        public Builder backlog(int size) {
            this.defaultSocketBuilder().backlog(size);
            return this;
        }

        public Builder timeout(int milliseconds) {
            this.defaultSocketBuilder().timeoutMillis(milliseconds);
            return this;
        }

        @Override
        public Builder receiveBufferSize(int bytes) {
            this.defaultSocketBuilder().receiveBufferSize(bytes);
            return this;
        }

        @Override
        public Builder maxHeaderSize(int size) {
            this.defaultSocketBuilder().maxHeaderSize(size);
            return this;
        }

        @Override
        public Builder maxInitialLineLength(int length) {
            this.defaultSocketBuilder().maxInitialLineLength(length);
            return this;
        }

        @Deprecated
        public Builder addSocket(String name, int port, InetAddress bindAddress) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            return this.addSocket(name, SocketConfiguration.builder().port(port).bindAddress(bindAddress));
        }

        public Builder addSocket(String name, SocketConfiguration socketConfiguration) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            this.socketsConfigs.put(name, socketConfiguration);
            return this;
        }

        public Builder addSocket(String name, SocketConfiguration.Builder socketConfiguration) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            this.socketBuilders.put(name, socketConfiguration);
            return this;
        }

        public Builder addSocket(String name, Supplier<SocketConfiguration> socketConfigurationBuilder) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            return this.addSocket(name, socketConfigurationBuilder != null ? socketConfigurationBuilder.get() : null);
        }

        public Builder workersCount(int workers) {
            this.workers = workers;
            return this;
        }

        public Builder tracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder tracer(Supplier<? extends Tracer> tracerBuilder) {
            return this.tracer(tracerBuilder.get());
        }

        public Builder enabledSSlProtocols(String ... protocols) {
            this.defaultSocketBuilder().enabledSSlProtocols(protocols);
            return this;
        }

        public Builder enabledSSlProtocols(List<String> protocols) {
            this.defaultSocketBuilder().enabledSSlProtocols(protocols);
            return this;
        }

        @Override
        public Builder maxPayloadSize(long size) {
            this.defaultSocketBuilder().maxPayloadSize(size);
            return this;
        }

        @Override
        public Builder maxUpgradeContentLength(int size) {
            this.defaultSocketBuilder().maxUpgradeContentLength(size);
            return this;
        }

        public Builder maxShutdownTimeout(Duration maxShutdownTimeout) {
            this.maxShutdownTimeout = Objects.requireNonNull(maxShutdownTimeout, "Parameter 'maxShutdownTimeout' must not be null!");
            return this;
        }

        public Builder shutdownQuietPeriod(Duration shutdownQuietPeriod) {
            this.shutdownQuietPeriod = Objects.requireNonNull(shutdownQuietPeriod, "Parameter 'shutdownQuietPeriod' must not be null!");
            return this;
        }

        public Builder transport(Transport transport) {
            this.transport = Optional.of(transport);
            return this;
        }

        public Builder printFeatureDetails(boolean print) {
            this.printFeatureDetails = print;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        private InetAddress string2InetAddress(String address) {
            try {
                return InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                throw new ConfigException("Illegal value of 'bind-address' configuration key. Expecting host or ip address!", (Throwable)e);
            }
        }

        @Override
        public Builder config(Config config) {
            if (config == null) {
                return this;
            }
            this.defaultSocketBuilder().config(config);
            config.get("host").asString().ifPresent(this.defaultSocketBuilder()::host);
            DeprecatedConfig.get((Config)config, (String)"worker-count", (String)"workers").asInt().ifPresent(this::workersCount);
            config.get("features.print-details").asBoolean().ifPresent(this::printFeatureDetails);
            config.get("max-shutdown-timeout-seconds").asLong().ifPresent(it -> this.maxShutdownTimeout(Duration.ofSeconds(it)));
            config.get("shutdown-quiet-period-seconds").asLong().ifPresent(it -> this.shutdownQuietPeriod(Duration.ofSeconds(it)));
            Config socketsConfig = config.get("sockets");
            if (socketsConfig.exists()) {
                List socketConfigs = (List)socketsConfig.asNodeList().orElse(List.of());
                for (Config socketConfig : socketConfigs) {
                    String nodeName = socketConfig.name();
                    Optional maybeSocketName = socketConfig.get("name").asString().asOptional();
                    String socketName = maybeSocketName.orElse(nodeName);
                    try {
                        Integer.parseInt(nodeName);
                        if (socketName.equals(nodeName) && maybeSocketName.isEmpty()) {
                            throw new ConfigException("Cannot find \"name\" key for socket configuration " + socketConfig.key());
                        }
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(SocketConfiguration.SocketConfigurationBuilder.class.getName()).warning("Socket configuration at " + socketConfig.key() + " is deprecated. Please use an array with \"name\" key to define the socket name.");
                    }
                    SocketConfiguration.Builder socket = SocketConfiguration.builder().name(socketName).config(socketConfig);
                    this.socketBuilders.put(socket.name(), socket);
                }
            }
            return this;
        }

        public ServerConfiguration build() {
            if (null == this.context) {
                this.context = Context.builder().id("web-" + WEBSERVER_COUNTER.getAndIncrement()).build();
            }
            Optional maybeTracer = this.context.get(Tracer.class);
            if (null == this.tracer) {
                this.tracer = maybeTracer.orElseGet(Tracer::global);
            }
            if (maybeTracer.isEmpty()) {
                this.context.register((Object)this.tracer);
            }
            if (this.workers <= 0) {
                this.workers = Runtime.getRuntime().availableProcessors();
            }
            return new ServerBasicConfig(this);
        }

        SocketConfiguration.Builder defaultSocketBuilder() {
            return this.socketBuilder("@default");
        }

        SocketConfiguration.Builder socketBuilder(String socketName) {
            return this.socketBuilders.computeIfAbsent(socketName, k -> SocketConfiguration.builder().name(socketName));
        }

        Map<String, SocketConfiguration> sockets() {
            Set<String> builtSocketConfigsKeys = this.socketsConfigs.keySet();
            HashMap<String, SocketConfiguration> result = new HashMap<String, SocketConfiguration>(this.socketBuilders.size() + this.socketsConfigs.size());
            for (Map.Entry<String, SocketConfiguration.Builder> e : this.socketBuilders.entrySet()) {
                String key = e.getKey();
                if (builtSocketConfigsKeys.contains(key)) {
                    throw new IllegalStateException("Both mutable and immutable socket configuration provided for named socket " + key);
                }
                result.put(key, e.getValue().build());
            }
            result.putAll(this.socketsConfigs);
            return result;
        }

        int workers() {
            return this.workers;
        }

        Tracer tracer() {
            return this.tracer;
        }

        Duration maxShutdownTimeout() {
            return this.maxShutdownTimeout;
        }

        Duration shutdownQuietPeriod() {
            return this.shutdownQuietPeriod;
        }

        Optional<Transport> transport() {
            return this.transport;
        }

        Context context() {
            return this.context;
        }

        boolean printFeatureDetails() {
            return this.printFeatureDetails;
        }

        @Override
        public Builder timeout(long amount, TimeUnit unit) {
            this.defaultSocketBuilder().timeout(amount, unit);
            return this;
        }

        @Override
        public Builder tls(WebServerTls webServerTls) {
            this.defaultSocketBuilder().tls(webServerTls);
            return this;
        }

        @Override
        public Builder enableCompression(boolean value) {
            this.defaultSocketBuilder().enableCompression(value);
            return this;
        }
    }
}

