/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.HashParameters;
import io.helidon.common.http.Parameters;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

final class UriComponent {
    private UriComponent() {
    }

    static Parameters decodeQuery(String query, boolean decode) {
        return UriComponent.decodeQuery(query, true, decode);
    }

    static Parameters decodeQuery(String query, boolean decodeNames, boolean decodeValues) {
        int e;
        HashParameters queryParameters = HashParameters.create();
        if (query == null || query.isEmpty()) {
            return queryParameters;
        }
        int s = 0;
        do {
            if ((e = query.indexOf(38, s)) == -1) {
                UriComponent.decodeQueryParam((Parameters)queryParameters, query.substring(s), decodeNames, decodeValues);
                continue;
            }
            if (e <= s) continue;
            UriComponent.decodeQueryParam((Parameters)queryParameters, query.substring(s, e), decodeNames, decodeValues);
        } while ((s = e + 1) > 0 && s < query.length());
        return queryParameters;
    }

    private static void decodeQueryParam(Parameters params, String param, boolean decodeNames, boolean decodeValues) {
        int equals = param.indexOf(61);
        if (equals > 0) {
            params.add(decodeNames ? URLDecoder.decode(param.substring(0, equals), StandardCharsets.UTF_8) : param.substring(0, equals), new String[]{decodeValues ? URLDecoder.decode(param.substring(equals + 1), StandardCharsets.UTF_8) : param.substring(equals + 1)});
        } else {
            if (equals == 0) {
                return;
            }
            if (!param.isEmpty()) {
                params.add(decodeNames ? URLDecoder.decode(param, StandardCharsets.UTF_8) : param, new String[]{""});
            }
        }
    }
}

