/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.logging.common.HelidonMdc;
import io.helidon.webserver.BadRequestException;
import io.helidon.webserver.BareRequestImpl;
import io.helidon.webserver.BareResponseImpl;
import io.helidon.webserver.ByteBufRequestChunk;
import io.helidon.webserver.DirectHandler;
import io.helidon.webserver.DirectHandlers;
import io.helidon.webserver.HttpInitializer;
import io.helidon.webserver.HttpRequestScopedPublisher;
import io.helidon.webserver.NettyWebServer;
import io.helidon.webserver.ReferenceHoldingQueue;
import io.helidon.webserver.RequestContext;
import io.helidon.webserver.Routing;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerTls;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class ForwardingHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = Logger.getLogger(ForwardingHandler.class.getName());
    private static final AtomicLong REQUEST_ID_GENERATOR = new AtomicLong(0L);
    private static final String MDC_SCOPE_ID = "io.helidon.scope-id";
    private final Routing routing;
    private final NettyWebServer webServer;
    private final SSLEngine sslEngine;
    private final ReferenceQueue<Object> queues;
    private final long maxPayloadSize;
    private final Runnable clearQueues;
    private final DirectHandlers directHandlers;
    private RequestContext requestContext;
    private long actualPayloadSize;
    private boolean ignorePayload;
    private CompletableFuture<ChannelFutureListener> requestEntityAnalyzed;
    private CompletableFuture<?> prevRequestFuture;
    private boolean lastContent;

    ForwardingHandler(Routing routing, NettyWebServer webServer, SSLEngine sslEngine, ReferenceQueue<Object> queues, Runnable clearQueues, long maxPayloadSize, DirectHandlers directHandlers) {
        this.routing = routing;
        this.webServer = webServer;
        this.sslEngine = sslEngine;
        this.queues = queues;
        this.maxPayloadSize = maxPayloadSize;
        this.clearQueues = clearQueues;
        this.directHandlers = directHandlers;
    }

    private void reset() {
        this.lastContent = false;
        this.actualPayloadSize = 0L;
        this.ignorePayload = false;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
        if (this.requestContext == null) {
            if (this.lastContent) {
                LOGGER.fine(() -> this.log("Read complete lastContent", ctx, new Object[0]));
                ctx.channel().config().setAutoRead(true);
            } else {
                LOGGER.fine(() -> this.log("Read complete not lastContent", ctx, new Object[0]));
            }
            return;
        }
        if (this.requestContext.hasRequests()) {
            LOGGER.fine(() -> this.log("Read complete has requests: %s", ctx, this.requestContext));
            ctx.channel().read();
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            Context requestScope = Context.create((Context)this.webServer.context());
            requestScope.register((Object)(WebServer.class.getName() + ".connection"), (Object)("0x" + ctx.channel().id()));
            HelidonMdc.set((String)MDC_SCOPE_ID, (String)requestScope.id());
            boolean shouldReturn = (Boolean)Contexts.runInContext((Context)requestScope, () -> this.channelReadHttpRequest(ctx, requestScope, msg));
            if (shouldReturn) {
                HelidonMdc.remove((String)MDC_SCOPE_ID);
                return;
            }
        }
        if (this.requestContext != null) {
            HelidonMdc.set((String)MDC_SCOPE_ID, (String)this.requestContext.scope().id());
        }
        if (msg instanceof HttpContent) {
            if (this.requestContext == null) {
                LOGGER.fine(() -> this.log("Received HttpContent: %s", ctx, System.identityHashCode(msg)));
                HelidonMdc.remove((String)MDC_SCOPE_ID);
                throw new IllegalStateException("There is no request context associated with this http content. This is never expected to happen!");
            }
            this.requestContext.runInScope(() -> this.channelReadHttpContent(ctx, msg));
        }
        if (msg instanceof ByteBuf) {
            HelidonMdc.remove((String)MDC_SCOPE_ID);
            throw new IllegalStateException("Received ByteBuf without upgrading to WebSockets");
        }
        HelidonMdc.remove((String)MDC_SCOPE_ID);
    }

    private void channelReadHttpContent(ChannelHandlerContext ctx, Object msg) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.log("Received HttpContent: %s", ctx, System.identityHashCode(msg)));
        }
        this.lastContent = false;
        HttpContent httpContent = (HttpContent)msg;
        ByteBuf content = httpContent.content();
        if (content.isReadable()) {
            HttpMethod method = this.requestContext.request().method();
            if (HttpMethod.TRACE.equals((Object)method)) {
                this.requestEntityAnalyzed.complete(ChannelFutureListener.CLOSE);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(this.log("Closing connection illegal payload; method: ", ctx, method));
                }
                throw new BadRequestException("It is illegal to send a payload with http method: " + method);
            }
            if (this.requestContext.responseCompleted() && !(msg instanceof LastHttpContent)) {
                LOGGER.finer(() -> this.log("Closing connection unconsumed payload; method: ", ctx, method));
                ctx.close();
            } else if (!this.ignorePayload) {
                if (this.maxPayloadSize >= 0L) {
                    this.actualPayloadSize += (long)content.readableBytes();
                    if (this.actualPayloadSize > this.maxPayloadSize) {
                        LOGGER.finer(() -> this.log("Chunked Payload over max %d > %d", ctx, this.actualPayloadSize, this.maxPayloadSize));
                        this.ignorePayload = true;
                        this.send413PayloadTooLarge(ctx, this.requestContext.request());
                    } else {
                        this.requestContext.emit(content);
                    }
                } else {
                    this.requestContext.emit(content);
                }
            }
        }
        if (msg instanceof LastHttpContent) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this.log("Received LastHttpContent: %s", ctx, System.identityHashCode(msg)));
            }
            this.lastContent = true;
            this.requestContext.complete();
            this.requestContext = null;
            this.requestEntityAnalyzed.complete(ChannelFutureListener.CLOSE_ON_FAILURE);
        } else if (!content.isReadable()) {
            throw new IllegalStateException("It is not expected to not have readable content.");
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.requestContext != null) {
            this.requestContext.fail(new IOException("Channel closed prematurely by other side!"));
        }
    }

    private boolean channelReadHttpRequest(ChannelHandlerContext ctx, Context requestScope, Object msg) {
        String contentLength;
        BareRequestImpl bareRequest;
        X509Certificate cert;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.log("Received HttpRequest: %s. Remote address: %s. Scope id: %s", ctx, System.identityHashCode(msg), ctx.channel().remoteAddress(), requestScope.id()));
        }
        this.clearQueues.run();
        ctx.channel().config().setAutoRead(false);
        this.reset();
        HttpRequest request = (HttpRequest)msg;
        try {
            this.checkDecoderResult(request);
        }
        catch (Throwable e) {
            LOGGER.finest(() -> this.log("Invalid HTTP request. %s", ctx, e.getMessage()));
            this.send400BadRequest(ctx, request, e);
            return true;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(this.log("Requested URI: %s %s", ctx, request.method(), request.uri()));
        }
        request.headers().remove("X-HELIDON-CN");
        String cn = (String)ctx.channel().attr(HttpInitializer.CLIENT_CERTIFICATE_NAME).get();
        if (cn != null) {
            request.headers().set("X-HELIDON-CN", (Object)cn);
        }
        if ((cert = (X509Certificate)ctx.channel().attr(HttpInitializer.CLIENT_CERTIFICATE).get()) != null) {
            requestScope.register((Object)WebServerTls.CLIENT_X509_CERTIFICATE, (Object)cert);
        }
        ByteBufRequestChunk.DataChunkHoldingQueue queue = new ByteBufRequestChunk.DataChunkHoldingQueue();
        HttpRequestScopedPublisher publisher = new HttpRequestScopedPublisher(queue);
        RequestContext requestContextRef = this.requestContext = new RequestContext(publisher, request, requestScope);
        ReferenceHoldingQueue.IndirectReference<Object, ByteBufRequestChunk.DataChunkHoldingQueue> publisherRef = new ReferenceHoldingQueue.IndirectReference<Object, ByteBufRequestChunk.DataChunkHoldingQueue>((Object)publisher, this.queues, queue);
        publisher.onRequest((n, demand) -> {
            if (publisher.isUnbounded()) {
                LOGGER.finest(() -> this.log("Netty autoread: true", ctx, new Object[0]));
                ctx.channel().config().setAutoRead(true);
            } else {
                LOGGER.finest(() -> this.log("Netty autoread: false", ctx, new Object[0]));
                ctx.channel().config().setAutoRead(false);
            }
            if (publisher.hasRequests()) {
                LOGGER.finest(() -> this.log("Requesting next (%d, %d) chunks from Netty", ctx, n, demand));
                ctx.channel().read();
            } else {
                LOGGER.finest(() -> this.log("No hook action required", ctx, new Object[0]));
            }
        });
        long requestId = REQUEST_ID_GENERATOR.incrementAndGet();
        try {
            bareRequest = new BareRequestImpl(request, (Flow.Publisher<DataChunk>)requestContextRef.publisher(), this.webServer, ctx, this.sslEngine, requestId);
        }
        catch (IllegalArgumentException e) {
            this.send400BadRequest(ctx, request, e);
            return true;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(this.log("Request id: %s", ctx, bareRequest.requestId()));
        }
        if ("0".equals(contentLength = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) && !"upgrade".equalsIgnoreCase(request.headers().get((CharSequence)HttpHeaderNames.CONNECTION)) || contentLength == null && !"upgrade".equalsIgnoreCase(request.headers().get((CharSequence)HttpHeaderNames.CONNECTION)) && !"chunked".equalsIgnoreCase(request.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) && !"multipart/byteranges".equalsIgnoreCase(request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE))) {
            requestContextRef.complete();
        }
        if (this.maxPayloadSize >= 0L && contentLength != null) {
            try {
                long value = Long.parseLong(contentLength);
                if (value > this.maxPayloadSize) {
                    LOGGER.fine(() -> this.log("Payload length over max %d > %d", ctx, value, this.maxPayloadSize));
                    this.ignorePayload = true;
                    this.send413PayloadTooLarge(ctx, request);
                    return true;
                }
            }
            catch (NumberFormatException e) {
                this.send400BadRequest(ctx, request, e);
                return true;
            }
        }
        if (this.prevRequestFuture != null && this.prevRequestFuture.isDone()) {
            this.prevRequestFuture = null;
        }
        this.requestEntityAnalyzed = new CompletableFuture();
        if (!HttpUtil.isKeepAlive((HttpMessage)this.requestContext.request())) {
            this.requestEntityAnalyzed.complete(ChannelFutureListener.CLOSE);
        }
        BareResponseImpl bareResponse = new BareResponseImpl(ctx, request, this.requestContext, this.prevRequestFuture, this.requestEntityAnalyzed, requestId);
        CompletableFuture<?> thisResp = this.prevRequestFuture = new CompletableFuture();
        bareResponse.whenCompleted().thenRun(() -> {
            requestContextRef.responseCompleted(true);
            publisher.clearAndRelease();
            if (queue.release()) {
                publisherRef.acquire();
            }
            thisResp.complete(null);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this.log("Response complete: %s", ctx, System.identityHashCode(msg)));
            }
        });
        if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
            this.send100Continue(ctx, request);
        }
        try {
            this.requestContext.runInScope(() -> this.routing.route(bareRequest, bareResponse));
        }
        catch (IllegalArgumentException e) {
            this.send400BadRequest(ctx, request, e);
            return true;
        }
        return false;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.fine(() -> this.log("Exception caught: %s", ctx, cause.toString()));
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Exception stack trace: " + ctx, cause);
        }
        this.failPublisher(cause);
        ctx.close();
    }

    private void checkDecoderResult(HttpRequest request) {
        DecoderResult decoderResult = request.decoderResult();
        if (decoderResult.isFailure()) {
            LOGGER.info(() -> this.log("Request %s to %s rejected: %s", null, request.method().asciiName(), request.uri(), decoderResult.cause().getMessage()));
            throw new BadRequestException(String.format("Request was rejected: %s", decoderResult.cause().getMessage()), decoderResult.cause());
        }
    }

    private void send100Continue(ChannelHandlerContext ctx, HttpRequest request) {
        DirectHandler.TransportResponse transportResponse = this.directHandlers.handler(DirectHandler.EventType.CONTINUE).handle((DirectHandler.TransportRequest)new DirectHandlerRequest(request), DirectHandler.EventType.CONTINUE, (Http.ResponseStatus)Http.Status.CONTINUE_100, "");
        FullHttpResponse response = this.toNettyResponse(transportResponse);
        ctx.writeAndFlush((Object)response);
    }

    private void send400BadRequest(ChannelHandlerContext ctx, HttpRequest request, Throwable t) {
        DirectHandler.TransportResponse handlerResponse = this.directHandlers.handler(DirectHandler.EventType.BAD_REQUEST).handle((DirectHandler.TransportRequest)new DirectHandlerRequest(request), DirectHandler.EventType.BAD_REQUEST, (Http.ResponseStatus)Http.Status.BAD_REQUEST_400, t);
        FullHttpResponse response = this.toNettyResponse(handlerResponse);
        response.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.writeAndFlush((Object)response).addListener(future -> ctx.close());
        this.failPublisher(new Error("400: Bad request"));
    }

    private void send413PayloadTooLarge(ChannelHandlerContext ctx, HttpRequest request) {
        DirectHandler.TransportResponse transportResponse = this.directHandlers.handler(DirectHandler.EventType.PAYLOAD_TOO_LARGE).handle((DirectHandler.TransportRequest)new DirectHandlerRequest(request), DirectHandler.EventType.PAYLOAD_TOO_LARGE, (Http.ResponseStatus)Http.Status.REQUEST_ENTITY_TOO_LARGE_413, "");
        FullHttpResponse response = this.toNettyResponse(transportResponse);
        response.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.writeAndFlush((Object)response).addListener(future -> ctx.close());
        this.failPublisher(new Error("413: Payload is too large"));
    }

    private FullHttpResponse toNettyResponse(DirectHandler.TransportResponse handlerResponse) {
        Optional<byte[]> entity = handlerResponse.entity();
        Http.ResponseStatus status = handlerResponse.status();
        Map<String, List<String>> headers = handlerResponse.headers();
        HttpResponseStatus nettyStatus = HttpResponseStatus.valueOf((int)status.code(), (String)status.reasonPhrase());
        FullHttpResponse response = (FullHttpResponse)entity.map(bytes -> new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, Unpooled.wrappedBuffer((byte[])bytes))).orElseGet(() -> new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, nettyStatus));
        HttpHeaders nettyHeaders = response.headers();
        headers.forEach((arg_0, arg_1) -> ((HttpHeaders)nettyHeaders).add(arg_0, arg_1));
        return response;
    }

    private void failPublisher(Throwable cause) {
        if (this.requestContext != null) {
            this.requestContext.fail(cause);
        } else {
            LOGGER.finest(() -> "Error before request context established or after completed: " + cause);
        }
    }

    private String log(String template, ChannelHandlerContext ctx, Object ... params) {
        ArrayList<Object> list = new ArrayList<Object>(params.length + 2);
        list.add(System.identityHashCode((Object)this));
        list.add(ctx != null ? ctx.channel().id() : "N/A");
        list.addAll(Arrays.asList(params));
        return String.format("[Handler: %s, Channel: 0x%s] " + template, list.toArray());
    }

    private static final class DirectHandlerRequest
    implements DirectHandler.TransportRequest {
        private final String protocolVersion;
        private final String uri;
        private final String method;
        private final Map<String, List<String>> headers;

        private DirectHandlerRequest(HttpRequest request) {
            this.protocolVersion = request.protocolVersion().text();
            this.uri = request.uri();
            this.method = request.method().name();
            HashMap<String, List> result = new HashMap<String, List>();
            for (String name : request.headers().names()) {
                result.put(name, request.headers().getAll(name));
            }
            this.headers = Map.copyOf(result);
        }

        @Override
        public String protocolVersion() {
            return this.protocolVersion;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public String method() {
            return this.method;
        }

        @Override
        public Map<String, List<String>> headers() {
            return this.headers;
        }
    }
}

