/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class ByteBufDataChunk
implements DataChunk {
    private static final VarHandle IS_RELEASED;
    private final ByteBuf[] byteBufs;
    private final boolean flush;
    private final boolean readOnly;
    private final Runnable releaseCallback;
    private volatile int isReleased;
    private CompletableFuture<DataChunk> writeFuture;

    public static ByteBufDataChunk create(boolean flush, boolean readOnly, ByteBuf ... byteBufs) {
        return new ByteBufDataChunk(flush, readOnly, byteBufs);
    }

    public static ByteBufDataChunk create(boolean flush, boolean readOnly, Runnable releaseCallback, ByteBuf ... byteBufs) {
        return new ByteBufDataChunk(flush, readOnly, releaseCallback, byteBufs);
    }

    private ByteBufDataChunk(boolean flush, boolean readOnly, ByteBuf ... byteBufs) {
        this(flush, readOnly, (Runnable)null, byteBufs);
    }

    private ByteBufDataChunk(boolean flush, boolean readOnly, Runnable releaseCallback, ByteBuf ... byteBufs) {
        this.flush = flush;
        this.readOnly = readOnly;
        this.releaseCallback = releaseCallback;
        this.byteBufs = Objects.requireNonNull(byteBufs, "byteBuffers is null");
    }

    public <T> boolean isBackedBy(Class<T> clazz) {
        return ByteBuf.class.isAssignableFrom(clazz);
    }

    public <T> T[] data(Class<T> clazz) {
        return this.byteBufs;
    }

    public boolean isReleased() {
        return this.isReleased != 0;
    }

    public boolean flush() {
        return this.flush;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void release() {
        if (IS_RELEASED.compareAndSet(this, 0, 1) && this.releaseCallback != null) {
            this.releaseCallback.run();
        }
    }

    public void writeFuture(CompletableFuture<DataChunk> writeFuture) {
        this.writeFuture = writeFuture;
    }

    public Optional<CompletableFuture<DataChunk>> writeFuture() {
        return Optional.ofNullable(this.writeFuture);
    }

    public int remaining() {
        int remaining = 0;
        for (ByteBuf byteBuf : this.byteBufs) {
            remaining += byteBuf.readableBytes();
        }
        return remaining;
    }

    public ByteBuffer[] data() {
        int i = 0;
        ByteBuffer[] byteBuffers = new ByteBuffer[this.byteBufs.length];
        for (ByteBuf byteBuf : this.byteBufs) {
            byteBuffers[i++] = byteBuf.nioBuffer();
        }
        return byteBuffers;
    }

    public DataChunk duplicate() {
        throw new UnsupportedOperationException("Unsupported");
    }

    public byte[] bytes() {
        throw new UnsupportedOperationException("Unsupported");
    }

    public Iterator<ByteBuffer> iterator() {
        throw new UnsupportedOperationException("Unsupported");
    }

    static {
        try {
            IS_RELEASED = MethodHandles.lookup().findVarHandle(ByteBufDataChunk.class, "isReleased", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw (Error)new ExceptionInInitializerError(e.getMessage()).initCause(e);
        }
    }
}

