/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.Builder;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.webserver.HtmlEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@FunctionalInterface
public interface DirectHandler {
    default public TransportResponse handle(TransportRequest request, EventType eventType, Http.ResponseStatus defaultStatus, Throwable t) {
        return this.handle(request, eventType, defaultStatus, t.getMessage());
    }

    public TransportResponse handle(TransportRequest var1, EventType var2, Http.ResponseStatus var3, String var4);

    public static class TransportResponse {
        private final Http.ResponseStatus status;
        private final Map<String, List<String>> headers;
        private final byte[] entity;

        private TransportResponse(Builder builder) {
            this.status = builder.status;
            this.headers = builder.headers;
            this.entity = builder.entity;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static TransportResponse create(String message) {
            return TransportResponse.builder().entity(message).build();
        }

        Http.ResponseStatus status() {
            return this.status;
        }

        Map<String, List<String>> headers() {
            return this.headers;
        }

        Optional<byte[]> entity() {
            return Optional.ofNullable(this.entity);
        }

        public static class Builder
        implements io.helidon.common.Builder<TransportResponse> {
            private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
            private Http.ResponseStatus status = Http.Status.BAD_REQUEST_400;
            private byte[] entity;

            private Builder() {
            }

            public TransportResponse build() {
                return new TransportResponse(this);
            }

            public Builder status(Http.ResponseStatus status) {
                this.status = status;
                return this;
            }

            public Builder header(String name, String ... values) {
                if (name.equalsIgnoreCase("Connection")) {
                    throw new IllegalArgumentException("Connection header cannot be overridden, it is always set to Close fro transport errors");
                }
                this.headers.put(name, List.of(values));
                return this;
            }

            public Builder entity(String entity) {
                this.headers.putIfAbsent("Content-Type", List.of(MediaType.TEXT_PLAIN.toString()));
                return this.entity(HtmlEncoder.encode(entity).getBytes(StandardCharsets.UTF_8));
            }

            public Builder entity(byte[] entity) {
                this.entity = Arrays.copyOf(entity, entity.length);
                if (this.entity.length == 0) {
                    this.headers.remove("Content-Length");
                } else {
                    this.header("Content-Length", String.valueOf(entity.length));
                }
                return this;
            }
        }
    }

    public static enum EventType {
        BAD_REQUEST,
        PAYLOAD_TOO_LARGE,
        CONTINUE;

    }

    public static interface TransportRequest {
        public String protocolVersion();

        public String method();

        public String uri();

        public Map<String, List<String>> headers();
    }
}

