/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.GenericType;
import io.helidon.common.LazyValue;
import io.helidon.common.configurable.AllowList;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.Forwarded;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.http.ReadOnlyParameters;
import io.helidon.common.http.UriComponent;
import io.helidon.common.http.UriInfo;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyContext;
import io.helidon.media.common.MessageBodyReadableContent;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.helidon.webserver.BareRequest;
import io.helidon.webserver.HashRequestHeaders;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.SocketConfiguration;
import io.helidon.webserver.WebServer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;

abstract class Request
implements ServerRequest {
    private static final String TRACING_CONTENT_READ_NAME = "content-read";
    static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final BareRequest bareRequest;
    private final WebServer webServer;
    private final Context context;
    private final Parameters queryParams;
    private final HashRequestHeaders headers;
    private final MessageBodyReadableContent content;
    private final MessageBodyEventListener eventListener;
    private final LazyValue<UriInfo> requestedUri;

    Request(BareRequest req, WebServer webServer, HashRequestHeaders headers) {
        this.bareRequest = req;
        this.webServer = webServer;
        this.headers = headers;
        this.context = Contexts.context().orElseGet(() -> Context.create((Context)webServer.context()));
        this.queryParams = UriComponent.decodeQuery((String)req.uri().getRawQuery(), (boolean)true);
        this.eventListener = new MessageBodyEventListener();
        MessageBodyReaderContext readerContext = MessageBodyReaderContext.create((MessageBodyReaderContext)webServer.readerContext(), (MessageBodyContext.EventListener)this.eventListener, (ReadOnlyParameters)headers, headers.contentType());
        this.content = MessageBodyReadableContent.create(req.bodyPublisher(), (MessageBodyReaderContext)readerContext);
        this.requestedUri = LazyValue.create(this::createRequestedUri);
    }

    Request(Request request) {
        this.bareRequest = request.bareRequest;
        this.webServer = request.webServer;
        this.context = request.context;
        this.queryParams = request.queryParams;
        this.headers = request.headers;
        this.content = request.content;
        this.eventListener = request.eventListener;
        this.requestedUri = LazyValue.create(this::createRequestedUri);
    }

    static Charset contentCharset(ServerRequest request) {
        return request.headers().contentType().flatMap(MediaType::charset).map(Charset::forName).orElse(DEFAULT_CHARSET);
    }

    @Override
    public WebServer webServer() {
        return this.webServer;
    }

    @Override
    public Context context() {
        return this.context;
    }

    public Http.RequestMethod method() {
        return this.bareRequest.method();
    }

    public Http.Version version() {
        return this.bareRequest.version();
    }

    public URI uri() {
        return this.bareRequest.uri();
    }

    public String query() {
        return this.bareRequest.uri().getRawQuery();
    }

    public Parameters queryParams() {
        return this.queryParams;
    }

    public String fragment() {
        return this.bareRequest.uri().getFragment();
    }

    @Override
    public String localAddress() {
        return this.bareRequest.localAddress();
    }

    @Override
    public int localPort() {
        return this.bareRequest.localPort();
    }

    @Override
    public String remoteAddress() {
        return this.bareRequest.remoteAddress();
    }

    @Override
    public int remotePort() {
        return this.bareRequest.remotePort();
    }

    @Override
    public boolean isSecure() {
        return this.bareRequest.isSecure();
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }

    @Override
    public MessageBodyReadableContent content() {
        return this.content;
    }

    @Override
    public long requestId() {
        return this.bareRequest.requestId();
    }

    @Override
    public Single<Void> closeConnection() {
        return this.bareRequest.closeConnection();
    }

    @Override
    public UriInfo requestedUri() {
        return (UriInfo)this.requestedUri.get();
    }

    private UriInfo createRequestedUri() {
        AllowList trustedProxies;
        RequestHeaders headers = this.headers();
        String scheme = null;
        String authority = null;
        String host = null;
        int port = -1;
        String path = null;
        String query = this.query();
        if (this.bareRequest.socketConfiguration().requestedUriDiscoveryEnabled() && (trustedProxies = this.bareRequest.socketConfiguration().trustedProxies()).test(Request.hostPart(this.remoteAddress()))) {
            block4: for (SocketConfiguration.RequestedUriDiscoveryType type : this.bareRequest.socketConfiguration().requestedUriDiscoveryTypes()) {
                switch (type) {
                    case FORWARDED: {
                        ForwardedDiscovery fDiscovery = this.discoverUsingForwarded(this.headers(), trustedProxies);
                        if (fDiscovery == null) continue block4;
                        authority = fDiscovery.authority();
                        scheme = fDiscovery.scheme();
                        break;
                    }
                    case X_FORWARDED: {
                        XForwardedDiscovery xfDiscovery = this.discoverUsingXForwarded(headers, trustedProxies);
                        if (xfDiscovery == null) continue block4;
                        scheme = xfDiscovery.scheme();
                        host = xfDiscovery.host();
                        port = xfDiscovery.port();
                        path = xfDiscovery.path();
                        break;
                    }
                    default: {
                        authority = headers.first("Host").orElse(null);
                        break;
                    }
                }
                break;
            }
        }
        if (host == null && authority == null) {
            authority = headers.first("Host").orElse(null);
        }
        if (path == null) {
            path = this.path().absolute().toString();
        }
        if (host == null && authority != null) {
            Authority a = scheme == null ? Authority.create(authority) : Authority.create(scheme, authority);
            if (a.host() != null) {
                host = a.host();
            }
            if (port == -1) {
                port = a.port();
            }
        }
        if (scheme == null) {
            if (port == 80) {
                scheme = "http";
            } else if (port == 443) {
                scheme = "https";
            } else {
                String string = scheme = this.isSecure() ? "https" : "http";
            }
        }
        if (host == null) {
            host = this.localAddress();
        }
        if (port == -1) {
            port = "https".equals(scheme) ? 443 : 80;
        }
        if (query == null || query.isEmpty()) {
            query = null;
        }
        return new UriInfo(scheme, host, port, path, Optional.ofNullable(query));
    }

    private ForwardedDiscovery discoverUsingForwarded(RequestHeaders headers, AllowList trustedProxies) {
        String scheme = null;
        String authority = null;
        List forwardedList = Forwarded.create((Headers)headers);
        if (!forwardedList.isEmpty()) {
            for (int i = forwardedList.size() - 1; i >= 0; --i) {
                Forwarded f = (Forwarded)forwardedList.get(i);
                if (scheme == null && f.proto().isPresent()) {
                    scheme = (String)f.proto().get();
                }
                if (authority == null && f.host().isPresent()) {
                    authority = (String)f.host().get();
                }
                if (f.forClient().isPresent() && !trustedProxies.test((String)f.forClient().get()) || scheme != null && authority != null) break;
            }
        }
        return authority != null ? new ForwardedDiscovery(authority, scheme) : null;
    }

    private XForwardedDiscovery discoverUsingXForwarded(RequestHeaders headers, AllowList trustedProxies) {
        boolean discovered = false;
        String scheme = null;
        String host = null;
        int port = -1;
        String path = null;
        List xForwardedFors = headers.all("X-Forwarded-For");
        boolean areProxiesTrusted = true;
        if (xForwardedFors.size() > 0) {
            for (int i = 1; i < xForwardedFors.size(); ++i) {
                areProxiesTrusted &= trustedProxies.test((String)xForwardedFors.get(i));
            }
        }
        if (areProxiesTrusted) {
            scheme = headers.first("X-Forwarded-Proto").orElse(null);
            host = headers.first("X-Forwarded-Host").orElse(null);
            port = headers.first("X-Forwarded-Port").map(Integer::parseInt).orElse(-1);
            path = headers.first("X-Forwarded-Prefix").map(prefix -> {
                String absolute = this.path().absolute().toString();
                return prefix + (absolute.startsWith("/") ? "" : "/") + absolute;
            }).orElse(null);
            discovered = scheme != null || host != null || port != -1 || path != null;
        }
        return discovered ? new XForwardedDiscovery(scheme, host, port, path) : null;
    }

    private static String hostPart(String address) {
        int colon = address.indexOf(58);
        return colon == -1 ? address : address.substring(0, colon);
    }

    static class Path
    implements HttpRequest.Path {
        private final String path;
        private final String rawPath;
        private final Map<String, String> params;
        private final Path absolutePath;
        private List<String> segments;

        Path(String path, String rawPath, Map<String, String> params, Path absolutePath) {
            this.path = path;
            this.rawPath = rawPath;
            this.params = params == null ? Collections.emptyMap() : params;
            this.absolutePath = absolutePath;
        }

        public String param(String name) {
            return this.params.get(name);
        }

        public List<String> segments() {
            List<String> result = this.segments;
            if (result == null) {
                StringTokenizer stok = new StringTokenizer(this.path, "/");
                result = new ArrayList<String>();
                while (stok.hasMoreTokens()) {
                    result.add(stok.nextToken());
                }
                this.segments = result;
            }
            return result;
        }

        public String toString() {
            return this.path;
        }

        public String toRawString() {
            return this.rawPath;
        }

        public Path absolute() {
            return this.absolutePath == null ? this : this.absolutePath;
        }

        static Path create(Path contextual, String path, Map<String, String> params) {
            return Path.create(contextual, path, path, params);
        }

        static Path create(Path contextual, String path, String rawPath, Map<String, String> params) {
            if (contextual == null) {
                return new Path(path, rawPath, params, null);
            }
            return contextual.createSubpath(path, rawPath, params);
        }

        Path createSubpath(String path, String rawPath, Map<String, String> params) {
            if (params == null) {
                params = Collections.emptyMap();
            }
            if (this.absolutePath == null) {
                HashMap<String, String> map = new HashMap<String, String>(this.params.size() + params.size());
                map.putAll(this.params);
                map.putAll(params);
                return new Path(path, rawPath, params, new Path(this.path, this.rawPath, map, null));
            }
            int size = this.params.size() + params.size() + this.absolutePath.params.size();
            HashMap<String, String> map = new HashMap<String, String>(size);
            map.putAll(this.absolutePath.params);
            map.putAll(this.params);
            map.putAll(params);
            return new Path(path, rawPath, params, new Path(this.absolutePath.path, this.absolutePath.rawPath, map, null));
        }
    }

    private final class MessageBodyEventListener
    implements MessageBodyContext.EventListener {
        private Span readSpan;

        private MessageBodyEventListener() {
        }

        private Span createReadSpan(GenericType<?> type) {
            Optional<SpanContext> parentSpan = Request.this.spanContext();
            if (parentSpan.isEmpty()) {
                return null;
            }
            SpanTracingConfig spanConfig = TracingConfigUtil.spanConfig((String)"web-server", (String)Request.TRACING_CONTENT_READ_NAME, (Context)Request.this.context());
            String spanName = spanConfig.newName().orElse(Request.TRACING_CONTENT_READ_NAME);
            if (spanConfig.enabled()) {
                Tracer.SpanBuilder spanBuilder = Request.this.tracer().buildSpan(spanName);
                spanBuilder.asChildOf(parentSpan.get());
                if (type != null) {
                    spanBuilder.withTag("requested.type", type.getTypeName());
                }
                return spanBuilder.start();
            }
            return null;
        }

        public void onEvent(MessageBodyContext.Event event) {
            switch (event.eventType()) {
                case BEFORE_ONSUBSCRIBE: {
                    GenericType type = event.entityType().orElse(null);
                    this.readSpan = this.createReadSpan(type);
                    break;
                }
                case AFTER_ONERROR: {
                    if (this.readSpan == null) break;
                    Tags.ERROR.set(this.readSpan, Boolean.TRUE);
                    Throwable ex = event.asErrorEvent().error();
                    this.readSpan.log(Map.of("event", "error", "error.kind", "Exception", "error.object", ex, "message", ex.toString()));
                    this.readSpan.finish();
                    break;
                }
                case AFTER_ONCOMPLETE: {
                    if (this.readSpan == null) break;
                    this.readSpan.finish();
                    break;
                }
            }
        }
    }

    private static class XForwardedDiscovery {
        private final String scheme;
        private final String host;
        private final int port;
        private final String path;

        private XForwardedDiscovery(String scheme, String host, int port, String path) {
            this.scheme = scheme;
            this.host = host;
            this.port = port;
            this.path = path;
        }

        private String scheme() {
            return this.scheme;
        }

        private String host() {
            return this.host;
        }

        private int port() {
            return this.port;
        }

        private String path() {
            return this.path;
        }
    }

    private static class ForwardedDiscovery {
        private final String authority;
        private final String scheme;

        private ForwardedDiscovery(String authority, String scheme) {
            this.authority = authority;
            this.scheme = scheme;
        }

        private String authority() {
            return this.authority;
        }

        private String scheme() {
            return this.scheme;
        }
    }

    private static class Authority {
        private final String host;
        private final int port;

        static Authority create(String hostHeader) {
            int colon = hostHeader.indexOf(58);
            if (colon == -1) {
                return new Authority(hostHeader, -1);
            }
            String hostString = hostHeader.substring(0, colon);
            String portString = hostHeader.substring(colon + 1);
            return new Authority(hostString, Integer.parseInt(portString));
        }

        static Authority create(String scheme, String hostHeader) {
            int colon = hostHeader.indexOf(58);
            if (colon == -1) {
                return new Authority(hostHeader, "https".equals(scheme) ? 443 : 80);
            }
            String hostString = hostHeader.substring(0, colon);
            String portString = hostHeader.substring(colon + 1);
            return new Authority(hostString, Integer.parseInt(portString));
        }

        private Authority(String host, int port) {
            this.host = host;
            this.port = port;
        }

        private String host() {
            return this.host;
        }

        private int port() {
            return this.port;
        }
    }
}

