/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.configurable.AllowList;
import io.helidon.common.context.Context;
import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.media.common.MediaContext;
import io.helidon.media.common.MediaContextBuilder;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyStreamReader;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.common.ParentingMediaContextBuilder;
import io.helidon.webserver.BackpressureStrategy;
import io.helidon.webserver.DirectHandler;
import io.helidon.webserver.DirectHandlers;
import io.helidon.webserver.ExperimentalConfiguration;
import io.helidon.webserver.NettyWebServer;
import io.helidon.webserver.RequestRouting;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.SocketConfiguration;
import io.helidon.webserver.Transport;
import io.helidon.webserver.WebServerTls;
import io.opentracing.Tracer;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public interface WebServer {
    public static final String DEFAULT_SOCKET_NAME = "@default";

    public ServerConfiguration configuration();

    public Single<WebServer> start();

    public Single<WebServer> whenShutdown();

    public Single<WebServer> shutdown();

    public boolean isRunning();

    public Context context();

    public MessageBodyReaderContext readerContext();

    public MessageBodyWriterContext writerContext();

    default public int port() {
        return this.port(DEFAULT_SOCKET_NAME);
    }

    public int port(String var1);

    default public boolean hasTls() {
        return this.hasTls(DEFAULT_SOCKET_NAME);
    }

    public boolean hasTls(String var1);

    public void updateTls(WebServerTls var1);

    public void updateTls(WebServerTls var1, String var2);

    @Deprecated
    public static WebServer create(Supplier<? extends ServerConfiguration> configurationBuilder, Routing routing) {
        return WebServer.create(configurationBuilder != null ? configurationBuilder.get() : null, routing);
    }

    @Deprecated
    public static WebServer create(Supplier<? extends ServerConfiguration> configurationBuilder, Supplier<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.create(configurationBuilder != null ? configurationBuilder.get() : null, routingBuilder.get());
    }

    @Deprecated
    public static WebServer create(ServerConfiguration configuration, Supplier<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.create(configuration, routingBuilder.get());
    }

    public static WebServer create(Routing routing) {
        return WebServer.builder(routing).build();
    }

    @Deprecated
    public static WebServer create(ServerConfiguration configuration, Routing routing) {
        Objects.requireNonNull(routing, "Parameter 'routing' is null!");
        return WebServer.builder(routing).config(configuration).build();
    }

    public static WebServer create(Routing routing, Config config) {
        return WebServer.builder(routing).config(config).build();
    }

    public static WebServer create(Supplier<Routing> routingBuilder, Config config) {
        return WebServer.builder(routingBuilder.get()).config(config).build();
    }

    public static WebServer create(Supplier<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.create(routingBuilder.get());
    }

    public static Builder builder(Supplier<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.builder(routingBuilder.get());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Routing routing) {
        return WebServer.builder().routing(routing);
    }

    @Configured(root=true, prefix="server", description="Configuration of the HTTP server.")
    public static final class Builder
    implements io.helidon.common.Builder<WebServer>,
    SocketConfiguration.SocketConfigurationBuilder<Builder>,
    ParentingMediaContextBuilder<Builder>,
    MediaContextBuilder<Builder> {
        private static final Logger LOGGER = Logger.getLogger(Builder.class.getName());
        private static final MediaContext DEFAULT_MEDIA_SUPPORT = MediaContext.create();
        private final Map<String, Routing> routings = new HashMap<String, Routing>();
        private Routing defaultRouting;
        private final ServerConfiguration.Builder configurationBuilder = ServerConfiguration.builder();
        private ServerConfiguration explicitConfig;
        private Transport transport;
        private MessageBodyReaderContext readerContext;
        private MessageBodyWriterContext writerContext;
        private DirectHandlers.Builder directHandlers = DirectHandlers.builder();

        private Builder() {
            this.readerContext = MessageBodyReaderContext.create((MessageBodyReaderContext)DEFAULT_MEDIA_SUPPORT.readerContext());
            this.writerContext = MessageBodyWriterContext.create((MessageBodyWriterContext)DEFAULT_MEDIA_SUPPORT.writerContext());
        }

        public WebServer build() {
            String unpairedRoutings;
            if (this.defaultRouting == null) {
                LOGGER.warning("Creating a web server with no default routing configured.");
                this.defaultRouting = Routing.builder().build();
            }
            if (this.explicitConfig == null) {
                this.explicitConfig = this.configurationBuilder.build();
            }
            if (!(unpairedRoutings = this.routings.keySet().stream().filter(routingName -> this.explicitConfig.namedSocket((String)routingName).isEmpty()).collect(Collectors.joining(", "))).isEmpty()) {
                throw new IllegalStateException("No server socket configuration found for named routings: " + unpairedRoutings);
            }
            NettyWebServer result = new NettyWebServer(this.explicitConfig, this.defaultRouting, this.routings, this.writerContext, this.readerContext, this.directHandlers.build());
            if (this.defaultRouting instanceof RequestRouting) {
                ((RequestRouting)this.defaultRouting).fireNewWebServer(result);
            }
            return result;
        }

        public Builder defaultSocket(Consumer<SocketConfiguration.Builder> socket) {
            socket.accept(this.configurationBuilder.defaultSocketBuilder());
            return this;
        }

        public Builder transport(Transport transport) {
            this.configurationBuilder.transport(transport);
            return this;
        }

        public Builder routing(Routing defaultRouting) {
            this.defaultRouting = Objects.requireNonNull(defaultRouting);
            return this;
        }

        public Builder routing(Supplier<Routing> defaultRouting) {
            this.defaultRouting = Objects.requireNonNull(defaultRouting).get();
            return this;
        }

        @Deprecated
        public Builder config(ServerConfiguration configuration) {
            this.explicitConfig = configuration;
            return this;
        }

        @Deprecated
        public Builder config(Supplier<ServerConfiguration> configurationBuilder) {
            return this.config(configurationBuilder.get());
        }

        @Override
        public Builder config(Config config) {
            this.configurationBuilder.config(config);
            return this;
        }

        public Builder addNamedRouting(String name, Routing routing) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            Objects.requireNonNull(routing, "Parameter 'routing' must not be null!");
            this.routings.put(name, routing);
            return this;
        }

        public Builder addNamedRouting(String name, Supplier<Routing> routingBuilder) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
            return this.addNamedRouting(name, routingBuilder.get());
        }

        public Builder mediaContext(MediaContext mediaContext) {
            Objects.requireNonNull(mediaContext);
            this.readerContext = MessageBodyReaderContext.create((MessageBodyReaderContext)mediaContext.readerContext());
            this.writerContext = MessageBodyWriterContext.create((MessageBodyWriterContext)mediaContext.writerContext());
            return this;
        }

        public Builder addMediaSupport(MediaSupport mediaSupport) {
            Objects.requireNonNull(mediaSupport);
            mediaSupport.register(this.readerContext, this.writerContext);
            return this;
        }

        public Builder addReader(MessageBodyReader<?> reader) {
            this.readerContext.registerReader(reader);
            return this;
        }

        public Builder addStreamReader(MessageBodyStreamReader<?> streamReader) {
            this.readerContext.registerReader(streamReader);
            return this;
        }

        public Builder addWriter(MessageBodyWriter<?> writer) {
            this.writerContext.registerWriter(writer);
            return this;
        }

        public Builder addStreamWriter(MessageBodyStreamWriter<?> streamWriter) {
            this.writerContext.registerWriter(streamWriter);
            return this;
        }

        @Override
        public Builder port(int port) {
            this.configurationBuilder.port(port);
            return this;
        }

        @Override
        public Builder bindAddress(InetAddress bindAddress) {
            this.configurationBuilder.bindAddress(bindAddress);
            return this;
        }

        @Override
        public Builder backlog(int backlog) {
            this.configurationBuilder.backlog(backlog);
            return this;
        }

        @Override
        public Builder timeout(long amount, TimeUnit unit) {
            this.configurationBuilder.timeout(amount, unit);
            return this;
        }

        @Override
        public Builder receiveBufferSize(int receiveBufferSize) {
            this.configurationBuilder.receiveBufferSize(receiveBufferSize);
            return this;
        }

        @Override
        public Builder tls(WebServerTls webServerTls) {
            this.configurationBuilder.tls(webServerTls);
            return this;
        }

        @Override
        public Builder maxHeaderSize(int size) {
            this.configurationBuilder.maxHeaderSize(size);
            return this;
        }

        @Override
        public Builder maxInitialLineLength(int length) {
            this.configurationBuilder.maxInitialLineLength(length);
            return this;
        }

        @Override
        public Builder enableCompression(boolean value) {
            this.configurationBuilder.enableCompression(value);
            return this;
        }

        @Override
        public Builder maxPayloadSize(long size) {
            this.configurationBuilder.maxPayloadSize(size);
            return this;
        }

        @Override
        public Builder backpressureBufferSize(long backpressureBufferSize) {
            this.configurationBuilder.backpressureBufferSize(backpressureBufferSize);
            return this;
        }

        @Override
        public Builder backpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.configurationBuilder.backpressureStrategy(backpressureStrategy);
            return this;
        }

        @Override
        public Builder addRequestedUriDiscoveryType(SocketConfiguration.RequestedUriDiscoveryType type) {
            this.defaultSocket(it -> it.addRequestedUriDiscoveryType(type));
            return this;
        }

        @Override
        public Builder requestedUriDiscoveryTypes(List<SocketConfiguration.RequestedUriDiscoveryType> types) {
            this.defaultSocket(it -> it.requestedUriDiscoveryTypes((List)types));
            return this;
        }

        @Override
        public Builder requestedUriDiscoveryEnabled(boolean enabled) {
            this.defaultSocket(it -> it.requestedUriDiscoveryEnabled(enabled));
            return this;
        }

        @Override
        public Builder trustedProxies(AllowList trustedProxies) {
            this.defaultSocket(it -> it.trustedProxies(trustedProxies));
            return this;
        }

        public Builder experimental(ExperimentalConfiguration experimental) {
            this.configurationBuilder.experimental(experimental);
            return this;
        }

        public Builder update(Consumer<Builder> updateFunction) {
            updateFunction.accept(this);
            return this;
        }

        @Deprecated
        public Builder addSocket(String name, SocketConfiguration socketConfiguration) {
            this.configurationBuilder.addSocket(name, Objects.requireNonNull(socketConfiguration));
            return this;
        }

        public Builder addSocket(SocketConfiguration config) {
            this.configurationBuilder.addSocket(config.name(), config);
            return this;
        }

        @Deprecated
        public Builder addSocket(String name, Supplier<SocketConfiguration> socketConfigurationBuilder) {
            this.configurationBuilder.addSocket(name, socketConfigurationBuilder);
            return this;
        }

        public Builder addSocket(Supplier<SocketConfiguration> socketConfigurationBuilder) {
            SocketConfiguration socketConfiguration = socketConfigurationBuilder.get();
            this.configurationBuilder.addSocket(socketConfiguration.name(), socketConfiguration);
            return this;
        }

        public Builder addSocket(SocketConfiguration socketConfiguration, Routing routing) {
            this.addSocket(socketConfiguration);
            this.addNamedRouting(socketConfiguration.name(), routing);
            return this;
        }

        public Builder tracer(Tracer tracer) {
            this.configurationBuilder.tracer(tracer);
            return this;
        }

        public Builder tracer(Supplier<? extends Tracer> tracerBuilder) {
            this.configurationBuilder.tracer(tracerBuilder);
            return this;
        }

        public boolean hasSocket(String socketName) {
            return WebServer.DEFAULT_SOCKET_NAME.equals(socketName) || this.configurationBuilder.sockets().containsKey(socketName);
        }

        public Builder context(Context context) {
            this.configurationBuilder.context(context);
            return this;
        }

        public Builder workersCount(int workers) {
            this.configurationBuilder.workersCount(workers);
            return this;
        }

        public Builder printFeatureDetails(boolean shouldPrint) {
            this.configurationBuilder.printFeatureDetails(shouldPrint);
            return this;
        }

        public Builder directHandler(DirectHandler handler, DirectHandler.EventType ... types) {
            for (DirectHandler.EventType type : types) {
                this.directHandlers.addHandler(type, handler);
            }
            return this;
        }
    }
}

