/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.configurable.AllowList;
import io.helidon.common.context.Context;
import io.helidon.webserver.BackpressureStrategy;
import io.helidon.webserver.ClientAuthentication;
import io.helidon.webserver.ExperimentalConfiguration;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.SocketConfiguration;
import io.helidon.webserver.Transport;
import io.helidon.webserver.WebServerTls;
import io.opentracing.Tracer;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.SSLContext;

class ServerBasicConfig
implements ServerConfiguration {
    private final SocketConfiguration socketConfig;
    private final int workers;
    private final Tracer tracer;
    private final Map<String, SocketConfiguration> socketConfigs;
    private final Duration maxShutdownTimeout;
    private final Duration shutdownQuietPeriod;
    private final ExperimentalConfiguration experimental;
    private final Optional<Transport> transport;
    private final Context context;
    private final boolean printFeatureDetails;
    private final AllowList trustedProxies;
    private final boolean isRequestedUriDiscoveryEnabled;

    ServerBasicConfig(ServerConfiguration.Builder builder) {
        this.socketConfig = builder.defaultSocketBuilder().build();
        this.workers = builder.workers();
        this.tracer = builder.tracer();
        this.maxShutdownTimeout = builder.maxShutdownTimeout();
        this.shutdownQuietPeriod = builder.shutdownQuietPeriod();
        this.experimental = builder.experimental();
        this.transport = builder.transport();
        this.context = builder.context();
        this.printFeatureDetails = builder.printFeatureDetails();
        this.trustedProxies = builder.defaultSocketBuilder().trustedProxies();
        this.isRequestedUriDiscoveryEnabled = builder.defaultSocketBuilder().requestedUriDiscoveryEnabled();
        HashMap<String, SocketConfiguration> map = new HashMap<String, SocketConfiguration>(builder.sockets());
        map.put("@default", this.socketConfig);
        this.socketConfigs = Collections.unmodifiableMap(map);
    }

    @Override
    public SSLContext ssl() {
        return this.socketConfig.ssl();
    }

    @Override
    public Set<String> enabledSslProtocols() {
        return this.socketConfig.enabledSslProtocols();
    }

    @Override
    public Set<String> allowedCipherSuite() {
        return this.socketConfig.allowedCipherSuite();
    }

    @Override
    public ClientAuthentication clientAuth() {
        return this.socketConfig.clientAuth();
    }

    @Override
    public int workersCount() {
        return this.workers;
    }

    @Override
    public int port() {
        return this.socketConfig.port();
    }

    @Override
    public InetAddress bindAddress() {
        return this.socketConfig.bindAddress();
    }

    @Override
    public int backlog() {
        return this.socketConfig.backlog();
    }

    @Override
    public int timeoutMillis() {
        return this.socketConfig.timeoutMillis();
    }

    @Override
    public int receiveBufferSize() {
        return this.socketConfig.receiveBufferSize();
    }

    @Override
    public Optional<WebServerTls> tls() {
        return this.socketConfig.tls();
    }

    @Override
    public int maxHeaderSize() {
        return this.socketConfig.maxHeaderSize();
    }

    @Override
    public int maxInitialLineLength() {
        return this.socketConfig.maxInitialLineLength();
    }

    @Override
    public int maxChunkSize() {
        return this.socketConfig.maxChunkSize();
    }

    @Override
    public boolean validateHeaders() {
        return this.socketConfig.validateHeaders();
    }

    @Override
    public int initialBufferSize() {
        return this.socketConfig.initialBufferSize();
    }

    @Override
    public Duration maxShutdownTimeout() {
        return this.maxShutdownTimeout;
    }

    @Override
    public Duration shutdownQuietPeriod() {
        return this.shutdownQuietPeriod;
    }

    @Override
    public Tracer tracer() {
        return this.tracer;
    }

    @Override
    public Map<String, SocketConfiguration> sockets() {
        return this.socketConfigs;
    }

    @Override
    public ExperimentalConfiguration experimental() {
        return this.experimental;
    }

    @Override
    public Optional<Transport> transport() {
        return this.transport;
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public boolean printFeatureDetails() {
        return this.printFeatureDetails;
    }

    @Override
    public boolean enableCompression() {
        return this.socketConfig.enableCompression();
    }

    @Override
    public List<SocketConfiguration.RequestedUriDiscoveryType> requestedUriDiscoveryTypes() {
        return this.socketConfig.requestedUriDiscoveryTypes();
    }

    @Override
    public AllowList trustedProxies() {
        return this.trustedProxies;
    }

    @Override
    public boolean requestedUriDiscoveryEnabled() {
        return this.isRequestedUriDiscoveryEnabled;
    }

    static class SocketConfig
    implements SocketConfiguration {
        private final int port;
        private final InetAddress bindAddress;
        private final int backlog;
        private final int timeoutMillis;
        private final int receiveBufferSize;
        private final WebServerTls webServerTls;
        private final String name;
        private final boolean enabled;
        private final int maxHeaderSize;
        private final int maxInitialLineLength;
        private final int maxChunkSize;
        private final boolean validateHeaders;
        private final int initialBufferSize;
        private final boolean enableCompression;
        private final long maxPayloadSize;
        private final long backpressureBufferSize;
        private final BackpressureStrategy backpressureStrategy;
        private final List<SocketConfiguration.RequestedUriDiscoveryType> requestedUriDiscoveryTypes;
        private final AllowList trustedProxies;
        private final boolean isRequestedUriDiscoveryEnabled;

        SocketConfig(SocketConfiguration.Builder builder) {
            this.name = builder.name();
            this.enabled = builder.enabled();
            this.port = Math.max(builder.port(), 0);
            this.bindAddress = builder.bindAddress().orElse(null);
            this.backlog = builder.backlog() < 0 ? 1024 : builder.backlog();
            this.timeoutMillis = Math.max(builder.timeoutMillis(), 0);
            this.receiveBufferSize = Math.max(builder.receiveBufferSize(), 0);
            this.maxHeaderSize = builder.maxHeaderSize();
            this.maxInitialLineLength = builder.maxInitialLineLength();
            this.maxChunkSize = builder.maxChunkSize();
            this.validateHeaders = builder.validateHeaders();
            this.initialBufferSize = builder.initialBufferSize();
            this.enableCompression = builder.enableCompression();
            this.maxPayloadSize = builder.maxPayloadSize();
            this.backpressureBufferSize = builder.backpressureBufferSize();
            this.backpressureStrategy = builder.backpressureStrategy();
            WebServerTls webServerTls = builder.tlsConfig();
            this.webServerTls = webServerTls.enabled() ? webServerTls : null;
            this.requestedUriDiscoveryTypes = builder.requestedUriDiscoveryTypes();
            this.trustedProxies = builder.trustedProxies();
            this.isRequestedUriDiscoveryEnabled = builder.requestedUriDiscoveryEnabled();
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public InetAddress bindAddress() {
            return this.bindAddress;
        }

        @Override
        public int backlog() {
            return this.backlog;
        }

        @Override
        public int timeoutMillis() {
            return this.timeoutMillis;
        }

        @Override
        public int receiveBufferSize() {
            return this.receiveBufferSize;
        }

        @Override
        public Optional<WebServerTls> tls() {
            return Optional.ofNullable(this.webServerTls);
        }

        @Override
        public SSLContext ssl() {
            return this.tls().map(WebServerTls::sslContext).orElse(null);
        }

        @Override
        public Set<String> enabledSslProtocols() {
            return this.tls().map(WebServerTls::enabledTlsProtocols).map(Set::copyOf).orElseGet(Set::of);
        }

        @Override
        public Set<String> allowedCipherSuite() {
            return this.tls().map(WebServerTls::cipherSuite).orElseGet(Set::of);
        }

        @Override
        public ClientAuthentication clientAuth() {
            return this.tls().map(WebServerTls::clientAuth).orElse(ClientAuthentication.NONE);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean enabled() {
            return this.enabled;
        }

        @Override
        public int maxHeaderSize() {
            return this.maxHeaderSize;
        }

        @Override
        public int maxInitialLineLength() {
            return this.maxInitialLineLength;
        }

        @Override
        public int maxChunkSize() {
            return this.maxChunkSize;
        }

        @Override
        public boolean validateHeaders() {
            return this.validateHeaders;
        }

        @Override
        public int initialBufferSize() {
            return this.initialBufferSize;
        }

        @Override
        public boolean enableCompression() {
            return this.enableCompression;
        }

        @Override
        public long maxPayloadSize() {
            return this.maxPayloadSize;
        }

        @Override
        public long backpressureBufferSize() {
            return this.backpressureBufferSize;
        }

        @Override
        public BackpressureStrategy backpressureStrategy() {
            return this.backpressureStrategy;
        }

        @Override
        public List<SocketConfiguration.RequestedUriDiscoveryType> requestedUriDiscoveryTypes() {
            return this.requestedUriDiscoveryTypes;
        }

        @Override
        public AllowList trustedProxies() {
            return this.trustedProxies;
        }

        @Override
        public boolean requestedUriDiscoveryEnabled() {
            return this.isRequestedUriDiscoveryEnabled;
        }
    }
}

