/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.LazyValue;
import io.helidon.common.pki.KeyConfig;
import io.helidon.config.Config;
import io.helidon.config.DeprecatedConfig;
import io.helidon.config.metadata.Configured;
import io.helidon.webserver.ClientAuthentication;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;

public final class WebServerTls {
    private static final String PROTOCOL = "TLS";
    private static final LazyValue<Random> RANDOM = LazyValue.create(SecureRandom::new);
    private final Set<String> enabledTlsProtocols;
    private final Set<String> cipherSuite;
    private final SSLContext sslContext;
    private final boolean enabled;
    private final ClientAuthentication clientAuth;

    private WebServerTls(Builder builder) {
        this.enabledTlsProtocols = Set.copyOf(builder.enabledTlsProtocols);
        this.cipherSuite = builder.cipherSuite;
        this.sslContext = builder.sslContext;
        this.enabled = null != this.sslContext;
        this.clientAuth = builder.clientAuth;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WebServerTls create(Config config) {
        return WebServerTls.builder().config(config).build();
    }

    Collection<String> enabledTlsProtocols() {
        return this.enabledTlsProtocols;
    }

    SSLContext sslContext() {
        return this.sslContext;
    }

    ClientAuthentication clientAuth() {
        return this.clientAuth;
    }

    Set<String> cipherSuite() {
        return this.cipherSuite;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Configured
    public static class Builder
    implements io.helidon.common.Builder<WebServerTls> {
        private final Set<String> enabledTlsProtocols = new HashSet<String>();
        private SSLContext sslContext;
        private KeyConfig privateKeyConfig;
        private KeyConfig trustConfig;
        private long sessionCacheSize;
        private long sessionTimeoutSeconds;
        private boolean enabled;
        private Boolean explicitEnabled;
        private ClientAuthentication clientAuth;
        private Set<String> cipherSuite = Set.of();

        private Builder() {
            this.clientAuth = ClientAuthentication.NONE;
        }

        public WebServerTls build() {
            boolean enabled = null == this.explicitEnabled ? this.enabled : this.explicitEnabled;
            if (!enabled) {
                this.sslContext = null;
                return new WebServerTls(this);
            }
            if (null == this.sslContext) {
                this.sslContext = this.newSSLContext();
            }
            return new WebServerTls(this);
        }

        public Builder config(Config config) {
            config.get("client-auth").asString().ifPresent(this::clientAuth);
            config.get("private-key").ifExists(it -> this.privateKey(KeyConfig.create((Config)it)));
            config.get("trust").ifExists(it -> this.trust(KeyConfig.create((Config)it)));
            config.get("protocols").asList(String.class).ifPresent(this::enabledProtocols);
            config.get("session-cache-size").asLong().ifPresent(this::sessionCacheSize);
            config.get("cipher-suite").asList(String.class).ifPresent(this::allowedCipherSuite);
            DeprecatedConfig.get((Config)config, (String)"session-timeout-seconds", (String)"session-timeout").asLong().ifPresent(this::sessionTimeoutSeconds);
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            return this;
        }

        private void clientAuth(String it) {
            this.clientAuth(ClientAuthentication.valueOf(it.toUpperCase()));
        }

        public Builder clientAuth(ClientAuthentication clientAuth) {
            this.clientAuth = Objects.requireNonNull(clientAuth);
            return this;
        }

        public Builder sslContext(SSLContext context) {
            this.enabled = true;
            this.sslContext = context;
            return this;
        }

        public Builder enabledProtocols(String ... protocols) {
            return this.enabledProtocols(Arrays.asList(Objects.requireNonNull(protocols)));
        }

        public Builder enabledProtocols(Collection<String> protocols) {
            Objects.requireNonNull(protocols);
            this.enabledTlsProtocols.clear();
            this.enabledTlsProtocols.addAll(protocols);
            return this;
        }

        public Builder privateKey(KeyConfig privateKeyConfig) {
            this.enabled = true;
            this.sslContext = null;
            this.privateKeyConfig = Objects.requireNonNull(privateKeyConfig);
            return this;
        }

        public Builder privateKey(Supplier<KeyConfig> privateKeyConfigBuilder) {
            return this.privateKey(privateKeyConfigBuilder.get());
        }

        public Builder trust(KeyConfig trustConfig) {
            this.enabled = true;
            this.sslContext = null;
            this.trustConfig = Objects.requireNonNull(trustConfig);
            return this;
        }

        public Builder trust(Supplier<KeyConfig> trustConfigBuilder) {
            return this.trust(trustConfigBuilder.get());
        }

        public Builder sessionCacheSize(long sessionCacheSize) {
            this.sessionCacheSize = sessionCacheSize;
            return this;
        }

        public Builder sessionTimeoutSeconds(long sessionTimeout) {
            this.sessionTimeoutSeconds = sessionTimeout;
            return this;
        }

        public Builder sessionTimeout(long timeout, TimeUnit unit) {
            this.sessionTimeoutSeconds = unit.toSeconds(timeout);
            return this;
        }

        public Builder allowedCipherSuite(List<String> cipherSuite) {
            Objects.requireNonNull(cipherSuite);
            if (cipherSuite.isEmpty()) {
                throw new IllegalStateException("Allowed cipher suite has to have at least one cipher specified");
            }
            this.cipherSuite = Set.copyOf(cipherSuite);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.explicitEnabled = enabled;
            return this;
        }

        private SSLContext newSSLContext() {
            try {
                if (null == this.privateKeyConfig) {
                    throw new IllegalStateException("Private key must be configured when SSL is enabled.");
                }
                KeyManagerFactory kmf = Builder.buildKmf(this.privateKeyConfig);
                TrustManagerFactory tmf = Builder.buildTmf(this.trustConfig);
                SSLContext ctx = SSLContext.getInstance(WebServerTls.PROTOCOL);
                ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                SSLSessionContext sessCtx = ctx.getServerSessionContext();
                if (this.sessionCacheSize > 0L) {
                    sessCtx.setSessionCacheSize((int)Math.min(this.sessionCacheSize, Integer.MAX_VALUE));
                }
                if (this.sessionTimeoutSeconds > 0L) {
                    sessCtx.setSessionTimeout((int)Math.min(this.sessionTimeoutSeconds, Integer.MAX_VALUE));
                }
                return ctx;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalStateException("Failed to build server SSL Context!", e);
            }
        }

        private static KeyManagerFactory buildKmf(KeyConfig privateKeyConfig) throws IOException, GeneralSecurityException {
            String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (algorithm == null) {
                algorithm = "SunX509";
            }
            byte[] passwordBytes = new byte[64];
            ((Random)RANDOM.get()).nextBytes(passwordBytes);
            char[] password = Base64.getEncoder().encodeToString(passwordBytes).toCharArray();
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, null);
            ks.setKeyEntry("key", (Key)privateKeyConfig.privateKey().orElseThrow(() -> new RuntimeException("Private key not available")), password, privateKeyConfig.certChain().toArray(new Certificate[0]));
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, password);
            return kmf;
        }

        private static TrustManagerFactory buildTmf(KeyConfig trustConfig) throws IOException, GeneralSecurityException {
            List certs = trustConfig == null ? List.of() : trustConfig.certs();
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, null);
            int i = 1;
            for (X509Certificate cert : certs) {
                ks.setCertificateEntry(String.valueOf(i), cert);
                ++i;
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            return tmf;
        }
    }
}

