/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.BufferedEmittingPublisher;
import io.helidon.common.reactive.Multi;
import io.helidon.webserver.ByteBufRequestChunk;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.Flow;

class HttpRequestScopedPublisher
extends BufferedEmittingPublisher<DataChunk> {
    private final ByteBufRequestChunk.DataChunkHoldingQueue holdingQueue;

    HttpRequestScopedPublisher(ByteBufRequestChunk.DataChunkHoldingQueue holdingQueue) {
        this.holdingQueue = holdingQueue;
    }

    public int emit(ByteBuf data) {
        try {
            int n = super.emit((Object)new ByteBufRequestChunk(data, this.holdingQueue));
            return n;
        }
        finally {
            this.holdingQueue.release();
        }
    }

    public void clearAndRelease() {
        Multi.create((Flow.Publisher)((Object)this)).forEach(DataChunk::release).onTerminate(() -> super.clearBuffer(DataChunk::release));
    }

    public void complete() {
        try {
            super.complete();
        }
        finally {
            this.holdingQueue.release();
        }
    }

    public void fail(Throwable throwable) {
        try {
            super.fail(throwable);
        }
        finally {
            this.holdingQueue.release();
        }
    }
}

