/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.webserver.BadRequestException;
import io.helidon.webserver.BareRequestImpl;
import io.helidon.webserver.BareResponseImpl;
import io.helidon.webserver.ByteBufRequestChunk;
import io.helidon.webserver.HttpInitializer;
import io.helidon.webserver.HttpRequestScopedPublisher;
import io.helidon.webserver.NettyWebServer;
import io.helidon.webserver.ReferenceHoldingQueue;
import io.helidon.webserver.RequestContext;
import io.helidon.webserver.Routing;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.lang.ref.ReferenceQueue;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class ForwardingHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = Logger.getLogger(ForwardingHandler.class.getName());
    private static final AtomicLong REQUEST_ID_GENERATOR = new AtomicLong(0L);
    private final Routing routing;
    private final NettyWebServer webServer;
    private final SSLEngine sslEngine;
    private final ReferenceQueue<Object> queues;
    private final HttpRequestDecoder httpRequestDecoder;
    private final long maxPayloadSize;
    private RequestContext requestContext;
    private boolean isWebSocketUpgrade;
    private long actualPayloadSize;
    private boolean ignorePayload;
    private CompletableFuture<?> prevRequestFuture;
    private boolean lastContent;
    private final Runnable clearQueues;

    ForwardingHandler(Routing routing, NettyWebServer webServer, SSLEngine sslEngine, ReferenceQueue<Object> queues, Runnable clearQueues, HttpRequestDecoder httpRequestDecoder, long maxPayloadSize) {
        this.routing = routing;
        this.webServer = webServer;
        this.sslEngine = sslEngine;
        this.queues = queues;
        this.httpRequestDecoder = httpRequestDecoder;
        this.maxPayloadSize = maxPayloadSize;
        this.clearQueues = clearQueues;
    }

    private void reset() {
        this.lastContent = false;
        this.isWebSocketUpgrade = false;
        this.actualPayloadSize = 0L;
        this.ignorePayload = false;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
        if (this.requestContext == null) {
            if (this.lastContent) {
                ctx.channel().config().setAutoRead(true);
            }
            return;
        }
        if (this.requestContext.publisher().hasRequests()) {
            ctx.channel().read();
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        LOGGER.fine(() -> String.format("[Handler: %s, Channel: %s] Received object: %s", System.identityHashCode((Object)this), System.identityHashCode(ctx.channel()), msg.getClass()));
        if (msg instanceof HttpRequest) {
            String contentLength;
            BareRequestImpl bareRequest;
            this.clearQueues.run();
            ctx.channel().config().setAutoRead(false);
            this.reset();
            HttpRequest request = (HttpRequest)msg;
            try {
                ForwardingHandler.checkDecoderResult(request);
            }
            catch (Throwable e) {
                this.send400BadRequest(ctx, e.getMessage());
                return;
            }
            request.headers().remove("X-HELIDON-CN");
            Optional.ofNullable((String)ctx.channel().attr(HttpInitializer.CERTIFICATE_NAME).get()).ifPresent(name -> request.headers().set("X-HELIDON-CN", name));
            ByteBufRequestChunk.DataChunkHoldingQueue queue = new ByteBufRequestChunk.DataChunkHoldingQueue();
            RequestContext requestContextRef = this.requestContext = new RequestContext(new HttpRequestScopedPublisher(queue), request);
            HttpRequestScopedPublisher publisherRef = requestContextRef.publisher();
            ReferenceHoldingQueue.IndirectReference<Object, ByteBufRequestChunk.DataChunkHoldingQueue> publisherPh = new ReferenceHoldingQueue.IndirectReference<Object, ByteBufRequestChunk.DataChunkHoldingQueue>((Object)publisherRef, this.queues, queue);
            publisherRef.onRequest((n, demand) -> {
                if (publisherRef.isUnbounded()) {
                    LOGGER.finest("Netty autoread: true");
                    ctx.channel().config().setAutoRead(true);
                } else {
                    LOGGER.finest("Netty autoread: false");
                    ctx.channel().config().setAutoRead(false);
                }
                if (publisherRef.hasRequests()) {
                    LOGGER.finest("Requesting next chunks from Netty.");
                    ctx.channel().read();
                } else {
                    LOGGER.finest("No hook action required.");
                }
            });
            long requestId = REQUEST_ID_GENERATOR.incrementAndGet();
            try {
                bareRequest = new BareRequestImpl((HttpRequest)msg, (Flow.Publisher<DataChunk>)((Object)requestContextRef.publisher()), this.webServer, ctx, this.sslEngine, requestId);
            }
            catch (IllegalArgumentException e) {
                this.send400BadRequest(ctx, e.getMessage());
                return;
            }
            if (this.maxPayloadSize >= 0L && (contentLength = request.headers().get("Content-Length")) != null) {
                try {
                    long value = Long.parseLong(contentLength);
                    if (value > this.maxPayloadSize) {
                        LOGGER.fine(() -> String.format("[Handler: %s, Channel: %s] Payload length over max %d > %d", System.identityHashCode((Object)this), System.identityHashCode(ctx.channel()), value, this.maxPayloadSize));
                        this.ignorePayload = true;
                        this.send413PayloadTooLarge(ctx);
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    this.send400BadRequest(ctx, "Content-Length header is invalid");
                    return;
                }
            }
            if (this.prevRequestFuture != null && this.prevRequestFuture.isDone()) {
                this.prevRequestFuture = null;
            }
            BareResponseImpl bareResponse = new BareResponseImpl(ctx, request, () -> ((HttpRequestScopedPublisher)publisherRef).isCompleted(), this.prevRequestFuture, requestId);
            CompletableFuture<?> thisResp = this.prevRequestFuture = new CompletableFuture();
            bareResponse.whenCompleted().thenRun(() -> {
                requestContextRef.responseCompleted(true);
                publisherRef.clearAndRelease();
                if (queue.release()) {
                    publisherPh.acquire();
                }
                thisResp.complete(null);
            });
            if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
                ForwardingHandler.send100Continue(ctx);
            }
            try {
                this.routing.route(bareRequest, bareResponse);
            }
            catch (IllegalArgumentException e) {
                this.send400BadRequest(ctx, e.getMessage());
                return;
            }
            if (bareResponse.isWebSocketUpgrade()) {
                LOGGER.fine("Replacing HttpRequestDecoder by WebSocketServerProtocolHandler");
                ctx.pipeline().replace((ChannelHandler)this.httpRequestDecoder, "webSocketsHandler", (ChannelHandler)new WebSocketServerProtocolHandler(bareRequest.uri().getPath(), null, true));
                ForwardingHandler.removeHandshakeHandler(ctx);
                this.isWebSocketUpgrade = true;
                return;
            }
        }
        if (msg instanceof HttpContent) {
            if (this.requestContext == null) {
                throw new IllegalStateException("There is no request context associated with this http content. This is never expected to happen!");
            }
            this.lastContent = false;
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                HttpMethod method = this.requestContext.request().method();
                if (HttpMethod.TRACE.equals((Object)method)) {
                    LOGGER.finer(() -> "Closing connection because of an illegal payload; method: " + method);
                    throw new BadRequestException("It is illegal to send a payload with http method: " + method);
                }
                if (this.requestContext.responseCompleted() && !(msg instanceof LastHttpContent)) {
                    LOGGER.finer(() -> "Closing connection because request payload was not consumed; method: " + method);
                    ctx.close();
                } else if (!this.ignorePayload) {
                    if (this.maxPayloadSize >= 0L) {
                        this.actualPayloadSize += (long)content.readableBytes();
                        if (this.actualPayloadSize > this.maxPayloadSize) {
                            LOGGER.fine(() -> String.format("[Handler: %s, Channel: %s] Chunked Payload over max %d > %d", System.identityHashCode((Object)this), System.identityHashCode(ctx.channel()), this.actualPayloadSize, this.maxPayloadSize));
                            this.ignorePayload = true;
                            this.send413PayloadTooLarge(ctx);
                        } else {
                            this.requestContext.publisher().emit(content);
                        }
                    } else {
                        this.requestContext.publisher().emit(content);
                    }
                }
            }
            if (msg instanceof LastHttpContent) {
                if (!this.isWebSocketUpgrade) {
                    this.lastContent = true;
                    this.requestContext.publisher().complete();
                    this.requestContext = null;
                }
            } else if (!content.isReadable()) {
                throw new IllegalStateException("It is not expected to not have readable content.");
            }
        }
        if (msg instanceof ByteBuf) {
            if (!this.isWebSocketUpgrade) {
                throw new IllegalStateException("Received ByteBuf without upgrading to WebSockets");
            }
            LOGGER.finest(() -> "Received ByteBuf of WebSockets connection" + msg);
            this.requestContext.publisher().emit((ByteBuf)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.failPublisher(cause);
        ctx.close();
    }

    private static void checkDecoderResult(HttpRequest request) {
        DecoderResult decoderResult = request.decoderResult();
        if (decoderResult.isFailure()) {
            LOGGER.info(String.format("Request %s to %s rejected: %s", request.method().asciiName(), request.uri(), decoderResult.cause().getMessage()));
            throw new BadRequestException(String.format("Request was rejected: %s", decoderResult.cause().getMessage()), decoderResult.cause());
        }
    }

    private static void removeHandshakeHandler(ChannelHandlerContext ctx) {
        ChannelHandler handshakeHandler = null;
        Iterator it = ctx.pipeline().iterator();
        while (it.hasNext()) {
            ChannelHandler handler = (ChannelHandler)((Map.Entry)it.next()).getValue();
            if (!handler.getClass().getName().endsWith("WebSocketServerProtocolHandshakeHandler")) continue;
            handshakeHandler = handler;
            break;
        }
        if (handshakeHandler != null) {
            ctx.pipeline().remove(handshakeHandler);
        } else {
            LOGGER.warning("Unable to remove WebSockets handshake handler from pipeline");
        }
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.write((Object)response);
    }

    private void send400BadRequest(ChannelHandlerContext ctx, String message) {
        byte[] entity = message.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer((byte[])entity));
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)entity.length);
        response.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.write((Object)response).addListener(future -> {
            ctx.flush();
            ctx.close();
        });
        this.failPublisher(new Error("400: Bad request"));
    }

    private void send413PayloadTooLarge(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
        ctx.write((Object)response).addListener(future -> {
            ctx.flush();
            ctx.close();
        });
        this.failPublisher(new Error("413: Payload is too large"));
    }

    private void failPublisher(Throwable cause) {
        if (this.requestContext != null) {
            this.requestContext.publisher().fail(cause);
        }
    }
}

