/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.webserver.ClassPathContentHandler;
import io.helidon.webserver.ContentTypeSelector;
import io.helidon.webserver.FileSystemContentHandler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.Service;
import io.helidon.webserver.StaticContentHandler;
import io.helidon.webserver.WebServer;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;

public class StaticContentSupport
implements Service {
    private final StaticContentHandler handler;
    private int webServerCounter = 0;

    StaticContentSupport(StaticContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public void update(Routing.Rules routing) {
        routing.onNewWebServer(new Consumer<WebServer>(){

            @Override
            public void accept(WebServer ws) {
                StaticContentSupport.this.webServerStarted();
                ws.whenShutdown().thenRun(() -> StaticContentSupport.this.webServerStopped());
            }
        });
        routing.get((req, res) -> this.handler.handle((Http.RequestMethod)Http.Method.GET, req, res));
        routing.head((req, res) -> this.handler.handle((Http.RequestMethod)Http.Method.HEAD, req, res));
    }

    private synchronized void webServerStarted() {
        ++this.webServerCounter;
    }

    private synchronized void webServerStopped() {
        --this.webServerCounter;
        if (this.webServerCounter <= 0) {
            this.webServerCounter = 0;
            this.handler.releaseCache();
        }
    }

    public static Builder builder(String resourceRoot) {
        Objects.requireNonNull(resourceRoot, "Attribute resourceRoot is null!");
        return StaticContentSupport.builder(resourceRoot, Thread.currentThread().getContextClassLoader());
    }

    public static Builder builder(String resourceRoot, ClassLoader classLoader) {
        Objects.requireNonNull(resourceRoot, "Attribute resourceRoot is null!");
        return new Builder(resourceRoot, classLoader);
    }

    public static Builder builder(Path root) {
        Objects.requireNonNull(root, "Attribute root is null!");
        return new Builder(root);
    }

    public static StaticContentSupport create(String resourceRoot) {
        return StaticContentSupport.create(resourceRoot, Thread.currentThread().getContextClassLoader());
    }

    public static StaticContentSupport create(String resourceRoot, ClassLoader classLoader) {
        return StaticContentSupport.builder(resourceRoot, classLoader).build();
    }

    public static StaticContentSupport create(Path root) {
        return StaticContentSupport.builder(root).build();
    }

    public static class Builder
    implements io.helidon.common.Builder<StaticContentSupport> {
        private final Path fsRoot;
        private final String clRoot;
        private final ClassLoader classLoader;
        private final Map<String, MediaType> specificContentTypes = new TreeMap<String, MediaType>(String.CASE_INSENSITIVE_ORDER);
        private String welcomeFileName;
        private Path tmpDir;

        Builder(Path fsRoot) {
            Objects.requireNonNull(fsRoot, "Attribute fsRoot is null!");
            this.fsRoot = fsRoot;
            this.clRoot = null;
            this.classLoader = null;
        }

        Builder(String clRoot, ClassLoader classLoader) {
            Objects.requireNonNull(clRoot, "Attribute clRoot is null!");
            if (clRoot.startsWith("/")) {
                clRoot = clRoot.substring(1);
            }
            this.clRoot = clRoot;
            this.classLoader = classLoader;
            this.fsRoot = null;
        }

        public Builder welcomeFileName(String welcomeFileName) {
            this.welcomeFileName = welcomeFileName;
            return this;
        }

        public Builder tmpDir(Path tmpDir) {
            this.tmpDir = tmpDir;
            return this;
        }

        public Builder contentType(String filenameExtension, MediaType contentType) {
            Objects.requireNonNull(filenameExtension, "Parameter 'filenameExtension' is null!");
            Objects.requireNonNull(contentType, "Parameter 'contentType' is null!");
            filenameExtension = filenameExtension.trim();
            if (filenameExtension.startsWith(".")) {
                filenameExtension = filenameExtension.substring(1);
            }
            if (filenameExtension.isEmpty()) {
                throw new IllegalArgumentException("Parameter 'filenameExtension' cannot be empty!");
            }
            this.specificContentTypes.put(filenameExtension, contentType);
            return this;
        }

        public StaticContentSupport build() {
            StaticContentHandler handler;
            ContentTypeSelector selector = new ContentTypeSelector(this.specificContentTypes);
            if (this.fsRoot != null) {
                handler = FileSystemContentHandler.create(this.welcomeFileName, selector, this.fsRoot);
            } else if (this.clRoot != null) {
                handler = ClassPathContentHandler.create(this.welcomeFileName, selector, this.clRoot, this.tmpDir, this.classLoader);
            } else {
                throw new IllegalArgumentException("Builder was created without specified static content root!");
            }
            return new StaticContentSupport(handler);
        }
    }
}

