/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

class ReferenceHoldingQueue<T>
extends ReferenceQueue<T> {
    private static final Logger LOGGER = Logger.getLogger(ReferenceHoldingQueue.class.getName());
    private final Set<ReleasableReference<T>> set = ConcurrentHashMap.newKeySet();
    private volatile boolean down = false;

    ReferenceHoldingQueue() {
    }

    boolean release() {
        Reference poll;
        while ((poll = this.poll()) != null) {
            this.hookOnAutoRelease();
            if (poll instanceof ReleasableReference) {
                ((ReleasableReference)poll).release();
                continue;
            }
            LOGGER.warning(() -> "Unexpected type detected: " + poll.getClass());
        }
        return this.set.isEmpty();
    }

    protected void hookOnAutoRelease() {
    }

    public void shutdown() {
        this.down = true;
        for (ReleasableReference<T> reference : this.set) {
            reference.release();
        }
    }

    private void link(ReleasableReference<T> reference) {
        if (this.down) {
            throw new IllegalStateException("Shutdown was requested. This queue must not be used anymore");
        }
        this.set.add(reference);
    }

    private void unlink(ReleasableReference<T> reference) {
        this.set.remove(reference);
    }

    static final class ReleasableReference<T>
    extends PhantomReference<T> {
        private final AtomicBoolean released = new AtomicBoolean(false);
        private final ReferenceHoldingQueue<T> queue;
        private final Runnable r;

        ReleasableReference(T referent, ReferenceHoldingQueue<T> q, Runnable r) {
            super(referent, q);
            this.queue = q;
            this.r = r;
            this.queue.link(this);
        }

        boolean isReleased() {
            return this.released.get();
        }

        void release() {
            if (!this.released.getAndSet(true)) {
                this.queue.unlink(this);
                this.r.run();
            }
        }
    }
}

