/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyContext;
import io.helidon.media.common.MessageBodyFilter;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.helidon.webserver.BareResponse;
import io.helidon.webserver.HashResponseHeaders;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.ResponseHeaders;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebTracingConfig;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Predicate;

abstract class Response
implements ServerResponse {
    static final String STREAM_STATUS = "stream-status";
    static final String STREAM_RESULT = "stream-result";
    private static final String TRACING_CONTENT_WRITE = "content-write";
    private final WebServer webServer;
    private final BareResponse bareResponse;
    private final HashResponseHeaders headers;
    private final CompletionStage<ServerResponse> completionStage;
    private final MessageBodyWriterContext writerContext;
    private final MessageBodyEventListener eventListener;
    private final SendLockSupport sendLockSupport;

    Response(WebServer webServer, BareResponse bareResponse, List<MediaType> acceptedTypes) {
        this.webServer = webServer;
        this.bareResponse = bareResponse;
        this.headers = new HashResponseHeaders(bareResponse);
        this.completionStage = bareResponse.whenCompleted().thenApply(a -> this);
        this.sendLockSupport = new SendLockSupport();
        this.eventListener = new MessageBodyEventListener();
        this.writerContext = MessageBodyWriterContext.create((MessageBodyWriterContext)webServer.writerContext(), (MessageBodyContext.EventListener)this.eventListener, (Parameters)this.headers, acceptedTypes);
    }

    Response(Response response) {
        this.webServer = response.webServer;
        this.bareResponse = response.bareResponse;
        this.headers = response.headers;
        this.completionStage = response.completionStage;
        this.sendLockSupport = response.sendLockSupport;
        this.writerContext = response.writerContext;
        this.eventListener = response.eventListener;
    }

    abstract Optional<SpanContext> spanContext();

    @Override
    public WebServer webServer() {
        return this.webServer;
    }

    @Override
    public Http.ResponseStatus status() {
        Http.ResponseStatus status = this.headers.httpStatus();
        return null == status ? Http.Status.OK_200 : status;
    }

    @Override
    public Response status(Http.ResponseStatus status) {
        Objects.requireNonNull(status, "Parameter 'status' was null!");
        this.headers.httpStatus(status);
        return this;
    }

    @Override
    public ResponseHeaders headers() {
        return this.headers;
    }

    @Override
    public MessageBodyWriterContext writerContext() {
        return this.writerContext;
    }

    private Span createWriteSpan(GenericType<?> type) {
        Optional<SpanContext> parentSpan = this.spanContext();
        if (!parentSpan.isPresent()) {
            return null;
        }
        SpanTracingConfig spanConfig = TracingConfigUtil.spanConfig((String)"web-server", (String)TRACING_CONTENT_WRITE);
        if (spanConfig.enabled()) {
            String spanName = spanConfig.newName().orElse(TRACING_CONTENT_WRITE);
            Tracer.SpanBuilder spanBuilder = WebTracingConfig.tracer(this.webServer()).buildSpan(spanName).asChildOf(parentSpan.get());
            if (type != null) {
                spanBuilder.withTag("response.type", type.getTypeName());
            }
            return spanBuilder.start();
        }
        return null;
    }

    @Override
    public Void send(Throwable content) {
        if (this.headers.httpStatus() == null) {
            if (content instanceof HttpException) {
                this.status(((HttpException)content).status());
            } else {
                this.status((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500);
            }
        }
        this.send((Object)content);
        return null;
    }

    @Override
    public <T> Single<ServerResponse> send(T content) {
        try {
            this.sendLockSupport.execute(() -> {
                Flow.Publisher sendPublisher = this.writerContext.marshall(Single.just((Object)content), GenericType.create((Object)content));
                this.sendLockSupport.contentSend = true;
                sendPublisher.subscribe(this.bareResponse);
            }, content == null);
            return this.whenSent();
        }
        catch (Error | RuntimeException e) {
            this.eventListener.finish();
            throw e;
        }
    }

    @Override
    public Single<ServerResponse> send(Flow.Publisher<DataChunk> content) {
        return this.send(content, true);
    }

    @Override
    public Single<ServerResponse> send(Flow.Publisher<DataChunk> content, boolean applyFilters) {
        try {
            Flow.Publisher sendPublisher = applyFilters ? this.writerContext.applyFilters(content) : content;
            this.sendLockSupport.execute(() -> {
                this.sendLockSupport.contentSend = true;
                sendPublisher.subscribe(this.bareResponse);
            }, content == null);
            return this.whenSent();
        }
        catch (Error | RuntimeException e) {
            this.eventListener.finish();
            throw e;
        }
    }

    @Override
    public Single<ServerResponse> send() {
        return this.send((Flow.Publisher<DataChunk>)null);
    }

    @Override
    public <T> Single<ServerResponse> send(Flow.Publisher<T> content, Class<T> itemClass) {
        try {
            this.sendLockSupport.execute(() -> {
                GenericType type = GenericType.create((Class)itemClass);
                Flow.Publisher sendPublisher = this.writerContext.marshallStream(content, type);
                this.sendLockSupport.contentSend = true;
                sendPublisher.subscribe(this.bareResponse);
            }, content == null);
            return this.whenSent();
        }
        catch (Error | RuntimeException e) {
            this.eventListener.finish();
            throw e;
        }
    }

    @Override
    public Single<ServerResponse> send(Function<MessageBodyWriterContext, Flow.Publisher<DataChunk>> function) {
        return this.send(function.apply(this.writerContext), false);
    }

    @Override
    public Response registerWriter(MessageBodyWriter<?> writer) {
        this.writerContext.registerWriter(writer);
        return this;
    }

    @Override
    public Response registerWriter(MessageBodyStreamWriter<?> writer) {
        this.writerContext.registerWriter(writer);
        return this;
    }

    @Override
    public Response registerFilter(MessageBodyFilter filter) {
        this.writerContext.registerFilter(filter);
        return this;
    }

    @Override
    public Response registerFilter(Function<Flow.Publisher<DataChunk>, Flow.Publisher<DataChunk>> function) {
        this.writerContext.registerFilter(function::apply);
        return this;
    }

    @Override
    public <T> Response registerWriter(Class<T> type, Function<T, Flow.Publisher<DataChunk>> function) {
        this.writerContext.registerWriter(type, function);
        return this;
    }

    @Override
    public <T> Response registerWriter(Predicate<?> accept, Function<T, Flow.Publisher<DataChunk>> function) {
        this.writerContext.registerWriter(accept, function);
        return this;
    }

    @Override
    public <T> Response registerWriter(Class<T> type, MediaType contentType, Function<? extends T, Flow.Publisher<DataChunk>> function) {
        this.writerContext.registerWriter(type, contentType, function);
        return this;
    }

    @Override
    public <T> Response registerWriter(Predicate<?> accept, MediaType contentType, Function<T, Flow.Publisher<DataChunk>> function) {
        this.writerContext.registerWriter(accept, contentType, function);
        return this;
    }

    @Override
    public Single<ServerResponse> whenSent() {
        return Single.create(this.completionStage);
    }

    @Override
    public long requestId() {
        return this.bareResponse.requestId();
    }

    private static class SendLockSupport {
        private boolean contentSend = false;

        private SendLockSupport() {
        }

        private synchronized void execute(Runnable runnable, boolean silentSendStatus) {
            if (this.contentSend) {
                if (silentSendStatus) {
                    return;
                }
                throw new IllegalStateException("Response is already sent!");
            }
            runnable.run();
        }
    }

    private final class MessageBodyEventListener
    implements MessageBodyContext.EventListener {
        private Span span;
        private volatile boolean sent;

        private MessageBodyEventListener() {
        }

        private synchronized void sendErrorHeadersIfNeeded() {
            if (Response.this.headers != null && !this.sent) {
                Response.this.status(500);
                Response.this.headers().add(HttpHeaderNames.TRAILER.toString(), new String[]{"stream-status,stream-result"});
                this.sent = true;
                Response.this.headers.send();
            }
        }

        private synchronized void sendHeadersIfNeeded() {
            if (Response.this.headers != null && !this.sent) {
                this.sent = true;
                Response.this.headers.send();
            }
        }

        void finish() {
            if (this.span != null) {
                this.span.finish();
            }
        }

        public void onEvent(MessageBodyContext.Event event) {
            switch (event.eventType()) {
                case BEFORE_ONSUBSCRIBE: {
                    GenericType type = event.entityType().orElse(null);
                    this.span = Response.this.createWriteSpan(type);
                    break;
                }
                case BEFORE_ONNEXT: {
                    this.sendHeadersIfNeeded();
                    break;
                }
                case BEFORE_ONERROR: {
                    this.sendErrorHeadersIfNeeded();
                    break;
                }
                case AFTER_ONERROR: {
                    if (this.span == null) break;
                    this.span.finish();
                    break;
                }
                case BEFORE_ONCOMPLETE: {
                    this.sendHeadersIfNeeded();
                    break;
                }
                case AFTER_ONCOMPLETE: {
                    this.finish();
                    break;
                }
            }
        }
    }
}

