/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.DeprecatedConfig;
import io.helidon.webserver.ClientAuthentication;
import io.helidon.webserver.ServerBasicConfig;
import io.helidon.webserver.WebServerTls;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public interface SocketConfiguration {
    @Deprecated
    public static final SocketConfiguration DEFAULT = SocketConfiguration.builder().build();
    public static final int DEFAULT_BACKLOG_SIZE = 1024;

    default public String name() {
        return "@default";
    }

    public int port();

    public InetAddress bindAddress();

    public int backlog();

    public int timeoutMillis();

    public int receiveBufferSize();

    public SSLContext ssl();

    public Set<String> enabledSslProtocols();

    public ClientAuthentication clientAuth();

    default public boolean enabled() {
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SocketConfiguration create(String name) {
        return SocketConfiguration.builder().name(name).build();
    }

    public static final class Builder
    implements SocketConfigurationBuilder<Builder>,
    io.helidon.common.Builder<SocketConfiguration> {
        @Deprecated
        static final String UNCONFIGURED_NAME = "io.helidon.webserver.SocketConfiguration.UNCONFIGURED";
        private final WebServerTls.Builder tlsConfigBuilder = WebServerTls.builder();
        private int port = 0;
        private InetAddress bindAddress = null;
        private int backlog = 1024;
        private int timeoutMillis = 0;
        private int receiveBufferSize = 0;
        private WebServerTls webServerTls;
        private String name = "io.helidon.webserver.SocketConfiguration.UNCONFIGURED";
        private boolean enabled = true;

        private Builder() {
        }

        public SocketConfiguration build() {
            if (null == this.webServerTls) {
                this.webServerTls = this.tlsConfigBuilder.build();
            }
            if (null == this.name) {
                throw new ConfigException("Socket name must be configured for each socket");
            }
            return new ServerBasicConfig.SocketConfig(this);
        }

        @Override
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public Builder bindAddress(InetAddress bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        @Override
        public Builder backlog(int backlog) {
            this.backlog = backlog;
            return this;
        }

        @Deprecated
        public Builder timeoutMillis(int timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        @Override
        public Builder receiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return this;
        }

        @Deprecated
        public Builder ssl(SSLContext sslContext) {
            if (null != sslContext) {
                this.tlsConfigBuilder.sslContext(sslContext);
            }
            return this;
        }

        @Deprecated
        public Builder ssl(Supplier<? extends SSLContext> sslContextBuilder) {
            return this.ssl(sslContextBuilder != null ? sslContextBuilder.get() : null);
        }

        @Deprecated
        public Builder enabledSSlProtocols(String ... protocols) {
            if (null == protocols) {
                this.enabledSSlProtocols(List.of());
            } else {
                this.enabledSSlProtocols(Arrays.asList(protocols));
            }
            return this;
        }

        @Deprecated
        public Builder enabledSSlProtocols(List<String> protocols) {
            if (null == protocols) {
                this.tlsConfigBuilder.enabledProtocols(List.of());
            } else {
                this.tlsConfigBuilder.enabledProtocols(protocols);
            }
            return this;
        }

        @Override
        public Builder timeout(long amount, TimeUnit unit) {
            long timeout = unit.toMillis(amount);
            this.timeoutMillis = timeout > Integer.MAX_VALUE ? 0 : (int)timeout;
            return this;
        }

        @Override
        public Builder tls(WebServerTls webServerTls) {
            this.webServerTls = webServerTls;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder config(Config config) {
            SocketConfigurationBuilder.super.config(config);
            config.get("name").asString().ifPresent(this::name);
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            return this;
        }

        int port() {
            return this.port;
        }

        Optional<InetAddress> bindAddress() {
            return Optional.ofNullable(this.bindAddress);
        }

        int backlog() {
            return this.backlog;
        }

        int timeoutMillis() {
            return this.timeoutMillis;
        }

        int receiveBufferSize() {
            return this.receiveBufferSize;
        }

        WebServerTls tlsConfig() {
            return this.webServerTls;
        }

        private static InetAddress string2InetAddress(String address) {
            try {
                return InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                throw new ConfigException("Illegal value of 'bind-address' configuration key. Expecting host or ip address!", (Throwable)e);
            }
        }

        String name() {
            return this.name;
        }

        public boolean enabled() {
            return this.enabled;
        }
    }

    public static interface SocketConfigurationBuilder<B extends SocketConfigurationBuilder<B>> {
        public B port(int var1);

        default public B bindAddress(String address) {
            try {
                return this.bindAddress(InetAddress.getByName(address));
            }
            catch (UnknownHostException e) {
                throw new ConfigException("Illegal value of 'bind-address' configuration key. Expecting host or ip address!", (Throwable)e);
            }
        }

        default public B host(String address) {
            return this.bindAddress(address);
        }

        public B bindAddress(InetAddress var1);

        public B backlog(int var1);

        public B timeout(long var1, TimeUnit var3);

        public B receiveBufferSize(int var1);

        public B tls(WebServerTls var1);

        default public B tls(Supplier<WebServerTls> tlsConfig) {
            return this.tls(tlsConfig.get());
        }

        default public B config(Config config) {
            config.get("port").asInt().ifPresent(this::port);
            config.get("bind-address").asString().ifPresent(this::host);
            config.get("backlog").asInt().ifPresent(this::backlog);
            DeprecatedConfig.get((Config)config, (String)"timeout-millis", (String)"timeout").asInt().ifPresent(it -> this.timeout(it.intValue(), TimeUnit.MILLISECONDS));
            DeprecatedConfig.get((Config)config, (String)"receive-buffer-size", (String)"receive-buffer").asInt().ifPresent(this::receiveBufferSize);
            Optional enabledProtocols = DeprecatedConfig.get((Config)config, (String)"ssl.protocols", (String)"ssl-protocols").asList(String.class).asOptional();
            Config sslConfig = DeprecatedConfig.get((Config)config, (String)"tls", (String)"ssl");
            if (sslConfig.exists()) {
                try {
                    WebServerTls.Builder builder = WebServerTls.builder();
                    enabledProtocols.ifPresent(builder::enabledProtocols);
                    builder.config(sslConfig);
                    this.tls(builder.build());
                }
                catch (IllegalStateException e) {
                    throw new ConfigException("Cannot load SSL configuration.", (Throwable)e);
                }
            }
            return (B)this;
        }
    }
}

