/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.context.Context;
import io.helidon.webserver.ExperimentalConfiguration;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.SocketConfiguration;
import io.helidon.webserver.TlsConfig;
import io.opentracing.Tracer;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;

class ServerBasicConfig
implements ServerConfiguration {
    private final SocketConfiguration socketConfig;
    private final int workers;
    private final Tracer tracer;
    private final Map<String, SocketConfiguration> socketConfigs;
    private final ExperimentalConfiguration experimental;
    private final Context context;
    private final boolean printFeatureDetails;

    ServerBasicConfig(ServerConfiguration.Builder builder) {
        this.socketConfig = builder.defaultSocketBuilder().build();
        this.workers = builder.workers();
        this.tracer = builder.tracer();
        this.experimental = builder.experimental();
        this.context = builder.context();
        this.printFeatureDetails = builder.printFeatureDetails();
        HashMap<String, SocketConfiguration> map = new HashMap<String, SocketConfiguration>(builder.sockets());
        map.put("@default", this.socketConfig);
        this.socketConfigs = Collections.unmodifiableMap(map);
    }

    @Override
    public SSLContext ssl() {
        return this.socketConfig.ssl();
    }

    @Override
    public Set<String> enabledSslProtocols() {
        return this.socketConfig.enabledSslProtocols();
    }

    @Override
    public int workersCount() {
        return this.workers;
    }

    @Override
    public int port() {
        return this.socketConfig.port();
    }

    @Override
    public InetAddress bindAddress() {
        return this.socketConfig.bindAddress();
    }

    @Override
    public int backlog() {
        return this.socketConfig.backlog();
    }

    @Override
    public int timeoutMillis() {
        return this.socketConfig.timeoutMillis();
    }

    @Override
    public int receiveBufferSize() {
        return this.socketConfig.receiveBufferSize();
    }

    @Override
    public Tracer tracer() {
        return this.tracer;
    }

    @Override
    public Map<String, SocketConfiguration> sockets() {
        return this.socketConfigs;
    }

    @Override
    public ExperimentalConfiguration experimental() {
        return this.experimental;
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public boolean printFeatureDetails() {
        return this.printFeatureDetails;
    }

    static class SocketConfig
    implements SocketConfiguration {
        private final int port;
        private final InetAddress bindAddress;
        private final int backlog;
        private final int timeoutMillis;
        private final int receiveBufferSize;
        private final SSLContext sslContext;
        private final Set<String> enabledSslProtocols;
        private final String name;
        private final boolean enabled;

        SocketConfig(SocketConfiguration.Builder builder) {
            this.name = builder.name();
            this.enabled = builder.enabled();
            this.port = Math.max(builder.port(), 0);
            this.bindAddress = builder.bindAddress().orElse(null);
            this.backlog = builder.backlog() < 0 ? 1024 : builder.backlog();
            this.timeoutMillis = Math.max(builder.timeoutMillis(), 0);
            this.receiveBufferSize = Math.max(builder.receiveBufferSize(), 0);
            TlsConfig tlsConfig = builder.tlsConfig();
            if (tlsConfig.enabled()) {
                this.sslContext = tlsConfig.sslContext();
                this.enabledSslProtocols = new HashSet<String>(tlsConfig.enabledTlsProtocols());
            } else {
                this.sslContext = null;
                this.enabledSslProtocols = Set.of();
            }
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public InetAddress bindAddress() {
            return this.bindAddress;
        }

        @Override
        public int backlog() {
            return this.backlog;
        }

        @Override
        public int timeoutMillis() {
            return this.timeoutMillis;
        }

        @Override
        public int receiveBufferSize() {
            return this.receiveBufferSize;
        }

        @Override
        public SSLContext ssl() {
            return this.sslContext;
        }

        @Override
        public Set<String> enabledSslProtocols() {
            return this.enabledSslProtocols;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean enabled() {
            return this.enabled;
        }
    }
}

