/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.ClientAuthentication;
import io.helidon.webserver.ServerBasicConfig;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public interface SocketConfiguration {
    public static final SocketConfiguration DEFAULT = SocketConfiguration.builder().build();
    public static final int DEFAULT_BACKLOG_SIZE = 1024;

    public int port();

    public InetAddress bindAddress();

    public int backlog();

    public int timeoutMillis();

    public int receiveBufferSize();

    public SSLContext ssl();

    public Set<String> enabledSslProtocols();

    public ClientAuthentication clientAuth();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements io.helidon.common.Builder<SocketConfiguration> {
        private int port = 0;
        private InetAddress bindAddress = null;
        private SSLContext sslContext = null;
        private final Set<String> enabledSslProtocols = new HashSet<String>();
        private int backlog = 0;
        private int timeoutMillis = 0;
        private int receiveBufferSize = 0;
        private ClientAuthentication clientAuth = ClientAuthentication.NONE;

        private Builder() {
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder bindAddress(InetAddress bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        public Builder backlog(int backlog) {
            this.backlog = backlog;
            return this;
        }

        public Builder timeoutMillis(int timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public Builder receiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return this;
        }

        public Builder ssl(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder ssl(Supplier<? extends SSLContext> sslContextBuilder) {
            return this.ssl(sslContextBuilder != null ? sslContextBuilder.get() : null);
        }

        public Builder clientAuth(ClientAuthentication clientAuth) {
            this.clientAuth = Objects.requireNonNull(clientAuth);
            return this;
        }

        void clientAuth(String it) {
            this.clientAuth(ClientAuthentication.valueOf(it.toUpperCase()));
        }

        public Builder enabledSSlProtocols(String ... protocols) {
            this.enabledSslProtocols.addAll(Arrays.asList(protocols));
            return this;
        }

        public Builder enabledSSlProtocols(List<String> protocols) {
            if (protocols != null) {
                this.enabledSslProtocols.addAll(protocols);
            }
            return this;
        }

        public SocketConfiguration build() {
            return new ServerBasicConfig.SocketConfig(this.port, this.bindAddress, this.sslContext, this.enabledSslProtocols, this.backlog, this.timeoutMillis, this.receiveBufferSize, this.clientAuth);
        }
    }
}

