/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.webserver.Handler;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class RequestPredicate {
    private static final Condition EMPTY_CONDITION = (a, b) -> a;
    private final RequestPredicate first;
    private volatile RequestPredicate next;
    private final Condition condition;

    private RequestPredicate() {
        this.first = this;
        this.next = null;
        this.condition = EMPTY_CONDITION;
    }

    private RequestPredicate(RequestPredicate first, Condition cond) {
        this.first = first;
        this.next = null;
        this.condition = cond;
    }

    private RequestPredicate nextCondition(Condition newCondition) {
        if (this.next != null) {
            throw new IllegalStateException("next predicate already set");
        }
        this.next = new RequestPredicate(this.first, newCondition);
        return this.next;
    }

    public ConditionalHandler thenApply(Handler handler) {
        return new ConditionalHandler(this, handler);
    }

    public boolean test(ServerRequest request) {
        return RequestPredicate.eval(true, this.first, request);
    }

    public RequestPredicate and(Predicate<ServerRequest> predicate) {
        return this.nextCondition((exprVal, req) -> exprVal && predicate.test(req));
    }

    public RequestPredicate or(Predicate<ServerRequest> predicate) {
        return this.nextCondition((exprVal, req) -> exprVal || predicate.test(req));
    }

    public RequestPredicate negate() {
        return this.nextCondition((exprVal, req) -> !exprVal);
    }

    public RequestPredicate isOfMethod(String ... methods) {
        Objects.requireNonNull(methods, "methods");
        return this.and(req -> Stream.of(methods).map(String::toUpperCase).anyMatch(req.method().name()::equals));
    }

    public RequestPredicate isOfMethod(Http.Method ... methods) {
        Objects.requireNonNull(methods, "methods");
        return this.and(req -> Stream.of(methods).map(Enum::name).anyMatch(req.method().name()::equals));
    }

    public RequestPredicate containsHeader(String name) {
        return this.containsHeader(name, (String c) -> true);
    }

    public RequestPredicate containsHeader(String name, String value) {
        Objects.requireNonNull(value, "header value");
        return this.containsHeader(name, value::equals);
    }

    public RequestPredicate containsHeader(String name, Predicate<String> predicate) {
        Objects.requireNonNull(name, "header name");
        Objects.requireNonNull(predicate, "header predicate");
        return this.and(req -> req.headers().value(name).filter(predicate).isPresent());
    }

    public RequestPredicate containsQueryParameter(String name) {
        return this.containsQueryParameter(name, (String c) -> true);
    }

    public RequestPredicate containsQueryParameter(String name, String value) {
        Objects.requireNonNull(value, "query param value");
        return this.containsQueryParameter(name, value::equals);
    }

    public RequestPredicate containsQueryParameter(String name, Predicate<String> predicate) {
        Objects.requireNonNull(name, "query param name");
        Objects.requireNonNull(predicate, "query param predicate");
        return this.and(req -> req.queryParams().all(name).stream().anyMatch(predicate));
    }

    public RequestPredicate containsCookie(String name) {
        return this.containsCookie(name, (String c) -> true);
    }

    public RequestPredicate containsCookie(String name, String value) {
        Objects.requireNonNull(value, "cookie value");
        return this.containsCookie(name, value::equals);
    }

    public RequestPredicate containsCookie(String name, Predicate<String> predicate) {
        Objects.requireNonNull(name, "cookie name");
        Objects.requireNonNull(predicate, "cookie predicate");
        return this.and(req -> req.headers().cookies().all(name).stream().anyMatch(predicate));
    }

    public RequestPredicate accepts(String ... contentType) {
        Objects.requireNonNull(contentType, "content types");
        return this.and(req -> Stream.of(contentType).anyMatch(mt -> req.headers().isAccepted(MediaType.parse((String)mt))));
    }

    public RequestPredicate accepts(MediaType ... contentType) {
        Objects.requireNonNull(contentType, "accepted media types");
        return this.and(req -> Stream.of(contentType).anyMatch(mt -> req.headers().isAccepted((MediaType)mt)));
    }

    public RequestPredicate hasContentType(String ... contentType) {
        Objects.requireNonNull(contentType, "accepted media types");
        return this.and(req -> {
            Optional<MediaType> actualContentType = req.headers().contentType();
            return actualContentType.isPresent() && Stream.of(contentType).anyMatch(mt -> ((MediaType)actualContentType.get()).equals((Object)MediaType.parse((String)mt)));
        });
    }

    public RequestPredicate hasContentType(MediaType ... contentType) {
        Objects.requireNonNull(contentType, "content types");
        return this.and(req -> {
            Optional<MediaType> actualContentType = req.headers().contentType();
            return actualContentType.isPresent() && Stream.of(contentType).anyMatch(mt -> ((MediaType)actualContentType.get()).equals(mt));
        });
    }

    public static RequestPredicate create() {
        return new RequestPredicate();
    }

    private static boolean eval(boolean currentValue, RequestPredicate predicate, ServerRequest request) {
        boolean newValue = predicate.condition.eval(currentValue, request);
        if (predicate.next != null) {
            return RequestPredicate.eval(newValue, predicate.next, request);
        }
        return newValue;
    }

    @FunctionalInterface
    private static interface Condition {
        public boolean eval(boolean var1, ServerRequest var2);
    }

    public static class ConditionalHandler
    implements Handler {
        private final RequestPredicate condition;
        private final Handler acceptHandler;
        private final Handler declineHandler;

        private ConditionalHandler(RequestPredicate condition, Handler acceptHandler, Handler declineHandler) {
            this.condition = condition;
            this.acceptHandler = acceptHandler;
            this.declineHandler = declineHandler == null ? (req, res) -> req.next() : declineHandler;
        }

        private ConditionalHandler(RequestPredicate condition, Handler acceptHandler) {
            this(condition, acceptHandler, (Handler)null);
        }

        @Override
        public void accept(ServerRequest req, ServerResponse res) {
            if (this.condition.test(req)) {
                this.acceptHandler.accept(req, res);
            } else {
                this.declineHandler.accept(req, res);
            }
        }

        public Handler otherwise(Handler handler) {
            return new ConditionalHandler(this.condition, this.acceptHandler, handler);
        }
    }
}

