/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.context.Context;
import io.helidon.common.http.ContextualRegistry;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.http.Reader;
import io.helidon.common.reactive.Flow;
import io.helidon.media.common.ContentReaders;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.helidon.webserver.BareRequest;
import io.helidon.webserver.HashRequestHeaders;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.UriComponent;
import io.helidon.webserver.WebServer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;

abstract class Request
implements ServerRequest {
    private static final String TRACING_CONTENT_READ_NAME = "content-read";
    static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final BareRequest bareRequest;
    private final WebServer webServer;
    private final ContextualRegistry context;
    private final Parameters queryParams;
    private final RequestHeaders headers;
    private final Content content;

    Request(BareRequest req, WebServer webServer) {
        this.bareRequest = req;
        this.webServer = webServer;
        this.context = ContextualRegistry.create((Context)webServer.context());
        this.queryParams = UriComponent.decodeQuery(req.uri().getRawQuery(), true);
        this.headers = new HashRequestHeaders(this.bareRequest.headers());
        this.content = new Content();
    }

    Request(Request request) {
        this.bareRequest = request.bareRequest;
        this.webServer = request.webServer;
        this.context = request.context;
        this.queryParams = request.queryParams;
        this.headers = request.headers;
        this.content = new Content(request.content);
    }

    static Charset contentCharset(ServerRequest request) {
        return request.headers().contentType().flatMap(MediaType::charset).map(Charset::forName).orElse(DEFAULT_CHARSET);
    }

    @Override
    public WebServer webServer() {
        return this.webServer;
    }

    @Override
    public ContextualRegistry context() {
        return this.context;
    }

    public Http.RequestMethod method() {
        return this.bareRequest.method();
    }

    public Http.Version version() {
        return this.bareRequest.version();
    }

    public URI uri() {
        return this.bareRequest.uri();
    }

    public String query() {
        return this.bareRequest.uri().getRawQuery();
    }

    public Parameters queryParams() {
        return this.queryParams;
    }

    public String fragment() {
        return this.bareRequest.uri().getFragment();
    }

    @Override
    public String localAddress() {
        return this.bareRequest.localAddress();
    }

    @Override
    public int localPort() {
        return this.bareRequest.localPort();
    }

    @Override
    public String remoteAddress() {
        return this.bareRequest.remoteAddress();
    }

    @Override
    public int remotePort() {
        return this.bareRequest.remotePort();
    }

    @Override
    public boolean isSecure() {
        return this.bareRequest.isSecure();
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }

    @Override
    public Content content() {
        return this.content;
    }

    @Override
    public long requestId() {
        return this.bareRequest.requestId();
    }

    private static CompletableFuture failedFuture(Throwable t) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(t);
        return result;
    }

    static class Path
    implements HttpRequest.Path {
        private final String path;
        private final String rawPath;
        private final Map<String, String> params;
        private final Path absolutePath;
        private List<String> segments;

        Path(String path, String rawPath, Map<String, String> params, Path absolutePath) {
            this.path = path;
            this.rawPath = rawPath;
            this.params = params == null ? Collections.emptyMap() : params;
            this.absolutePath = absolutePath;
        }

        public String param(String name) {
            return this.params.get(name);
        }

        public List<String> segments() {
            List<String> result = this.segments;
            if (result == null) {
                StringTokenizer stok = new StringTokenizer(this.path, "/");
                result = new ArrayList<String>();
                while (stok.hasMoreTokens()) {
                    result.add(stok.nextToken());
                }
                this.segments = result;
            }
            return result;
        }

        public String toString() {
            return this.path;
        }

        public String toRawString() {
            return this.rawPath;
        }

        public Path absolute() {
            return this.absolutePath == null ? this : this.absolutePath;
        }

        static Path create(Path contextual, String path, Map<String, String> params) {
            return Path.create(contextual, path, path, params);
        }

        static Path create(Path contextual, String path, String rawPath, Map<String, String> params) {
            if (contextual == null) {
                return new Path(path, rawPath, params, null);
            }
            return contextual.createSubpath(path, rawPath, params);
        }

        Path createSubpath(String path, String rawPath, Map<String, String> params) {
            if (params == null) {
                params = Collections.emptyMap();
            }
            if (this.absolutePath == null) {
                HashMap<String, String> map = new HashMap<String, String>(this.params.size() + params.size());
                map.putAll(this.params);
                map.putAll(params);
                return new Path(path, rawPath, params, new Path(this.path, this.rawPath, map, null));
            }
            HashMap<String, String> map = new HashMap<String, String>(this.params.size() + params.size() + this.absolutePath.params.size());
            map.putAll(this.absolutePath.params);
            map.putAll(this.params);
            map.putAll(params);
            return new Path(path, rawPath, params, new Path(this.absolutePath.path, this.absolutePath.rawPath, map, null));
        }
    }

    class Content
    implements io.helidon.common.http.Content {
        private final Flow.Publisher<DataChunk> originalPublisher;
        private final Deque<InternalReader<?>> readers;
        private final List<Function<Flow.Publisher<DataChunk>, Flow.Publisher<DataChunk>>> filters;
        private final ReadWriteLock readersLock;
        private final ReadWriteLock filtersLock;

        private Content() {
            this.originalPublisher = Request.this.bareRequest.bodyPublisher();
            this.readers = this.appendDefaultReaders(new LinkedList());
            this.filters = new ArrayList<Function<Flow.Publisher<DataChunk>, Flow.Publisher<DataChunk>>>();
            this.readersLock = new ReentrantReadWriteLock();
            this.filtersLock = new ReentrantReadWriteLock();
        }

        private Content(Content orig) {
            this.originalPublisher = orig.originalPublisher;
            this.readers = orig.readers;
            this.filters = orig.filters;
            this.readersLock = orig.readersLock;
            this.filtersLock = orig.filtersLock;
        }

        private Deque<InternalReader<?>> appendDefaultReaders(Deque<InternalReader<?>> readers) {
            readers.addLast(this.reader(String.class, this.stringContentReader()));
            readers.addLast(this.reader(byte[].class, ContentReaders.byteArrayReader()));
            readers.addLast(this.reader(InputStream.class, ContentReaders.inputStreamReader()));
            return readers;
        }

        public void registerFilter(Function<Flow.Publisher<DataChunk>, Flow.Publisher<DataChunk>> function) {
            Objects.requireNonNull(function, "Parameter 'function' is null!");
            try {
                this.filtersLock.writeLock().lock();
                this.filters.add(function);
            }
            finally {
                this.filtersLock.writeLock().unlock();
            }
        }

        public <T> void registerReader(Class<T> type, Reader<T> reader) {
            this.register(this.reader(type, reader));
        }

        public <T> void registerReader(Predicate<Class<?>> predicate, Reader<T> reader) {
            this.register(new InternalReader<T>(predicate, reader));
        }

        public <T> void register(InternalReader<T> reader) {
            try {
                this.readersLock.writeLock().lock();
                this.readers.addFirst(reader);
            }
            finally {
                this.readersLock.writeLock().unlock();
            }
        }

        private <T> InternalReader<T> reader(Class<T> clazz, Reader<T> reader) {
            return new InternalReader<T>(aClass -> clazz.isAssignableFrom((Class<?>)aClass), reader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> CompletionStage<T> as(Class<T> type) {
            CompletionStage result;
            Span readSpan = this.createReadSpan(type);
            try {
                this.readersLock.readLock().lock();
                result = this.readerFor(type).apply(this.chainPublishers(), type);
            }
            catch (IllegalArgumentException e) {
                result = Request.failedFuture(e);
            }
            catch (Exception e) {
                result = Request.failedFuture(new IllegalArgumentException("Transformation failed!", e));
            }
            finally {
                this.readersLock.readLock().unlock();
            }
            if (null != readSpan) {
                result.thenRun(() -> ((Span)readSpan).finish()).exceptionally(t -> {
                    this.finishSpanWithError(readSpan, (Throwable)t);
                    return null;
                });
            }
            return result;
        }

        private void finishSpanWithError(Span readSpan, Throwable t) {
            if (null == readSpan) {
                return;
            }
            Tags.ERROR.set(readSpan, Boolean.TRUE);
            readSpan.log(CollectionsHelper.mapOf((Object)"event", (Object)"error", (Object)"error.kind", (Object)"Exception", (Object)"error.object", (Object)t, (Object)"message", (Object)t.toString()));
            readSpan.finish();
        }

        private <T> Span createReadSpan(Class<T> type) {
            SpanContext parentSpan = Request.this.spanContext();
            if (null == parentSpan) {
                return null;
            }
            SpanTracingConfig spanConfig = TracingConfigUtil.spanConfig((String)"web-server", (String)Request.TRACING_CONTENT_READ_NAME, (Context)Request.this.context());
            String spanName = spanConfig.newName().orElse(Request.TRACING_CONTENT_READ_NAME);
            if (spanConfig.enabled()) {
                Tracer.SpanBuilder spanBuilder = Request.this.tracer().buildSpan(spanName);
                spanBuilder.asChildOf(parentSpan);
                if (type != null) {
                    spanBuilder.withTag("requested.type", type.getName());
                }
                return spanBuilder.start();
            }
            return null;
        }

        private <T> Reader<T> readerFor(Class<T> type) {
            return this.readers.stream().filter(reader -> reader.accept(type)).findFirst().orElseThrow(() -> new IllegalArgumentException("No reader found for class: " + type));
        }

        private Reader<String> stringContentReader() {
            try {
                Charset charset = Request.contentCharset(Request.this);
                return ContentReaders.stringReader((Charset)charset);
            }
            catch (UnsupportedCharsetException e) {
                return (publisher, clazz) -> {
                    throw e;
                };
            }
        }

        public void subscribe(final Flow.Subscriber<? super DataChunk> subscriber) {
            try {
                final Span readSpan = this.createReadSpan(Flow.Publisher.class);
                this.chainPublishers().subscribe((Flow.Subscriber)new Flow.Subscriber<DataChunk>(){

                    public void onSubscribe(Flow.Subscription subscription) {
                        subscriber.onSubscribe(subscription);
                    }

                    public void onNext(DataChunk item) {
                        subscriber.onNext((Object)item);
                    }

                    public void onError(Throwable throwable) {
                        try {
                            subscriber.onError(throwable);
                        }
                        finally {
                            Content.this.finishSpanWithError(readSpan, throwable);
                        }
                    }

                    public void onComplete() {
                        try {
                            subscriber.onComplete();
                        }
                        finally {
                            if (null != readSpan) {
                                readSpan.finish();
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                subscriber.onError((Throwable)new IllegalArgumentException("Unexpected exception occurred during publishers chaining", e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Flow.Publisher<DataChunk> chainPublishers() {
            Flow.Publisher<DataChunk> lastPublisher = this.originalPublisher;
            try {
                this.filtersLock.readLock().lock();
                for (Function<Flow.Publisher<DataChunk>, Flow.Publisher<DataChunk>> filter : this.filters) {
                    lastPublisher = filter.apply(lastPublisher);
                }
            }
            finally {
                this.filtersLock.readLock().unlock();
            }
            return lastPublisher;
        }
    }

    private static class InternalReader<T>
    implements Reader<T> {
        private final Predicate<Class<?>> predicate;
        private final Reader<T> reader;

        InternalReader(Predicate<Class<?>> predicate, Reader<T> reader) {
            this.predicate = predicate;
            this.reader = reader;
        }

        public boolean accept(Class<?> o) {
            return o != null && this.predicate != null && this.predicate.test(o);
        }

        public CompletionStage<? extends T> apply(Flow.Publisher<DataChunk> publisher, Class<? super T> clazz) {
            return this.reader.apply(publisher, clazz);
        }
    }
}

