/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.config.Config;
import io.helidon.webserver.ClientAuthentication;
import io.helidon.webserver.SSLContextBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLContext;

public final class WebServerTls {
    private final SSLContext sslContext;
    private final ClientAuthentication clientAuth;
    private final Set<String> cipherSuite;

    private WebServerTls(Builder builder) {
        this.sslContext = builder.sslContext;
        this.clientAuth = builder.clientAuth;
        this.cipherSuite = Collections.unmodifiableSet(new HashSet(builder.cipherSuite));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WebServerTls create(Config config) {
        return WebServerTls.builder().config(config).build();
    }

    SSLContext sslContext() {
        return this.sslContext;
    }

    ClientAuthentication clientAuth() {
        return this.clientAuth;
    }

    Set<String> cipherSuite() {
        return this.cipherSuite;
    }

    public static class Builder
    implements io.helidon.common.Builder<WebServerTls> {
        private SSLContext sslContext;
        private ClientAuthentication clientAuth;
        private Set<String> cipherSuite = new HashSet<String>();

        private Builder() {
            this.clientAuth = ClientAuthentication.NONE;
        }

        public WebServerTls build() {
            return new WebServerTls(this);
        }

        public Builder config(Config config) {
            config.get("client-auth").asString().ifPresent(this::clientAuth);
            config.get("cipher-suite").asList(String.class).ifPresent(this::allowedCipherSuite);
            this.sslContext = SSLContextBuilder.create(config);
            return this;
        }

        private void clientAuth(String it) {
            this.clientAuth(ClientAuthentication.valueOf(it.toUpperCase()));
        }

        public Builder clientAuth(ClientAuthentication clientAuth) {
            this.clientAuth = Objects.requireNonNull(clientAuth);
            return this;
        }

        public Builder sslContext(SSLContext context) {
            this.sslContext = context;
            return this;
        }

        public Builder allowedCipherSuite(List<String> cipherSuite) {
            Objects.requireNonNull(cipherSuite);
            if (cipherSuite.isEmpty()) {
                throw new IllegalStateException("Allowed cipher suite has to have at least one cipher specified");
            }
            this.cipherSuite = Collections.unmodifiableSet(new HashSet<String>(cipherSuite));
            return this;
        }
    }
}

