/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.context.Context;
import io.helidon.common.http.ContextualRegistry;
import io.helidon.webserver.ClientAuthentication;
import io.helidon.webserver.ExperimentalConfiguration;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.SocketConfiguration;
import io.opentracing.Tracer;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;

class ServerBasicConfig
implements ServerConfiguration {
    private final SocketConfiguration socketConfig;
    private final int workers;
    private final Tracer tracer;
    private final Map<String, SocketConfiguration> socketConfigs;
    private final ExperimentalConfiguration experimental;
    private final ContextualRegistry context;

    ServerBasicConfig(ServerConfiguration.Builder builder) {
        this.socketConfig = builder.defaultSocketBuilder().build();
        this.workers = builder.workers();
        this.tracer = builder.tracer();
        this.experimental = builder.experimental();
        this.context = builder.context();
        HashMap<String, SocketConfiguration> map = new HashMap<String, SocketConfiguration>(builder.sockets());
        map.put("@default", this.socketConfig);
        this.socketConfigs = Collections.unmodifiableMap(map);
    }

    @Override
    public SSLContext ssl() {
        return this.socketConfig.ssl();
    }

    @Override
    public Set<String> enabledSslProtocols() {
        return this.socketConfig.enabledSslProtocols();
    }

    @Override
    public ClientAuthentication clientAuth() {
        return this.socketConfig.clientAuth();
    }

    @Override
    public Set<String> cipherSuite() {
        return this.socketConfig.cipherSuite();
    }

    @Override
    public int workersCount() {
        return this.workers;
    }

    @Override
    public int port() {
        return this.socketConfig.port();
    }

    @Override
    public InetAddress bindAddress() {
        return this.socketConfig.bindAddress();
    }

    @Override
    public int backlog() {
        return this.socketConfig.backlog();
    }

    @Override
    public int timeoutMillis() {
        return this.socketConfig.timeoutMillis();
    }

    @Override
    public int receiveBufferSize() {
        return this.socketConfig.receiveBufferSize();
    }

    @Override
    public int maxHeaderSize() {
        return this.socketConfig.maxHeaderSize();
    }

    @Override
    public int maxInitialLineLength() {
        return this.socketConfig.maxInitialLineLength();
    }

    @Override
    public int maxChunkSize() {
        return this.socketConfig.maxChunkSize();
    }

    @Override
    public boolean validateHeaders() {
        return this.socketConfig.validateHeaders();
    }

    @Override
    public int initialBufferSize() {
        return this.socketConfig.initialBufferSize();
    }

    @Override
    public Tracer tracer() {
        return this.tracer;
    }

    @Override
    public Map<String, SocketConfiguration> sockets() {
        return this.socketConfigs;
    }

    @Override
    public ExperimentalConfiguration experimental() {
        return this.experimental;
    }

    @Override
    public Context context() {
        return this.context;
    }

    static class SocketConfig
    implements SocketConfiguration {
        private final int port;
        private final InetAddress bindAddress;
        private final int backlog;
        private final int timeoutMillis;
        private final int receiveBufferSize;
        private final SSLContext sslContext;
        private final Set<String> enabledSslProtocols;
        private final Set<String> cipherSuite;
        private final ClientAuthentication clientAuth;
        private final int maxHeaderSize;
        private final int maxInitialLineLength;
        private final int maxChunkSize;
        private final boolean validateHeaders;
        private final int initialBufferSize;

        SocketConfig(SocketConfiguration.Builder builder) {
            this.port = Math.max(0, builder.port());
            this.bindAddress = builder.bindAddress();
            this.backlog = builder.backlog() <= 0 ? 1024 : builder.backlog();
            this.timeoutMillis = Math.max(builder.timeoutMillis(), 0);
            this.receiveBufferSize = Math.max(builder.receiveBufferSize(), 0);
            this.maxHeaderSize = builder.maxHeaderSize();
            this.maxInitialLineLength = builder.maxInitialLineLength();
            this.maxChunkSize = builder.maxChunkSize();
            this.validateHeaders = builder.validateHeaders();
            this.initialBufferSize = builder.initialBufferSize();
            this.clientAuth = builder.clientAuth();
            this.sslContext = builder.sslContext();
            this.cipherSuite = builder.cipherSuite();
            this.enabledSslProtocols = new HashSet<String>(builder.enabledSslProtocols());
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public InetAddress bindAddress() {
            return this.bindAddress;
        }

        @Override
        public int backlog() {
            return this.backlog;
        }

        @Override
        public int timeoutMillis() {
            return this.timeoutMillis;
        }

        @Override
        public int receiveBufferSize() {
            return this.receiveBufferSize;
        }

        @Override
        public SSLContext ssl() {
            return this.sslContext;
        }

        @Override
        public Set<String> enabledSslProtocols() {
            return this.enabledSslProtocols;
        }

        @Override
        public Set<String> cipherSuite() {
            return this.cipherSuite;
        }

        @Override
        public ClientAuthentication clientAuth() {
            return this.clientAuth;
        }

        @Override
        public int maxHeaderSize() {
            return this.maxHeaderSize;
        }

        @Override
        public int maxInitialLineLength() {
            return this.maxInitialLineLength;
        }

        @Override
        public int maxChunkSize() {
            return this.maxChunkSize;
        }

        @Override
        public boolean validateHeaders() {
            return this.validateHeaders;
        }

        @Override
        public int initialBufferSize() {
            return this.initialBufferSize;
        }
    }
}

