/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import java.util.concurrent.atomic.AtomicLong;

class UnboundedSemaphore {
    private final AtomicLong atomicLong = new AtomicLong();

    UnboundedSemaphore() {
    }

    long release(long n) {
        return this.atomicLong.updateAndGet(original -> {
            long r = original + n;
            if (r == Long.MAX_VALUE || ((original ^ r) & (n ^ r)) < 0L) {
                return Long.MAX_VALUE;
            }
            return original + n;
        });
    }

    long tryAcquire() {
        return this.atomicLong.getAndUpdate(original -> {
            if (original == Long.MAX_VALUE) {
                return original;
            }
            if (original == 0L) {
                return 0L;
            }
            return original - 1L;
        });
    }

    long availablePermits() {
        return this.atomicLong.get();
    }
}

