/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

final class Utils {
    private Utils() {
    }

    static <T> T loadSpi(Class<T> service) {
        ServiceLoader<T> servers = ServiceLoader.load(service);
        Iterator<T> serversIt = servers.iterator();
        if (serversIt.hasNext()) {
            return serversIt.next();
        }
        throw new IllegalStateException("No implementation found for SPI: " + service.getName());
    }

    static List<String> tokenize(char separator, String quoteChars, boolean includeEmptyTokens, String text) {
        char[] quotes = quoteChars == null ? new char[]{} : quoteChars.toCharArray();
        StringBuilder token = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        boolean quoted = false;
        char lastQuoteCharacter = ' ';
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (quoted) {
                if (ch == lastQuoteCharacter) {
                    quoted = false;
                }
                token.append(ch);
                continue;
            }
            if (ch == separator) {
                if (includeEmptyTokens || token.length() > 0) {
                    result.add(token.toString());
                }
                token.setLength(0);
                continue;
            }
            for (char quote : quotes) {
                if (ch != quote) continue;
                quoted = true;
                lastQuoteCharacter = ch;
                break;
            }
            token.append(ch);
        }
        if (includeEmptyTokens || token.length() > 0) {
            result.add(token.toString());
        }
        return result;
    }

    static void write(ByteBuffer byteBuffer, OutputStream out) throws IOException {
        if (byteBuffer.hasArray()) {
            out.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        } else {
            byte[] buff = new byte[byteBuffer.remaining()];
            byteBuffer.get(buff);
            out.write(buff);
        }
    }
}

