/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.reactive.Flow;
import io.helidon.webserver.ContextualRegistry;
import io.helidon.webserver.Http;
import io.helidon.webserver.Parameters;
import io.helidon.webserver.RequestChunk;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.WebServer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ServerRequest {
    public void next();

    public void next(Throwable var1);

    public WebServer webServer();

    public ContextualRegistry context();

    public Http.RequestMethod method();

    public Http.Version version();

    public URI uri();

    public String query();

    public Parameters queryParams();

    public Path path();

    public String fragment();

    public String localAddress();

    public int localPort();

    public String remoteAddress();

    public int remotePort();

    public boolean isSecure();

    public RequestHeaders headers();

    public Content content();

    public long requestId();

    @Deprecated
    public Span span();

    public SpanContext spanContext();

    public static interface Path {
        public String param(String var1);

        public List<String> segments();

        public String toString();

        public Path absolute();
    }

    public static interface Reader<R>
    extends BiFunction<Flow.Publisher<RequestChunk>, Class<? super R>, CompletionStage<? extends R>> {
        @Override
        public CompletionStage<? extends R> apply(Flow.Publisher<RequestChunk> var1, Class<? super R> var2);

        default public CompletionStage<? extends R> apply(Flow.Publisher<RequestChunk> publisher) {
            return this.apply(publisher, Object.class);
        }

        default public <T extends R> CompletionStage<? extends T> applyAndCast(Flow.Publisher<RequestChunk> publisher, Class<T> type) {
            return this.apply(publisher, type).thenApply(type::cast);
        }
    }

    public static interface Content
    extends Flow.Publisher<RequestChunk> {
        public void subscribe(Flow.Subscriber<? super RequestChunk> var1);

        public void registerFilter(Function<Flow.Publisher<RequestChunk>, Flow.Publisher<RequestChunk>> var1);

        public <T> void registerReader(Class<T> var1, Reader<T> var2);

        public <T> void registerReader(Predicate<Class<?>> var1, Reader<T> var2);

        public <T> CompletionStage<? extends T> as(Class<T> var1);
    }
}

