/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import java.nio.ByteBuffer;

public final class ResponseChunk {
    private final boolean flush;
    private final Runnable releaseCallback;
    private final ByteBuffer data;

    public ResponseChunk(boolean flush, ByteBuffer data, Runnable releaseCallback) {
        this.flush = flush;
        this.releaseCallback = releaseCallback;
        this.data = data != null ? data : ByteBuffer.allocate(0);
    }

    public ResponseChunk(boolean flush, ByteBuffer data) {
        this(flush, data, null);
    }

    public void release() {
        if (this.releaseCallback != null) {
            this.releaseCallback.run();
        }
    }

    public ByteBuffer data() {
        return this.data;
    }

    public boolean flush() {
        return this.flush;
    }
}

