/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.ByteBufferRequestChunk;
import io.helidon.webserver.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public interface RequestChunk {
    default public byte[] bytes() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Utils.write(this.data().asReadOnlyBuffer(), stream);
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError("ByteArrayOutputStream is not expected to throw an IO Exception.", e);
        }
    }

    public ByteBuffer data();

    public boolean isReleased();

    public void release();

    default public long id() {
        return System.identityHashCode(this);
    }

    public static RequestChunk from(ByteBuffer byteBuffer) {
        return new ByteBufferRequestChunk(byteBuffer);
    }

    public static RequestChunk from(byte[] bytes) {
        return new ByteBufferRequestChunk(ByteBuffer.wrap(bytes));
    }
}

