/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.reactive.Flow;
import io.helidon.webserver.ContentReaders;
import io.helidon.webserver.ContextualRegistry;
import io.helidon.webserver.HashRequestHeaders;
import io.helidon.webserver.Http;
import io.helidon.webserver.Parameters;
import io.helidon.webserver.RequestChunk;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.StringContentReader;
import io.helidon.webserver.UriComponent;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.spi.BareRequest;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

abstract class Request
implements ServerRequest {
    private final BareRequest bareRequest;
    private final WebServer webServer;
    private final ContextualRegistry context;
    private final Parameters queryParams;
    private final RequestHeaders headers;
    private final Content content;

    Request(BareRequest req, WebServer webServer) {
        this.bareRequest = req;
        this.webServer = webServer;
        this.context = ContextualRegistry.create(webServer.context());
        this.queryParams = UriComponent.decodeQuery(req.getUri().getRawQuery(), true);
        this.headers = new HashRequestHeaders(this.bareRequest.getHeaders());
        this.content = new Content();
    }

    Request(Request request) {
        this.bareRequest = request.bareRequest;
        this.webServer = request.webServer;
        this.context = request.context;
        this.queryParams = request.queryParams;
        this.headers = request.headers;
        this.content = new Content(request.content);
    }

    protected abstract Tracer tracer();

    @Override
    public WebServer webServer() {
        return this.webServer;
    }

    @Override
    public ContextualRegistry context() {
        return this.context;
    }

    @Override
    public Http.RequestMethod method() {
        return this.bareRequest.getMethod();
    }

    @Override
    public Http.Version version() {
        return this.bareRequest.getVersion();
    }

    @Override
    public URI uri() {
        return this.bareRequest.getUri();
    }

    @Override
    public String query() {
        return this.bareRequest.getUri().getRawQuery();
    }

    @Override
    public Parameters queryParams() {
        return this.queryParams;
    }

    @Override
    public String fragment() {
        return this.bareRequest.getUri().getFragment();
    }

    @Override
    public String localAddress() {
        return this.bareRequest.getLocalAddress();
    }

    @Override
    public int localPort() {
        return this.bareRequest.getLocalPort();
    }

    @Override
    public String remoteAddress() {
        return this.bareRequest.getRemoteAddress();
    }

    @Override
    public int remotePort() {
        return this.bareRequest.getRemotePort();
    }

    @Override
    public boolean isSecure() {
        return this.bareRequest.isSecure();
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }

    @Override
    public Content content() {
        return this.content;
    }

    @Override
    public long requestId() {
        return this.bareRequest.requestId();
    }

    private static CompletableFuture failedFuture(Throwable t) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(t);
        return result;
    }

    static class Path
    implements ServerRequest.Path {
        private final String path;
        private final Map<String, String> params;
        private final Path absolutePath;
        private List<String> segments;

        Path(String path, Map<String, String> params, Path absolutePath) {
            this.path = path;
            this.params = params == null ? Collections.emptyMap() : params;
            this.absolutePath = absolutePath;
        }

        @Override
        public String param(String name) {
            return this.params.get(name);
        }

        @Override
        public List<String> segments() {
            List<String> result = this.segments;
            if (result == null) {
                StringTokenizer stok = new StringTokenizer(this.path, "/");
                result = new ArrayList<String>();
                while (stok.hasMoreTokens()) {
                    result.add(stok.nextToken());
                }
                this.segments = result;
            }
            return result;
        }

        @Override
        public String toString() {
            return this.path;
        }

        @Override
        public Path absolute() {
            return this.absolutePath == null ? this : this.absolutePath;
        }

        static Path create(Path contextual, String path, Map<String, String> params) {
            if (contextual == null) {
                return new Path(path, params, null);
            }
            return contextual.createSubpath(path, params);
        }

        Path createSubpath(String path, Map<String, String> params) {
            if (params == null) {
                params = Collections.emptyMap();
            }
            if (this.absolutePath == null) {
                HashMap<String, String> map = new HashMap<String, String>(this.params.size() + params.size());
                map.putAll(this.params);
                map.putAll(params);
                return new Path(path, params, new Path(this.path, map, null));
            }
            HashMap<String, String> map = new HashMap<String, String>(this.params.size() + params.size() + this.absolutePath.params.size());
            map.putAll(this.absolutePath.params);
            map.putAll(this.params);
            map.putAll(params);
            return new Path(path, params, new Path(this.absolutePath.path, map, null));
        }
    }

    private static class InternalReader<T>
    implements ServerRequest.Reader<T> {
        private final Predicate<Class<?>> predicate;
        private final ServerRequest.Reader<T> reader;

        InternalReader(Predicate<Class<?>> predicate, ServerRequest.Reader<T> reader) {
            this.predicate = predicate;
            this.reader = reader;
        }

        public boolean accept(Class<?> o) {
            return o != null && this.predicate != null && this.predicate.test(o);
        }

        @Override
        public CompletionStage<? extends T> apply(Flow.Publisher<RequestChunk> publisher, Class<? super T> clazz) {
            return this.reader.apply(publisher, clazz);
        }
    }

    class Content
    implements ServerRequest.Content {
        private final Flow.Publisher<RequestChunk> originalPublisher;
        private final Deque<InternalReader<?>> readers;
        private final List<Function<Flow.Publisher<RequestChunk>, Flow.Publisher<RequestChunk>>> filters;
        private final ReadWriteLock readersLock;
        private final ReadWriteLock filtersLock;

        private Content() {
            this.originalPublisher = Request.this.bareRequest.bodyPublisher();
            this.readers = new LinkedList();
            this.filters = new ArrayList<Function<Flow.Publisher<RequestChunk>, Flow.Publisher<RequestChunk>>>();
            this.readersLock = new ReentrantReadWriteLock();
            this.filtersLock = new ReentrantReadWriteLock();
        }

        private Content(Content orig) {
            this.originalPublisher = orig.originalPublisher;
            this.readers = orig.readers;
            this.filters = orig.filters;
            this.readersLock = orig.readersLock;
            this.filtersLock = orig.filtersLock;
        }

        @Override
        public void registerFilter(Function<Flow.Publisher<RequestChunk>, Flow.Publisher<RequestChunk>> function) {
            Objects.requireNonNull(function, "Parameter 'function' is null!");
            try {
                this.filtersLock.writeLock().lock();
                this.filters.add(function);
            }
            finally {
                this.filtersLock.writeLock().unlock();
            }
        }

        @Override
        public <T> void registerReader(Class<T> type, ServerRequest.Reader<T> reader) {
            this.register(this.reader(type, reader));
        }

        @Override
        public <T> void registerReader(Predicate<Class<?>> predicate, ServerRequest.Reader<T> reader) {
            this.register(new InternalReader<T>(predicate, reader));
        }

        public <T> void register(InternalReader<T> reader) {
            try {
                this.readersLock.writeLock().lock();
                this.readers.addFirst(reader);
            }
            finally {
                this.readersLock.writeLock().unlock();
            }
        }

        private <T> InternalReader<T> reader(Class<T> clazz, ServerRequest.Reader<T> reader) {
            return new InternalReader<T>(aClass -> aClass.isAssignableFrom(clazz), reader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> CompletionStage<? extends T> as(Class<T> type) {
            CompletionStage result;
            Span readSpan = this.createReadSpan(type);
            try {
                this.readersLock.readLock().lock();
                result = this.readersWithDefaults().filter(reader -> reader.accept(type)).findFirst().map(reader -> reader.apply(this.chainPublishers(), type)).orElse(Request.failedFuture(new IllegalArgumentException("No reader found for class: " + type)));
            }
            catch (Exception e) {
                result = Request.failedFuture(new IllegalArgumentException("Transformation failed!", e));
            }
            finally {
                this.readersLock.readLock().unlock();
            }
            result.thenRun(() -> ((Span)readSpan).finish()).exceptionally(t -> {
                this.finishSpanWithError(readSpan, (Throwable)t);
                return null;
            });
            return result;
        }

        private void finishSpanWithError(Span readSpan, Throwable t) {
            Tags.ERROR.set(readSpan, Boolean.TRUE);
            readSpan.log(CollectionsHelper.mapOf((Object)"event", (Object)"error", (Object)"error.kind", (Object)"Exception", (Object)"error.object", (Object)t, (Object)"message", (Object)t.toString()));
            readSpan.finish();
        }

        private <T> Span createReadSpan(Class<T> type) {
            Tracer.SpanBuilder spanBuilder = Request.this.tracer().buildSpan("content-read");
            if (Request.this.span() != null) {
                spanBuilder.asChildOf(Request.this.span());
            }
            if (type != null) {
                spanBuilder.withTag("requested.type", type.getName());
            }
            return spanBuilder.start();
        }

        private Stream<InternalReader<?>> readersWithDefaults() {
            return Stream.concat(this.readers.stream(), Stream.of(this.reader(String.class, this.stringContentReader()), this.reader(byte[].class, ContentReaders.byteArrayReader()), this.reader(InputStream.class, ContentReaders.inputStreamReader())));
        }

        private StringContentReader stringContentReader() {
            String charset = StringContentReader.requestContentCharset(Request.this);
            StringContentReader reader = ContentReaders.cachedStringReader(charset);
            return reader != null ? reader : new StringContentReader(charset);
        }

        @Override
        public void subscribe(final Flow.Subscriber<? super RequestChunk> subscriber) {
            try {
                final Span readSpan = this.createReadSpan(Flow.Publisher.class);
                this.chainPublishers().subscribe((Flow.Subscriber)new Flow.Subscriber<RequestChunk>(){

                    public void onSubscribe(Flow.Subscription subscription) {
                        subscriber.onSubscribe(subscription);
                    }

                    public void onNext(RequestChunk item) {
                        subscriber.onNext((Object)item);
                    }

                    public void onError(Throwable throwable) {
                        try {
                            subscriber.onError(throwable);
                        }
                        finally {
                            Content.this.finishSpanWithError(readSpan, throwable);
                        }
                    }

                    public void onComplete() {
                        try {
                            subscriber.onComplete();
                        }
                        finally {
                            readSpan.finish();
                        }
                    }
                });
            }
            catch (Exception e) {
                subscriber.onError((Throwable)new IllegalArgumentException("Unexpected exception occurred during publishers chaining", e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Flow.Publisher<RequestChunk> chainPublishers() {
            Flow.Publisher<RequestChunk> lastPublisher = this.originalPublisher;
            try {
                this.filtersLock.readLock().lock();
                for (Function<Flow.Publisher<RequestChunk>, Flow.Publisher<RequestChunk>> filter : this.filters) {
                    lastPublisher = filter.apply(lastPublisher);
                }
            }
            finally {
                this.filtersLock.readLock().unlock();
            }
            return lastPublisher;
        }
    }
}

