/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.Http;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.MediaType;
import io.helidon.webserver.RequestHeaders;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class ContentTypeSelector {
    private static final Map<String, MediaType> CONTENT_TYPES = new TreeMap<String, MediaType>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, MediaType> specificContentTypes = new TreeMap<String, MediaType>(String.CASE_INSENSITIVE_ORDER);

    ContentTypeSelector(Map<String, MediaType> specificContentTypes) {
        if (specificContentTypes != null) {
            this.specificContentTypes.putAll(specificContentTypes);
        }
    }

    private static void putSingle(String extension, String contentTypeName) {
        CONTENT_TYPES.put(extension, MediaType.parse(contentTypeName));
    }

    private MediaType get(String filename) {
        if (filename == null) {
            return null;
        }
        int ind = filename.lastIndexOf(46);
        if (ind < 0) {
            return null;
        }
        String extension = filename.substring(ind + 1);
        MediaType result = this.specificContentTypes.get(extension);
        if (result == null) {
            result = CONTENT_TYPES.get(extension);
        }
        return result;
    }

    MediaType determine(String filename, RequestHeaders requestHeaders) {
        MediaType mediaType = this.get(filename);
        List<MediaType> accepted = requestHeaders.acceptedTypes();
        if (mediaType == null) {
            if (accepted.isEmpty()) {
                return MediaType.APPLICATION_OCTET_STREAM;
            }
            return accepted.get(0);
        }
        if (requestHeaders.isAccepted(mediaType)) {
            return mediaType;
        }
        throw new HttpException("Not accepted media-type!", Http.Status.NOT_FOUND_404);
    }

    static {
        ContentTypeSelector.putSingle("abs", "audio/x-mpeg");
        ContentTypeSelector.putSingle("ai", "application/postscript");
        ContentTypeSelector.putSingle("aif", "audio/x-aiff");
        ContentTypeSelector.putSingle("aifc", "audio/x-aiff");
        ContentTypeSelector.putSingle("aiff", "audio/x-aiff");
        ContentTypeSelector.putSingle("aim", "application/x-aim");
        ContentTypeSelector.putSingle("art", "image/x-jg");
        ContentTypeSelector.putSingle("asf", "video/x-ms-asf");
        ContentTypeSelector.putSingle("asx", "video/x-ms-asf");
        ContentTypeSelector.putSingle("au", "audio/basic");
        ContentTypeSelector.putSingle("avi", "video/x-msvideo");
        ContentTypeSelector.putSingle("avx", "video/x-rad-screenplay");
        ContentTypeSelector.putSingle("bcpio", "application/x-bcpio");
        ContentTypeSelector.putSingle("bin", "application/octet-stream");
        ContentTypeSelector.putSingle("bmp", "image/bmp");
        ContentTypeSelector.putSingle("body", "text/html");
        ContentTypeSelector.putSingle("cdf", "application/x-cdf");
        ContentTypeSelector.putSingle("cer", "application/x-x509-ca-cert");
        ContentTypeSelector.putSingle("class", "application/java");
        ContentTypeSelector.putSingle("cpio", "application/x-cpio");
        ContentTypeSelector.putSingle("csh", "application/x-csh");
        ContentTypeSelector.putSingle("css", "text/css");
        ContentTypeSelector.putSingle("dib", "image/bmp");
        ContentTypeSelector.putSingle("doc", "application/msword");
        ContentTypeSelector.putSingle("dtd", "application/xml-dtd");
        ContentTypeSelector.putSingle("dv", "video/x-dv");
        ContentTypeSelector.putSingle("dvi", "application/x-dvi");
        ContentTypeSelector.putSingle("eps", "application/postscript");
        ContentTypeSelector.putSingle("etx", "text/x-setext");
        ContentTypeSelector.putSingle("exe", "application/octet-stream");
        ContentTypeSelector.putSingle("gif", "image/gif");
        ContentTypeSelector.putSingle("gk", "application/octet-stream");
        ContentTypeSelector.putSingle("gtar", "application/x-gtar");
        ContentTypeSelector.putSingle("gz", "application/x-gzip");
        ContentTypeSelector.putSingle("hdf", "application/x-hdf");
        ContentTypeSelector.putSingle("hqx", "application/mac-binhex40");
        ContentTypeSelector.putSingle("htc", "text/x-component");
        ContentTypeSelector.putSingle("htm", "text/html");
        ContentTypeSelector.putSingle("html", "text/html");
        ContentTypeSelector.putSingle("hqx", "application/mac-binhex40");
        ContentTypeSelector.putSingle("ief", "image/ief");
        ContentTypeSelector.putSingle("jad", "text/vnd.sun.j2me.app-descriptor");
        ContentTypeSelector.putSingle("jar", "application/java-archive");
        ContentTypeSelector.putSingle("java", "text/plain");
        ContentTypeSelector.putSingle("jnlp", "application/x-java-jnlp-file");
        ContentTypeSelector.putSingle("jpe", "image/jpeg");
        ContentTypeSelector.putSingle("jpeg", "image/jpeg");
        ContentTypeSelector.putSingle("jpg", "image/jpeg");
        ContentTypeSelector.putSingle("js", "text/javascript");
        ContentTypeSelector.putSingle("kar", "audio/x-midi");
        ContentTypeSelector.putSingle("latex", "application/x-latex");
        ContentTypeSelector.putSingle("m3u", "audio/x-mpegurl");
        ContentTypeSelector.putSingle("mac", "image/x-macpaint");
        ContentTypeSelector.putSingle("man", "application/x-troff-man");
        ContentTypeSelector.putSingle("mathml", "application/mathml+xml");
        ContentTypeSelector.putSingle("me", "application/x-troff-me");
        ContentTypeSelector.putSingle("mid", "audio/x-midi");
        ContentTypeSelector.putSingle("midi", "audio/x-midi");
        ContentTypeSelector.putSingle("mif", "application/x-mif");
        ContentTypeSelector.putSingle("mov", "video/quicktime");
        ContentTypeSelector.putSingle("movie", "video/x-sgi-movie");
        ContentTypeSelector.putSingle("mp1", "audio/x-mpeg");
        ContentTypeSelector.putSingle("mp2", "audio/x-mpeg");
        ContentTypeSelector.putSingle("mp3", "audio/x-mpeg");
        ContentTypeSelector.putSingle("mpa", "audio/x-mpeg");
        ContentTypeSelector.putSingle("mpe", "video/mpeg");
        ContentTypeSelector.putSingle("mpeg", "video/mpeg");
        ContentTypeSelector.putSingle("mpega", "audio/x-mpeg");
        ContentTypeSelector.putSingle("mpg", "video/mpeg");
        ContentTypeSelector.putSingle("mpv2", "video/mpeg2");
        ContentTypeSelector.putSingle("ms", "application/x-wais-source");
        ContentTypeSelector.putSingle("nc", "application/x-netcdf");
        ContentTypeSelector.putSingle("oda", "application/oda");
        ContentTypeSelector.putSingle("ogg", "application/ogg");
        ContentTypeSelector.putSingle("pbm", "image/x-portable-bitmap");
        ContentTypeSelector.putSingle("pct", "image/pict");
        ContentTypeSelector.putSingle("pdf", "application/pdf");
        ContentTypeSelector.putSingle("pgm", "image/x-portable-graymap");
        ContentTypeSelector.putSingle("pic", "image/pict");
        ContentTypeSelector.putSingle("pict", "image/pict");
        ContentTypeSelector.putSingle("pls", "audio/x-scpls");
        ContentTypeSelector.putSingle("png", "image/png");
        ContentTypeSelector.putSingle("pnm", "image/x-portable-anymap");
        ContentTypeSelector.putSingle("pnt", "image/x-macpaint");
        ContentTypeSelector.putSingle("ppm", "image/x-portable-pixmap");
        ContentTypeSelector.putSingle("ppt", "application/powerpoint");
        ContentTypeSelector.putSingle("ps", "application/postscript");
        ContentTypeSelector.putSingle("psd", "image/x-photoshop");
        ContentTypeSelector.putSingle("qt", "video/quicktime");
        ContentTypeSelector.putSingle("qti", "image/x-quicktime");
        ContentTypeSelector.putSingle("qtif", "image/x-quicktime");
        ContentTypeSelector.putSingle("ras", "image/x-cmu-raster");
        ContentTypeSelector.putSingle("rdf", "application/rdf+xml");
        ContentTypeSelector.putSingle("rgb", "image/x-rgb");
        ContentTypeSelector.putSingle("rm", "application/vnd.rn-realmedia");
        ContentTypeSelector.putSingle("roff", "application/x-troff");
        ContentTypeSelector.putSingle("rtf", "application/rtf");
        ContentTypeSelector.putSingle("rtx", "text/richtext");
        ContentTypeSelector.putSingle("sh", "application/x-sh");
        ContentTypeSelector.putSingle("shar", "application/x-shar");
        ContentTypeSelector.putSingle("shtml", "text/x-server-parsed-html");
        ContentTypeSelector.putSingle("sit", "application/x-stuffit");
        ContentTypeSelector.putSingle("smf", "audio/x-midi");
        ContentTypeSelector.putSingle("snd", "audio/basic");
        ContentTypeSelector.putSingle("src", "application/x-wais-source");
        ContentTypeSelector.putSingle("sv4cpio", "application/x-sv4cpio");
        ContentTypeSelector.putSingle("sv4crc", "application/x-sv4crc");
        ContentTypeSelector.putSingle("svg", "image/svg+xml");
        ContentTypeSelector.putSingle("svgz", "image/svg+xml");
        ContentTypeSelector.putSingle("swf", "application/x-shockwave-flash");
        ContentTypeSelector.putSingle("t", "application/x-troff");
        ContentTypeSelector.putSingle("tar", "application/x-tar");
        ContentTypeSelector.putSingle("tcl", "application/x-tcl");
        ContentTypeSelector.putSingle("tex", "application/x-tex");
        ContentTypeSelector.putSingle("texi", "application/x-texinfo");
        ContentTypeSelector.putSingle("texinfo", "application/x-texinfo");
        ContentTypeSelector.putSingle("tif", "image/tiff");
        ContentTypeSelector.putSingle("tiff", "image/tiff");
        ContentTypeSelector.putSingle("tr", "application/x-troff");
        ContentTypeSelector.putSingle("tsv", "text/tab-separated-values");
        ContentTypeSelector.putSingle("txt", "text/plain");
        ContentTypeSelector.putSingle("ulw", "audio/basic");
        ContentTypeSelector.putSingle("ustar", "application/x-ustar");
        ContentTypeSelector.putSingle("xbm", "image/x-xbitmap");
        ContentTypeSelector.putSingle("xml", "application/xml");
        ContentTypeSelector.putSingle("xpm", "image/x-xpixmap");
        ContentTypeSelector.putSingle("xsl", "application/xml");
        ContentTypeSelector.putSingle("xslt", "application/xslt+xml");
        ContentTypeSelector.putSingle("xwd", "image/x-xwindowdump");
        ContentTypeSelector.putSingle("vsd", "application/x-visio");
        ContentTypeSelector.putSingle("vxml", "application/voicexml+xml");
        ContentTypeSelector.putSingle("wav", "audio/x-wav");
        ContentTypeSelector.putSingle("wbmp", "image/vnd.wap.wbmp");
        ContentTypeSelector.putSingle("wml", "text/vnd.wap.wml");
        ContentTypeSelector.putSingle("wmlc", "application/vnd.wap.wmlc");
        ContentTypeSelector.putSingle("wmls", "text/vnd.wap.wmls");
        ContentTypeSelector.putSingle("wmlscriptc", "application/vnd.wap.wmlscriptc");
        ContentTypeSelector.putSingle("wrl", "x-world/x-vrml");
        ContentTypeSelector.putSingle("xht", "application/xhtml+xml");
        ContentTypeSelector.putSingle("xhtml", "application/xhtml+xml");
        ContentTypeSelector.putSingle("xls", "application/vnd.ms-excel");
        ContentTypeSelector.putSingle("xul", "application/vnd.mozilla.xul+xml");
        ContentTypeSelector.putSingle("Z", "application/x-compress");
        ContentTypeSelector.putSingle("z", "application/x-compress");
        ContentTypeSelector.putSingle("zip", "application/zip");
        ContentTypeSelector.putSingle("json", "application/json");
    }
}

