/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.AlreadyCompletedException;
import io.helidon.webserver.Headers;
import io.helidon.webserver.Http;
import io.helidon.webserver.MediaType;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public interface ResponseHeaders
extends Headers {
    public List<MediaType> acceptPatches();

    public void addAcceptPatches(MediaType ... var1) throws AlreadyCompletedException;

    public Optional<MediaType> contentType();

    public void contentType(MediaType var1) throws AlreadyCompletedException;

    public OptionalLong contentLength();

    public void contentLength(long var1) throws AlreadyCompletedException;

    public Optional<ZonedDateTime> expires();

    public void expires(ZonedDateTime var1) throws AlreadyCompletedException;

    public void expires(Instant var1) throws AlreadyCompletedException;

    public Optional<ZonedDateTime> lastModified();

    public void lastModified(ZonedDateTime var1) throws AlreadyCompletedException;

    public void lastModified(Instant var1) throws AlreadyCompletedException;

    public Optional<URI> location();

    public void location(URI var1) throws AlreadyCompletedException;

    public void addCookie(String var1, String var2) throws AlreadyCompletedException, NullPointerException;

    public void addCookie(String var1, String var2, Duration var3) throws AlreadyCompletedException, NullPointerException;

    public void addCookie(SetCookie var1) throws NullPointerException;

    public void beforeSend(Consumer<ResponseHeaders> var1);

    public CompletionStage<ResponseHeaders> whenSend();

    public CompletionStage<ResponseHeaders> send();

    public static class SetCookie {
        private static final String PARAM_SEPARATOR = "; ";
        private final String name;
        private final String value;
        private ZonedDateTime expires;
        private Duration maxAge;
        private String domain;
        private String path;
        private boolean secure;
        private boolean httpOnly;

        public SetCookie(String name, String value) {
            Objects.requireNonNull(name, "Parameter 'name' is null!");
            this.name = name;
            this.value = value;
        }

        SetCookie expires(ZonedDateTime expires) {
            this.expires = expires;
            return this;
        }

        SetCookie expires(Instant expires) {
            this.expires = expires == null ? null : ZonedDateTime.ofInstant(expires, ZoneId.systemDefault());
            return this;
        }

        SetCookie maxAge(Duration maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        SetCookie domain(String domain) {
            this.domain = domain;
            return this;
        }

        SetCookie path(String path) {
            this.path = path;
            return this;
        }

        SetCookie domainAndPath(URI domainAndPath) {
            if (domainAndPath == null) {
                this.domain = null;
                this.path = null;
            } else {
                this.domain = domainAndPath.getHost();
                this.path = domainAndPath.getPath();
            }
            return this;
        }

        SetCookie secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        SetCookie httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.name).append('=').append(this.value);
            if (this.expires != null) {
                result.append(PARAM_SEPARATOR);
                result.append("Expires=");
                result.append(this.expires.format(Http.DateTime.RFC_1123_DATE_TIME));
            }
            if (this.maxAge != null && !this.maxAge.isNegative() && !this.maxAge.isZero()) {
                result.append(PARAM_SEPARATOR);
                result.append("Max-Age=");
                result.append(this.maxAge.getSeconds());
            }
            if (this.domain != null) {
                result.append(PARAM_SEPARATOR);
                result.append("Domain=");
                result.append(this.domain);
            }
            if (this.path != null) {
                result.append(PARAM_SEPARATOR);
                result.append("Path=");
                result.append(this.path);
            }
            if (this.secure) {
                result.append(PARAM_SEPARATOR);
                result.append("Secure");
            }
            if (this.httpOnly) {
                result.append(PARAM_SEPARATOR);
                result.append("HttpOnly");
            }
            return result.toString();
        }
    }
}

