/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.OptionalHelper;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.ReactiveStreamsAdapter;
import io.helidon.webserver.ContentWriters;
import io.helidon.webserver.HashResponseHeaders;
import io.helidon.webserver.Http;
import io.helidon.webserver.MediaType;
import io.helidon.webserver.ResponseChunk;
import io.helidon.webserver.ResponseHeaders;
import io.helidon.webserver.SendHeadersFirstPublisher;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.spi.BareResponse;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

abstract class Response
implements ServerResponse {
    private final WebServer webServer;
    private final BareResponse bareResponse;
    private final HashResponseHeaders headers;
    private final CompletionStage<ServerResponse> completionStage;
    private final SendLockSupport sendLockSupport;
    private final ArrayList<Writer> writers;
    private final ArrayList<Function<Flow.Publisher<ResponseChunk>, Flow.Publisher<ResponseChunk>>> filters;

    Response(WebServer webServer, BareResponse bareResponse) {
        this.webServer = webServer;
        this.bareResponse = bareResponse;
        this.headers = new HashResponseHeaders(bareResponse);
        this.completionStage = bareResponse.whenCompleted().thenApply(a -> this);
        this.sendLockSupport = new SendLockSupport();
        this.writers = new ArrayList<Writer>(this.defaultWriters());
        this.filters = new ArrayList();
    }

    Response(Response response) {
        this.webServer = response.webServer;
        this.bareResponse = response.bareResponse;
        this.headers = response.headers;
        this.completionStage = response.completionStage;
        this.sendLockSupport = response.sendLockSupport;
        this.writers = response.writers;
        this.filters = response.filters;
    }

    private Collection<Writer> defaultWriters() {
        Writer<byte[]> byteArrayWriter = new Writer<byte[]>(byte[].class, null, ContentWriters.byteArrayWriter(true));
        Writer<CharSequence> charSequenceWriter = new Writer<CharSequence>(CharSequence.class, null, s -> {
            MediaType mediaType = this.headers.contentType().orElse(MediaType.TEXT_PLAIN);
            String charset = mediaType.getCharset().orElse(StandardCharsets.UTF_8.name());
            this.headers.contentType(mediaType.withCharset(charset));
            return ContentWriters.charSequenceWriter(Charset.forName(charset)).apply((CharSequence)s);
        });
        Writer<ReadableByteChannel> byteChannelWriter = new Writer<ReadableByteChannel>(ReadableByteChannel.class, null, ContentWriters.byteChannelWriter());
        Writer<Path> pathWriter = new Writer<Path>(Path.class, null, path -> {
            try {
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new IllegalArgumentException("File path argument doesn't exist!");
                }
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    throw new IllegalArgumentException("File path argument isn't a file!");
                }
                if (!Files.isReadable(path)) {
                    throw new IllegalArgumentException("File path argument isn't readable!");
                }
                try {
                    this.headers.contentLength(Files.size(path));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);
                return ContentWriters.byteChannelWriter().apply(fc);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read a file!", e);
            }
        });
        Writer<File> fileWriter = new Writer<File>(File.class, null, file -> (Flow.Publisher)((Writer)pathWriter).function.apply(file.toPath()));
        return Arrays.asList(byteArrayWriter, charSequenceWriter, byteChannelWriter, pathWriter, fileWriter);
    }

    abstract SpanContext spanContext();

    @Override
    public WebServer webServer() {
        return this.webServer;
    }

    @Override
    public Http.ResponseStatus status() {
        return this.headers.httpStatus();
    }

    @Override
    public Response status(Http.ResponseStatus status) {
        Objects.requireNonNull(status, "Parameter 'status' was null!");
        this.headers.httpStatus(status);
        return this;
    }

    @Override
    public ResponseHeaders headers() {
        return this.headers;
    }

    private Tracer tracer() {
        ServerConfiguration configuration;
        Tracer result = null;
        if (this.webServer != null && (configuration = this.webServer.configuration()) != null) {
            result = configuration.tracer();
        }
        return result == null ? GlobalTracer.get() : result;
    }

    private <T> Span createWriteSpan(T obj) {
        Tracer.SpanBuilder spanBuilder = this.tracer().buildSpan("content-write");
        if (this.spanContext() != null) {
            spanBuilder.asChildOf(this.spanContext());
        }
        if (obj != null) {
            spanBuilder.withTag("response.type", obj.getClass().getName());
        }
        return spanBuilder.start();
    }

    @Override
    public <T> CompletionStage<ServerResponse> send(T content) {
        Span writeSpan = this.createWriteSpan(content);
        try {
            this.sendLockSupport.execute(() -> {
                Flow.Publisher<ResponseChunk> publisher = this.createPublisherUsingWriter(content);
                if (publisher == null) {
                    throw new IllegalArgumentException("Cannot write! No registered writer for '" + content.getClass().toString() + "'.");
                }
                Flow.Publisher<ResponseChunk> p = this.applyFilters(publisher, writeSpan);
                this.sendLockSupport.contentSend = true;
                p.subscribe((Flow.Subscriber)this.bareResponse);
            }, content == null);
            return this.whenSent();
        }
        catch (Error | RuntimeException e) {
            writeSpan.finish();
            throw e;
        }
    }

    @Override
    public CompletionStage<ServerResponse> send(Flow.Publisher<ResponseChunk> content) {
        Span writeSpan = this.createWriteSpan(content);
        try {
            Flow.Publisher publisher = content == null ? ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.empty()) : content;
            this.sendLockSupport.execute(() -> {
                Flow.Publisher<ResponseChunk> p = this.applyFilters((Flow.Publisher<ResponseChunk>)publisher, writeSpan);
                this.sendLockSupport.contentSend = true;
                p.subscribe((Flow.Subscriber)this.bareResponse);
            }, content == null);
            return this.whenSent();
        }
        catch (Error | RuntimeException e) {
            writeSpan.finish();
            throw e;
        }
    }

    @Override
    public CompletionStage<ServerResponse> send() {
        return this.send(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Flow.Publisher<ResponseChunk> createPublisherUsingWriter(T content) {
        if (content == null) {
            return ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.empty());
        }
        SendLockSupport sendLockSupport = this.sendLockSupport;
        synchronized (sendLockSupport) {
            for (int i = this.writers.size() - 1; i >= 0; --i) {
                Writer writer = this.writers.get(i);
                if (!writer.accept(content)) continue;
                Flow.Publisher result = (Flow.Publisher)writer.function.apply(content);
                if (result == null) break;
                return result;
            }
        }
        return null;
    }

    @Override
    public <T> Response registerWriter(Class<T> type, Function<T, Flow.Publisher<ResponseChunk>> function) {
        return this.registerWriter((Class)type, (MediaType)null, (Function)function);
    }

    @Override
    public <T> Response registerWriter(Class<T> type, MediaType contentType, Function<? extends T, Flow.Publisher<ResponseChunk>> function) {
        this.sendLockSupport.execute(() -> this.writers.add(new Writer(type, contentType, function)), false);
        return this;
    }

    @Override
    public <T> Response registerWriter(Predicate<?> accept, Function<T, Flow.Publisher<ResponseChunk>> function) {
        return this.registerWriter((Predicate)accept, (MediaType)null, (Function)function);
    }

    @Override
    public <T> Response registerWriter(Predicate<?> accept, MediaType contentType, Function<T, Flow.Publisher<ResponseChunk>> function) {
        this.sendLockSupport.execute(() -> this.writers.add(new Writer(accept, contentType, function)), false);
        return this;
    }

    @Override
    public Response registerFilter(Function<Flow.Publisher<ResponseChunk>, Flow.Publisher<ResponseChunk>> function) {
        Objects.requireNonNull(function, "Parameter 'function' is null!");
        this.sendLockSupport.execute(() -> this.filters.add(function), false);
        return this;
    }

    Flow.Publisher<ResponseChunk> applyFilters(Flow.Publisher<ResponseChunk> publisher, Span span) {
        Objects.requireNonNull(publisher, "Parameter 'publisher' is null!");
        for (Function<Flow.Publisher<ResponseChunk>, Flow.Publisher<ResponseChunk>> filter : this.filters) {
            Flow.Publisher<ResponseChunk> p = filter.apply(publisher);
            if (p == null) continue;
            publisher = p;
        }
        return new SendHeadersFirstPublisher<ResponseChunk>(this.headers, span, publisher);
    }

    @Override
    public CompletionStage<ServerResponse> whenSent() {
        return this.completionStage;
    }

    @Override
    public long requestId() {
        return this.bareResponse.requestId();
    }

    private static class SendLockSupport {
        private boolean contentSend = false;

        private SendLockSupport() {
        }

        private synchronized void execute(Runnable runnable, boolean silentSendStatus) {
            if (this.contentSend) {
                if (silentSendStatus) {
                    return;
                }
                throw new IllegalStateException("Response is already sent!");
            }
            runnable.run();
        }
    }

    class Writer<T> {
        private final Predicate<Object> acceptPredicate;
        private final MediaType requestedContentType;
        private final Function<T, Flow.Publisher<ResponseChunk>> function;

        Writer(Predicate acceptPredicate, MediaType contentType, Function<T, Flow.Publisher<ResponseChunk>> function) {
            Objects.requireNonNull(function, "Parameter function is null!");
            this.acceptPredicate = acceptPredicate == null ? o -> true : acceptPredicate;
            this.requestedContentType = contentType;
            this.function = function;
        }

        Writer(Class<?> acceptType, MediaType contentType, Function<T, Flow.Publisher<ResponseChunk>> function) {
            this(acceptType == null ? null : o -> acceptType.isAssignableFrom(o.getClass()), contentType, function);
        }

        boolean accept(Object o) {
            if (o == null || !this.acceptPredicate.test(o)) {
                return false;
            }
            return this.requestedContentType == null || OptionalHelper.from(Response.this.headers().contentType()).or(() -> {
                try {
                    Response.this.headers.contentType(this.requestedContentType);
                    return Optional.of(this.requestedContentType);
                }
                catch (Exception e) {
                    return Optional.empty();
                }
            }).asOptional().filter(this.requestedContentType).isPresent();
        }
    }
}

